/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.UUID;
import java.util.zip.CRC32;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mx.StringUtils;
import org.mx.TypeUtils;
import org.mx.sm.SM3Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigestUtils {
    private static final Logger logger = LoggerFactory.getLogger(DigestUtils.class);

    private DigestUtils() {
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static int crc16(byte[] bytes) {
        int CRC16 = 65535;
        int POLYNOMIAL = 40961;
        for (int i = 0; i < bytes.length; ++i) {
            CRC16 ^= bytes[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((CRC16 & 1) != 0) {
                    CRC16 >>= 1;
                    CRC16 ^= POLYNOMIAL;
                    continue;
                }
                CRC16 >>= 1;
            }
        }
        return CRC16;
    }

    public static long crc32(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        if (bytes != null) {
            crc32.update(bytes);
        }
        return crc32.getValue();
    }

    public static String toBase64(byte[] input) {
        if (input == null || input.length <= 0) {
            return "";
        }
        return Base64.getEncoder().encodeToString(input);
    }

    public static byte[] fromBase64(String base64) {
        if (StringUtils.isBlank(base64)) {
            return new byte[0];
        }
        return Base64.getDecoder().decode(base64);
    }

    private static String digest(String digestAlgorithm, EncodeType encodeType, String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        digest.update(input.getBytes());
        return DigestUtils.encodeString(encodeType, digest.digest());
    }

    private static String encodeString(EncodeType encodeType, byte[] input) throws NoSuchAlgorithmException {
        switch (encodeType) {
            case BASE64: {
                return Base64.getEncoder().encodeToString(input);
            }
            case HEX: {
                return TypeUtils.byteArray2HexString(input);
            }
        }
        if (logger.isErrorEnabled()) {
            logger.error(String.format("The encode algorithm['%s'] not supported.", new Object[]{encodeType}));
        }
        throw new NoSuchAlgorithmException();
    }

    public static void importCert2Keystore(String keystorePath, String password, String host, int port) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream fin = new FileInputStream(new File(keystorePath));
            keyStore.load(fin, password.toCharArray());
            fin.close();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            X509TrustManager x509TrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            SavingTrustManager savingTrustManager = new SavingTrustManager(x509TrustManager);
            sslContext.init(null, new TrustManager[]{savingTrustManager}, null);
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(host, port);
            sslSocket.setSoTimeout(10000);
            try {
                sslSocket.startHandshake();
                sslSocket.close();
                System.out.println("The certificate is already trusted.");
                return;
            }
            catch (Exception ex) {
                System.out.println("The certificate is not be trusted.");
                X509Certificate[] chain = savingTrustManager.chain;
                if (chain == null) {
                    System.out.println("Could not obtain server certificate chain.");
                    return;
                }
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                int index = 1;
                for (X509Certificate cert : chain) {
                    System.out.println(String.format("Cert %d, subject: %s, issuer: %s.", index++, cert.getSubjectDN(), cert.getIssuerDN()));
                    sha1.update(cert.getEncoded());
                    md5.update(cert.getEncoded());
                }
                System.out.println("Select a certificate for import: [1]");
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                while (true) {
                    String line = reader.readLine().trim();
                    try {
                        index = Integer.parseInt(line);
                        X509Certificate cert = chain[index];
                        keyStore.setCertificateEntry(host, cert);
                        FileOutputStream fout = new FileOutputStream(keystorePath);
                        keyStore.store(fout, password.toCharArray());
                        fout.flush();
                        fout.close();
                        System.out.println(String.format("Import certificate successfully, subject: %s, issuer: %s.", chain[index].getSubjectDN(), chain[index].getIssuerDN()));
                        return;
                    }
                    catch (NumberFormatException ex2) {
                        System.out.println(String.format("The number[%s] format invalid.", line));
                        ex2.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }
        catch (KeyStoreException ex) {
            System.out.println(String.format("Keystore[%s] operate fail.", keystorePath));
            ex.printStackTrace();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.format("The file[%s] not found.", keystorePath));
            ex.printStackTrace();
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            System.out.println(String.format("Load keystore[%s] fail.", keystorePath));
            ex.printStackTrace();
        }
        catch (KeyManagementException ex) {
            System.out.println("Init the SSL context fail.");
            ex.printStackTrace();
        }
    }

    public static String md5(String src) throws NoSuchAlgorithmException {
        return DigestUtils.md5(src, EncodeType.BASE64);
    }

    public static String md5(String src, EncodeType encodeType) throws NoSuchAlgorithmException {
        return DigestUtils.digest("MD5", encodeType, src);
    }

    public static String sha1(String src) throws NoSuchAlgorithmException {
        return DigestUtils.sha1(src, EncodeType.BASE64);
    }

    public static String sha1(String src, EncodeType encodeType) throws NoSuchAlgorithmException {
        return DigestUtils.digest("SHA1", encodeType, src);
    }

    public static String sha256(String src) throws NoSuchAlgorithmException {
        return DigestUtils.sha256(src, EncodeType.BASE64);
    }

    public static String sha256(String src, EncodeType encodeType) throws NoSuchAlgorithmException {
        return DigestUtils.digest("SHA256", encodeType, src);
    }

    public static String sm3(String src) throws UnsupportedEncodingException {
        return DigestUtils.sm3(src, EncodeType.BASE64);
    }

    public static String sm3(String src, EncodeType encodeType) throws UnsupportedEncodingException {
        byte[] md = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(src.getBytes("UTF-8"), 0, src.length());
        sm3.doFinal(md, 0);
        return encodeType == EncodeType.BASE64 ? TypeUtils.byteArray2Base64(md) : TypeUtils.byteArray2HexString(md);
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }

    public static enum EncodeType {
        BASE64,
        HEX;

    }
}

