/*
 * Decompiled with CFR 0.152.
 */
package org.mx;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static boolean FIRST_DAY_IS_MONDAY = true;
    public static boolean JANUARY_IS_ZERO = true;

    private DateUtils() {
    }

    public static Instant from(Date date) {
        return Instant.ofEpochMilli(date.getTime());
    }

    public static Date from(Instant instant) {
        return new Date(instant.toEpochMilli());
    }

    public static Date from(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Date from(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static int get(Date date, FieldType field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
        calendar.setTimeInMillis(date.getTime());
        switch (field) {
            case YEAR: {
                return calendar.get(1);
            }
            case MONTH: {
                return calendar.get(2) + 1;
            }
            case DAY: {
                return calendar.get(5);
            }
            case HOUR: {
                return calendar.get(11);
            }
            case MINUTE: {
                return calendar.get(12);
            }
            case SECOND: {
                return calendar.get(13);
            }
            case MILLISECOND: {
                return calendar.get(14);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported field type: %s.", new Object[]{field}));
    }

    public static LocalDate toLocalDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalTime();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        LocalDate localDate = DateUtils.toLocalDate(date);
        LocalTime localTime = DateUtils.toLocalTime(date);
        return LocalDateTime.of(localDate, localTime);
    }

    public static Date add(Date date, FieldType field, int amount) {
        LocalDateTime localDateTime = DateUtils.toLocalDateTime(date);
        localDateTime = DateUtils.add(localDateTime, field, amount);
        return DateUtils.from(localDateTime);
    }

    public static LocalDateTime add(LocalDateTime localDateTime, FieldType field, int amount) {
        switch (field) {
            case YEAR: {
                localDateTime = localDateTime.plusYears(amount);
                break;
            }
            case MONTH: {
                localDateTime = localDateTime.plusMonths(amount);
                break;
            }
            case DAY: {
                localDateTime = localDateTime.plusDays(amount);
                break;
            }
            case HOUR: {
                localDateTime = localDateTime.plusHours(amount);
                break;
            }
            case MINUTE: {
                localDateTime = localDateTime.plusMinutes(amount);
                break;
            }
            case SECOND: {
                localDateTime = localDateTime.plusSeconds(amount);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported field type: %s.", new Object[]{field}));
            }
        }
        return localDateTime;
    }

    public static String formatElapseTime(int elapseTime) {
        int[] units = new int[]{60, 60, 24};
        int[] number = new int[]{0, 0, 0, elapseTime / 24 / 3600};
        elapseTime -= number[3] * 24 * 3600;
        String[] names = new String[]{"\u79d2", "\u5206", "\u5c0f\u65f6", "\u5929"};
        for (int index = 0; index < 3; ++index) {
            number[index] = elapseTime % units[index];
            elapseTime = (elapseTime - number[index]) / units[index];
        }
        StringBuffer sb = new StringBuffer();
        for (int index = 3; index >= 0; --index) {
            if (number[index] <= 0) continue;
            sb.append(number[index]);
            sb.append(names[index]);
        }
        return sb.toString();
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        DateTimeFormatter format = DateTimeFormatter.ofPattern(pattern);
        return format.format(DateUtils.toLocalDateTime(date));
    }

    public static Date parse(String dateString, String pattern) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern(pattern);
        TemporalAccessor temporalAccessor = format.parse(dateString);
        return DateUtils.from(LocalDateTime.from(temporalAccessor));
    }

    public static String get10Date(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd");
    }

    public static String get10DateNow() {
        return DateUtils.get10Date(new Date());
    }

    public static String get12Time(Date date) {
        return DateUtils.format(date, "HH:mm:ss.n");
    }

    public static String get12TimeNow() {
        return DateUtils.get12Time(new Date());
    }

    public static String get19Date(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String get19DateNow() {
        return DateUtils.get19Date(new Date());
    }

    public static String get23Date(Date date) {
        return DateUtils.format(date, "yyyy-MM-dd HH:mm:ss.n");
    }

    public static String get23DateNow() {
        return DateUtils.get23Date(new Date());
    }

    public static String get5Time(Date date) {
        return DateUtils.format(date, "HH:mm");
    }

    public static String get5TimeNow() {
        return DateUtils.get5Time(new Date());
    }

    public static String get8Time(Date date) {
        return DateUtils.format(date, "HH:mm:ss");
    }

    public static String get8TimeNow() {
        return DateUtils.get8Time(new Date());
    }

    public static Date mergeDateTime(Date date, Date time) {
        LocalDate localDate = DateUtils.toLocalDate(date);
        LocalTime localTime = DateUtils.toLocalTime(time);
        return DateUtils.from(DateUtils.mergeDateTime(localDate, localTime));
    }

    public static LocalDateTime mergeDateTime(LocalDate localDate, LocalTime localTime) {
        return LocalDateTime.of(localDate, localTime);
    }

    public static Long date2Long(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static Date long2Date(Long time) {
        if (time == null) {
            return null;
        }
        return new Date(time);
    }

    public static class DatetimeRange {
        private long lowerLimit;
        private long upperLimit;

        public static DatetimeRange of(long lowerLimit, long upperLimit) {
            return lowerLimit <= upperLimit ? new DatetimeRange(lowerLimit, upperLimit) : new DatetimeRange(upperLimit, lowerLimit);
        }

        private DatetimeRange(long lowerLimit, long upperLimit) {
            this.lowerLimit = lowerLimit;
            this.upperLimit = upperLimit;
        }

        private static DatetimeRange create(int ... params) {
            if (params == null || params.length <= 0 || params.length > 6) {
                throw new IllegalArgumentException();
            }
            LocalDateTime dateTime = LocalDateTime.of(0, 1, 1, 0, 0, 0, 0);
            LocalDateTime dateTime1 = null;
            int length = params.length;
            switch (length) {
                case 6: {
                    dateTime = dateTime.withSecond(params[5]);
                }
                case 5: {
                    dateTime = dateTime.withMinute(params[4]);
                }
                case 4: {
                    dateTime = dateTime.withHour(params[3]);
                }
                case 3: {
                    dateTime = dateTime.withDayOfMonth(params[2]);
                }
                case 2: {
                    dateTime = JANUARY_IS_ZERO ? dateTime.withMonth(params[1] + 1) : dateTime.withMonth(params[1]);
                }
                case 1: {
                    dateTime = dateTime.withYear(params[0]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupport %d params.", length));
                }
            }
            switch (length) {
                case 6: {
                    dateTime1 = dateTime.plusSeconds(1L).minusNanos(1L);
                    break;
                }
                case 5: {
                    dateTime1 = dateTime.plusMinutes(1L).minusNanos(1L);
                    break;
                }
                case 4: {
                    dateTime1 = dateTime.plusHours(1L).minusNanos(1L);
                    break;
                }
                case 3: {
                    dateTime1 = dateTime.plusDays(1L).minusNanos(1L);
                    break;
                }
                case 2: {
                    dateTime1 = dateTime.plusMonths(1L).minusNanos(1L);
                    break;
                }
                default: {
                    dateTime1 = dateTime.plusYears(1L).minusNanos(1L);
                }
            }
            return new DatetimeRange(DateUtils.from(dateTime).getTime(), DateUtils.from(dateTime1).getTime());
        }

        public static DatetimeRange lastWeek() {
            return DatetimeRange.rangeWeek(LocalDate.now().minusWeeks(1L));
        }

        public static DatetimeRange lastMonth() {
            LocalDate lastDate = LocalDate.now().minusMonths(1L);
            return DatetimeRange.range(lastDate.getYear(), lastDate.getMonthValue());
        }

        public static DatetimeRange lastYear() {
            return DatetimeRange.range(LocalDate.now().getYear() - 1);
        }

        public static DatetimeRange currentWeek() {
            return DatetimeRange.rangeWeek(LocalDate.now());
        }

        public static DatetimeRange currentMonth() {
            LocalDate now = LocalDate.now();
            return DatetimeRange.range(now.getYear(), now.getMonthValue());
        }

        public static DatetimeRange currentYear() {
            return DatetimeRange.range(LocalDate.now().getYear());
        }

        public static DatetimeRange nextWeek() {
            return DatetimeRange.rangeWeek(LocalDate.now().plusWeeks(1L));
        }

        public static DatetimeRange nextMonth() {
            LocalDate nextDate = LocalDate.now().plusMonths(1L);
            return DatetimeRange.range(nextDate.getYear(), nextDate.getMonthValue());
        }

        public static DatetimeRange nextYear() {
            return DatetimeRange.range(LocalDate.now().getYear() + 1);
        }

        public static DatetimeRange range(int year) {
            return DatetimeRange.create(year);
        }

        public static DatetimeRange range(int year, int month) {
            return DatetimeRange.create(year, month);
        }

        public static DatetimeRange range(int year, int month, int day) {
            return DatetimeRange.create(year, month, day);
        }

        private static DatetimeRange rangeWeek(LocalDate localDate) {
            LocalDateTime date0 = LocalDateTime.of(localDate, LocalTime.of(0, 0, 0, 0));
            LocalDateTime date1 = LocalDateTime.of(localDate, LocalTime.of(23, 59, 59, 999999999));
            int days = date0.getDayOfWeek().getValue();
            if (!FIRST_DAY_IS_MONDAY && days == 7) {
                days = 0;
            }
            if (FIRST_DAY_IS_MONDAY) {
                --days;
            }
            date0 = date0.minusDays(days);
            date1 = date0.plusDays(7L).minusNanos(1L);
            return new DatetimeRange(DateUtils.from(date0).getTime(), DateUtils.from(date1).getTime());
        }

        public static DatetimeRange rangeWeek(int year, int month, int day) {
            month = JANUARY_IS_ZERO ? month + 1 : month;
            return DatetimeRange.rangeWeek(LocalDate.of(year, month, day));
        }

        public static DatetimeRange range(int year, int month, int day, int hour) {
            return DatetimeRange.create(year, month, day, hour);
        }

        public static DatetimeRange range(int year, int month, int day, int hour, int minute) {
            return DatetimeRange.create(year, month, day, hour, minute);
        }

        public static DatetimeRange range(int year, int month, int day, int hour, int minute, int second) {
            return DatetimeRange.create(year, month, day, hour, minute, second);
        }

        public void setLowerLimit(long lowerLimit) {
            this.lowerLimit = lowerLimit;
        }

        public void setUpperLimit(long upperLimit) {
            this.upperLimit = upperLimit;
        }

        public long getLowerLimit() {
            return this.lowerLimit;
        }

        public long getUpperLimit() {
            return this.upperLimit;
        }

        public String toString() {
            return "DateUtils.DatetimeRange(lowerLimit=" + this.getLowerLimit() + ", upperLimit=" + this.getUpperLimit() + ")";
        }
    }

    public static enum FieldType {
        YEAR(1),
        MONTH(2),
        DAY(5),
        HOUR(11),
        MINUTE(12),
        SECOND(13),
        MILLISECOND(14);

        int field;

        private FieldType(int field) {
            this.field = field;
        }

        int getField() {
            return this.field;
        }
    }
}

