/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.streaming;

import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.HttpConnectStrategy;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.background.BackgroundEventHandler;
import com.launchdarkly.eventsource.background.BackgroundEventSource;
import io.getunleash.streaming.StreamingFeatureFetcher;
import io.getunleash.util.UnleashConfig;
import java.net.URI;
import java.time.Duration;
import java.util.function.Consumer;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingFeatureFetcherImpl
implements StreamingFeatureFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingFeatureFetcherImpl.class);
    private final UnleashConfig config;
    private final Consumer<String> streamingUpdateHandler;
    private final Consumer<Throwable> streamingErrorHandler;
    private volatile BackgroundEventSource eventSource;

    public StreamingFeatureFetcherImpl(UnleashConfig config, Consumer<String> streamingUpdateHandler, Consumer<Throwable> streamingErrorHandler) {
        this.config = config;
        this.streamingUpdateHandler = streamingUpdateHandler;
        this.streamingErrorHandler = streamingErrorHandler;
    }

    @Override
    public void start() {
        try {
            URI streamingUri = this.config.getUnleashURLs().getStreamingURL().toURI();
            Headers.Builder headersBuilder = new Headers.Builder();
            this.config.getCustomHttpHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)headersBuilder).add(arg_0, arg_1));
            this.config.getCustomHttpHeadersProvider().getCustomHeaders().forEach((arg_0, arg_1) -> ((Headers.Builder)headersBuilder).add(arg_0, arg_1));
            headersBuilder.add("UNLEASH-APPNAME", this.config.getAppName());
            headersBuilder.add("UNLEASH-INSTANCEID", this.config.getInstanceId());
            headersBuilder.add("UNLEASH-CONNECTION-ID", this.config.getConnectionId());
            headersBuilder.add("UNLEASH-SDK", this.config.getSdkVersion());
            headersBuilder.add("Unleash-Client-Spec", this.config.getClientSpecificationVersion());
            OkHttpClient httpClient = new OkHttpClient.Builder().readTimeout(Duration.ofSeconds(60L)).connectTimeout(Duration.ofSeconds(10L)).build();
            HttpConnectStrategy connectStrategy = ConnectStrategy.http((URI)streamingUri).headers(headersBuilder.build()).httpClient(httpClient);
            EventSource.Builder eventSourceBuilder = new EventSource.Builder((ConnectStrategy)connectStrategy);
            BackgroundEventSource.Builder builder = new BackgroundEventSource.Builder((BackgroundEventHandler)new UnleashEventHandler(), eventSourceBuilder);
            BackgroundEventSource newEventSource = builder.build();
            newEventSource.start();
            this.eventSource = newEventSource;
        }
        catch (Exception e) {
            LOGGER.error("Failed to start streaming client", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            BackgroundEventSource currentEventSource = this.eventSource;
            if (currentEventSource != null) {
                currentEventSource.close();
                this.eventSource = null;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error stopping streaming client", (Throwable)e);
        }
    }

    private class UnleashEventHandler
    implements BackgroundEventHandler {
        private UnleashEventHandler() {
        }

        public void onOpen() throws Exception {
            LOGGER.info("Streaming connection established to Unleash server");
        }

        public void onClosed() throws Exception {
            LOGGER.info("Streaming connection to Unleash server closed");
        }

        public void onMessage(String event, MessageEvent messageEvent) throws Exception {
            try {
                LOGGER.debug("Received streaming event: {} with data: {}", (Object)event, (Object)messageEvent.getData());
                switch (event) {
                    case "unleash-connected": 
                    case "unleash-updated": {
                        StreamingFeatureFetcherImpl.this.streamingUpdateHandler.accept(messageEvent.getData());
                        break;
                    }
                    default: {
                        LOGGER.debug("Ignoring unknown event type: {}", (Object)event);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error processing streaming event, feature flags will likely not evaluate correctly until application restart or stream re-connect: {}", (Object)event, (Object)e);
            }
        }

        public void onComment(String comment) throws Exception {
        }

        public void onError(Throwable t) {
            StreamingFeatureFetcherImpl.this.streamingErrorHandler.accept(t);
        }
    }
}

