/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.EvaluatedToggle;
import io.getunleash.FeatureDefinition;
import io.getunleash.MoreOperations;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.lang.Nullable;
import io.getunleash.variant.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class FakeUnleash
implements Unleash {
    private boolean enableAll = false;
    private boolean disableAll = false;
    private Map<String, Boolean> excludedFeatures = new HashMap<String, Boolean>();
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, Variant> variants = new HashMap<String, Variant>();

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        if (this.enableAll) {
            return this.excludedFeatures.getOrDefault(toggleName, true);
        }
        if (this.disableAll) {
            return this.excludedFeatures.getOrDefault(toggleName, false);
        }
        return this.features.containsKey(toggleName) ? this.features.get(toggleName) : defaultSetting;
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, BiPredicate<String, UnleashContext> fallbackAction) {
        return this.isEnabled(toggleName, fallbackAction);
    }

    @Override
    public boolean isEnabled(String toggleName, BiPredicate<String, UnleashContext> fallbackAction) {
        if ((!this.enableAll && !this.disableAll || this.excludedFeatures.containsKey(toggleName)) && !this.features.containsKey(toggleName)) {
            return fallbackAction.test(toggleName, UnleashContext.builder().build());
        }
        return this.isEnabled(toggleName);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context) {
        return this.getVariant(toggleName, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, UnleashContext context, Variant defaultValue) {
        return this.getVariant(toggleName, defaultValue);
    }

    @Override
    public Variant getVariant(String toggleName) {
        return this.getVariant(toggleName, Variant.DISABLED_VARIANT);
    }

    @Override
    public Variant getVariant(String toggleName, Variant defaultValue) {
        if (this.isEnabled(toggleName) && this.variants.containsKey(toggleName)) {
            return this.variants.get(toggleName);
        }
        return defaultValue;
    }

    @Override
    public MoreOperations more() {
        return new FakeMore();
    }

    public void enableAll() {
        this.disableAll = false;
        this.enableAll = true;
        this.excludedFeatures.clear();
        this.features.clear();
    }

    public void enableAllExcept(String ... excludedFeatures) {
        this.enableAll();
        for (String toggle : excludedFeatures) {
            this.excludedFeatures.put(toggle, false);
        }
    }

    public void disableAll() {
        this.disableAll = true;
        this.enableAll = false;
        this.excludedFeatures.clear();
        this.features.clear();
    }

    public void disableAllExcept(String ... excludedFeatures) {
        this.disableAll();
        for (String toggle : excludedFeatures) {
            this.excludedFeatures.put(toggle, true);
        }
    }

    public void resetAll() {
        this.disableAll = false;
        this.enableAll = false;
        this.excludedFeatures.clear();
        this.features.clear();
        this.variants.clear();
    }

    public void enable(String ... features) {
        for (String name : features) {
            this.features.put(name, true);
        }
    }

    public void disable(String ... features) {
        for (String name : features) {
            this.features.put(name, false);
        }
    }

    public void reset(String ... features) {
        for (String name : features) {
            this.features.remove(name);
        }
    }

    public void setVariant(String t1, Variant a) {
        this.variants.put(t1, a);
    }

    public class FakeMore
    implements MoreOperations {
        @Override
        public List<String> getFeatureToggleNames() {
            return new ArrayList<String>(FakeUnleash.this.features.keySet());
        }

        @Override
        public Optional<FeatureDefinition> getFeatureToggleDefinition(String toggleName) {
            return Optional.ofNullable((Boolean)FakeUnleash.this.features.get(toggleName)).map(value -> new FeatureDefinition(toggleName, Optional.of("experiment"), "default"));
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles() {
            return this.evaluateAllToggles(null);
        }

        @Override
        public List<EvaluatedToggle> evaluateAllToggles(@Nullable UnleashContext context) {
            return this.getFeatureToggleNames().stream().map(toggleName -> new EvaluatedToggle((String)toggleName, FakeUnleash.this.isEnabled((String)toggleName), FakeUnleash.this.getVariant((String)toggleName))).collect(Collectors.toList());
        }
    }
}

