/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services;

import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.framework.ToJson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ChannelService {
    @POST(value="channels/{type}/{id}")
    public Call<Channel.ChannelUpdateResponse> update(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Channel.ChannelUpdateRequestData var3);

    @POST(value="channels/{type}/{id}/query")
    public Call<Channel.ChannelGetResponse> getOrCreateWithId(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @Nullable Channel.ChannelGetRequestData var3);

    @POST(value="channels/{type}/query")
    public Call<Channel.ChannelGetResponse> getOrCreateWithoutId(@Path(value="type") @NotNull String var1, @Body @Nullable Channel.ChannelGetRequestData var2);

    @DELETE(value="channels/{type}/{id}")
    public Call<Channel.ChannelDeleteResponse> delete(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2);

    @POST(value="channels/delete")
    public Call<Channel.ChannelDeleteManyResponse> deleteMany(@Body @NotNull Channel.ChannelDeleteManyRequest var1);

    @POST(value="channels")
    public Call<Channel.ChannelListResponse> list(@Body @Nullable Channel.ChannelListRequestData var1);

    @POST(value="channels/{type}/{id}/truncate")
    public Call<Channel.ChannelTruncateResponse> truncate(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @Nullable Channel.ChannelTruncateRequestData var3);

    @GET(value="members")
    public Call<Channel.ChannelQueryMembersResponse> queryMembers(@ToJson @Query(value="payload") @NotNull Channel.ChannelQueryMembersRequestData var1);

    @POST(value="export_channels")
    public Call<Channel.ChannelExportResponse> export(@Body @NotNull Channel.ChannelExportRequestData var1);

    @GET(value="export_channels/{id}")
    public Call<Channel.ChannelExportStatusResponse> exportStatus(@Path(value="id") @NotNull String var1);

    @POST(value="channels/{type}/{id}/hide")
    public Call<StreamResponseObject> hide(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Channel.ChannelHideRequestData var3);

    @POST(value="channels/read")
    public Call<StreamResponseObject> markAllRead(@Body @NotNull Channel.ChannelMarkAllReadRequestData var1);

    @POST(value="channels/{type}/{id}/read")
    public Call<Channel.ChannelMarkReadResponse> markRead(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Channel.ChannelMarkReadRequestData var3);

    @POST(value="moderation/mute/channel")
    public Call<Channel.ChannelMuteResponse> mute(@Body @NotNull Channel.ChannelMuteRequestData var1);

    @POST(value="channels/{type}/{id}/show")
    public Call<StreamResponseObject> show(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Channel.ChannelShowRequestData var3);

    @POST(value="moderation/unmute/channel")
    public Call<Channel.ChannelUnMuteResponse> unmute(@Body @NotNull Channel.ChannelUnMuteRequestData var1);

    @PATCH(value="channels/{type}/{id}")
    public Call<Channel.ChannelPartialUpdateResponse> partialUpdate(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Channel.ChannelPartialUpdateRequestData var3);

    @POST(value="channels/{type}/{id}")
    public Call<Channel.ChannelUpdateResponse> assignRoles(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Body @NotNull Channel.AssignRoleRequestData var3);

    @PATCH(value="channels/{type}/{id}/member/{user_id}")
    public Call<Channel.ChannelMemberResponse> updateMemberPartial(@Path(value="type") @NotNull String var1, @Path(value="id") @NotNull String var2, @Path(value="user_id") @NotNull String var3, @Body @NotNull Channel.ChannelMemberPartialUpdateRequestData var4);

    @POST(value="channels/delivered")
    public Call<StreamResponseObject> markDelivered(@Body @NotNull Channel.MarkDeliveredRequestData var1, @Query(value="user_id") String var2);
}

