/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models.framework;

import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.framework.StreamResponse;
import io.getstream.chat.java.services.framework.Client;
import io.getstream.chat.java.services.framework.StreamServiceHandler;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public abstract class StreamRequest<T extends StreamResponse> {
    private Client client;

    protected abstract Call<T> generateCall(Client var1) throws StreamException;

    @NotNull
    public T request() throws StreamException {
        return new StreamServiceHandler().handle(this.generateCall(this.getClient()));
    }

    public void requestAsync(@Nullable Consumer<T> onSuccess, @Nullable Consumer<StreamException> onError) {
        block2: {
            try {
                Client client = this.getClient();
                new StreamServiceHandler().handleAsync(this.generateCall(client), onSuccess, onError);
            }
            catch (StreamException e) {
                if (onError == null) break block2;
                onError.accept(e);
            }
        }
    }

    public StreamRequest<T> withClient(Client client) {
        this.client = client;
        return this;
    }

    @NotNull
    protected Client getClient() {
        return this.client == null ? Client.getInstance() : this.client;
    }
}

