/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.is;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.stream.ChunkedStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamRequestBody
extends RequestBody.Base<InputStream> {
    public InputStreamRequestBody(InputStream inputStream) {
        super(new ConsumableInputStream(inputStream));
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        ChunkedStream chunkedStream = new ChunkedStream((InputStream)this.content);
        return new WritableContent(chunkedStream, -1L);
    }

    @Override
    public RequestBodyBuilder newBuilder() {
        return new InputStreamRequestBodyBuilder((InputStream)this.content);
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException("Can't read InputStream bytes without consuming it");
    }

    public boolean isConsumed() {
        return ((ConsumableInputStream)this.content).consumed;
    }

    @Override
    public String print(int n) {
        return "InputStreamRequestBody{content=???}";
    }

    private static class ConsumableInputStream
    extends InputStream {
        private final InputStream is;
        boolean consumed = false;

        ConsumableInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        @Override
        public int read() throws IOException {
            this.consumed = true;
            return this.is.read();
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }
    }
}

