/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.util;

import lombok.Generated;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ExecOutput;

public final class GitUtil {
    public static boolean isTravisCi(ProviderFactory providerFactory) {
        return "true".equalsIgnoreCase((String)providerFactory.environmentVariable("TRAVIS").getOrNull());
    }

    public static boolean isCircleCi(ProviderFactory providerFactory) {
        return "true".equalsIgnoreCase((String)providerFactory.environmentVariable("CIRCLECI").getOrNull());
    }

    public static boolean isGithubActions(ProviderFactory providerFactory) {
        return "true".equalsIgnoreCase((String)providerFactory.environmentVariable("GITHUB_ACTIONS").getOrNull());
    }

    public static boolean isJenkins(ProviderFactory providerFactory) {
        return providerFactory.environmentVariable("JENKINS_HOME").isPresent();
    }

    public static boolean isGitLab(ProviderFactory providerFactory) {
        return providerFactory.environmentVariable("GITLAB_CI").isPresent();
    }

    public static Provider<String> getSha(Project project) {
        if (GitUtil.isGithubActions(project.getProviders())) {
            return project.getProviders().environmentVariable("GITHUB_SHA");
        }
        if (GitUtil.isTravisCi(project.getProviders())) {
            return project.getProviders().environmentVariable("TRAVIS_COMMIT");
        }
        if (GitUtil.isCircleCi(project.getProviders())) {
            return project.getProviders().environmentVariable("CIRCLE_SHA1");
        }
        return GitUtil.execute(project, "git", "rev-parse", "HEAD");
    }

    public static Provider<String> getRef(Project project) {
        if (GitUtil.isGithubActions(project.getProviders())) {
            return project.getProviders().environmentVariable("GITHUB_REF");
        }
        return GitUtil.execute(project, "git", "symbolic-ref", "HEAD");
    }

    public static Provider<String> execute(Project project, String ... command) {
        ExecOutput execOutput = project.getProviders().exec(execSpec -> {
            execSpec.setWorkingDir(project.getProjectDir());
            execSpec.commandLine((Object[])command);
        });
        return execOutput.getStandardOutput().getAsText().map(String::trim);
    }

    @Generated
    private GitUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

