/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import lombok.Generated;
import org.gradle.api.Task;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.ClasspathNormalizer;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.CompileClasspathNormalizer;
import org.gradle.api.tasks.Destroys;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;

public final class TaskUtils {
    public static <T> void registerNested(Task task, T object, String prefix) throws InvocationTargetException, IllegalAccessException {
        Class<?> type = object.getClass();
        TaskUtils.registerNested(task, type, object, prefix);
    }

    public static <T> void registerNested(Task task, Class<? super T> type, T object, String prefix) throws InvocationTargetException, IllegalAccessException {
        while (!type.equals(Object.class)) {
            for (Field field : type.getDeclaredFields()) {
                TaskUtils.registerNested(task, field, object, prefix);
            }
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                if (((Method)accessibleObject).getParameterCount() != 0) continue;
                TaskUtils.registerNested(task, accessibleObject, object, prefix);
            }
            type = type.getSuperclass();
        }
    }

    private static <M extends Member & AnnotatedElement> void registerNested(Task task, M member, Object object, String prefix) throws IllegalAccessException, InvocationTargetException {
        TaskInputFilePropertyBuilder inputFilePropertyBuilder;
        Object value;
        if (member.isSynthetic()) {
            return;
        }
        if (((AnnotatedElement)member).isAnnotationPresent(Internal.class)) {
            return;
        }
        if (member instanceof Field) {
            ((Field)member).setAccessible(true);
            value = ((Field)member).get(object);
        } else if (member instanceof Method) {
            value = ((Method)member).invoke(object, new Object[0]);
        } else {
            throw new IllegalArgumentException();
        }
        String name = prefix + "." + member.getName();
        boolean optional = TaskUtils.isOptional(member);
        boolean skipWhenEmpty = TaskUtils.isSkipWhenEmpty(member);
        if (((AnnotatedElement)member).isAnnotationPresent(Input.class)) {
            task.getInputs().property(name, value).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(InputFile.class)) {
            inputFilePropertyBuilder = task.getInputs().file(value).withPropertyName(name).skipWhenEmpty(skipWhenEmpty).optional(optional);
            TaskUtils.handlePathSensitivity(inputFilePropertyBuilder, member);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(InputFiles.class)) {
            inputFilePropertyBuilder = task.getInputs().files(new Object[]{value}).withPropertyName(name).skipWhenEmpty(skipWhenEmpty).optional(optional);
            TaskUtils.handlePathSensitivity(inputFilePropertyBuilder, member);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(InputDirectory.class)) {
            inputFilePropertyBuilder = task.getInputs().dir(value).withPropertyName(name).skipWhenEmpty(skipWhenEmpty).optional(optional);
            TaskUtils.handlePathSensitivity(inputFilePropertyBuilder, member);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(Classpath.class)) {
            task.getInputs().files(new Object[]{value}).withPropertyName(name).skipWhenEmpty(skipWhenEmpty).withNormalizer(ClasspathNormalizer.class).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(CompileClasspath.class)) {
            task.getInputs().files(new Object[]{value}).withPropertyName(name).skipWhenEmpty(skipWhenEmpty).withNormalizer(CompileClasspathNormalizer.class).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(OutputFile.class)) {
            task.getOutputs().file(value).withPropertyName(name).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(OutputFiles.class)) {
            task.getOutputs().files(new Object[]{value}).withPropertyName(name).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(OutputDirectory.class)) {
            task.getOutputs().dir(value).withPropertyName(name).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(OutputDirectories.class)) {
            task.getOutputs().dirs(new Object[]{value}).withPropertyName(name).optional(optional);
        }
        if (((AnnotatedElement)member).isAnnotationPresent(Destroys.class)) {
            task.getDestroyables().register(new Object[]{value});
        }
        if (((AnnotatedElement)member).isAnnotationPresent(Nested.class)) {
            TaskUtils.registerNested(task, value, name);
        }
    }

    private static void handlePathSensitivity(TaskInputFilePropertyBuilder propertyBuilder, AnnotatedElement element) {
        PathSensitive pathSensitive = element.getAnnotation(PathSensitive.class);
        if (pathSensitive != null) {
            propertyBuilder.withPathSensitivity(pathSensitive.value());
        }
    }

    private static <M extends Member & AnnotatedElement> boolean isSkipWhenEmpty(M member) {
        return ((AnnotatedElement)member).isAnnotationPresent(SkipWhenEmpty.class);
    }

    private static <M extends Member & AnnotatedElement> boolean isOptional(M member) {
        return ((AnnotatedElement)member).isAnnotationPresent(Optional.class);
    }

    @Generated
    private TaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

