/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileService;
import io.fabric8.process.manager.support.ByteToStringValues;
import io.fabric8.process.manager.support.LayOutPredicate;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);

    public static File findInstallDir(File rootDir) {
        if (ProcessUtils.installExists(rootDir)) {
            return rootDir;
        }
        File[] files = rootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!ProcessUtils.installExists(file)) continue;
                return file;
            }
        }
        return rootDir;
    }

    public static boolean installExists(File file) {
        if (file.isDirectory()) {
            File binDir = new File(file, "bin");
            return binDir.exists() && binDir.isDirectory();
        }
        return false;
    }

    public static Map<String, String> getProcessLayout(FabricService fabricService, List<Profile> profiles, String layoutPath) {
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Profile profile : profiles) {
            Map<String, String> map = ProcessUtils.getProcessLayout(fabricService, profile, layoutPath);
            answer.putAll(map);
        }
        return answer;
    }

    public static Map<String, String> getProcessLayout(FabricService fabricService, Profile profile, String layoutPath) {
        ProfileService profileService = (ProfileService)fabricService.adapt(ProfileService.class);
        Profile overlay = profileService.getOverlayProfile(profile);
        return ByteToStringValues.INSTANCE.apply(Maps.filterKeys((Map)overlay.getFileConfigurations(), (Predicate)new LayOutPredicate(layoutPath)));
    }
}

