/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.commands.support;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.process.manager.ProcessManager;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={KindCompleter.class, Completer.class})
public class KindCompleter
extends AbstractComponent
implements Completer {
    private static final transient Logger LOG = LoggerFactory.getLogger(KindCompleter.class);
    private List<String> kinds = Lists.newArrayList();

    @Activate
    void activate() {
        this.init();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void init() {
        InputStream in = ProcessManager.class.getResourceAsStream("controllerKinds");
        if (in == null) {
            LOG.warn("Cannot find controllerKinds on the classpath!");
        } else {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    this.kinds.add(line);
                }
            }
            catch (IOException e) {
                Closeables.closeQuietly((Closeable)in);
            }
        }
    }

    public int complete(String buffer, int cursor, List candidates) {
        StringsCompleter delegate = new StringsCompleter(this.kinds);
        return delegate.complete(buffer, cursor, candidates);
    }
}

