/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PatchData {
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String BUNDLES = "bundle";
    private static final String REQUIREMENTS = "requirement";
    private static final String COUNT = "count";
    private static final String RANGE = "range";
    private final String id;
    private final String description;
    private final Collection<String> bundles;
    private final Map<String, String> versionRanges;
    private final Collection<String> requirements;

    public PatchData(String id, String description, Collection<String> bundles, Map<String, String> versionRanges, Collection<String> requirements) {
        this.id = id;
        this.description = description;
        this.bundles = bundles;
        this.versionRanges = versionRanges;
        this.requirements = requirements;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersionRange(String bundle) {
        return this.versionRanges.get(bundle);
    }

    public Collection<String> getBundles() {
        return this.bundles;
    }

    public Collection<String> getRequirements() {
        return this.requirements;
    }

    public static PatchData load(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        String id = props.getProperty(ID);
        String desc = props.getProperty(DESCRIPTION);
        ArrayList<String> bundles = new ArrayList<String>();
        HashMap<String, String> ranges = new HashMap<String, String>();
        int count = Integer.parseInt(props.getProperty("bundle.count", "0"));
        for (int i = 0; i < count; ++i) {
            String key = "bundle." + Integer.toString(i);
            String bundle = props.getProperty(key);
            bundles.add(bundle);
            if (!props.containsKey(key + "." + RANGE)) continue;
            ranges.put(bundle, props.getProperty(key + "." + RANGE));
        }
        ArrayList<String> requirements = new ArrayList<String>();
        int requirementCount = Integer.parseInt(props.getProperty("requirement.count", "0"));
        for (int i = 0; i < requirementCount; ++i) {
            String key = "requirement." + Integer.toString(i);
            String requirement = props.getProperty(key);
            requirements.add(requirement);
        }
        return new PatchData(id, desc, bundles, ranges, requirements);
    }
}

