/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.openshift.api.model.DockerStrategyOptions;
import io.fabric8.openshift.api.model.DockerStrategyOptionsBuilder;
import io.fabric8.openshift.api.model.DockerStrategyOptionsFluent;
import io.fabric8.openshift.api.model.GenericWebHookEvent;
import io.fabric8.openshift.api.model.GitInfo;
import io.fabric8.openshift.api.model.GitInfoBuilder;
import io.fabric8.openshift.api.model.GitInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GenericWebHookEventFluent<A extends GenericWebHookEventFluent<A>>
extends BaseFluent<A> {
    private DockerStrategyOptionsBuilder dockerStrategyOptions;
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private GitInfoBuilder git;
    private String type;
    private Map<String, Object> additionalProperties;

    public GenericWebHookEventFluent() {
    }

    public GenericWebHookEventFluent(GenericWebHookEvent instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GenericWebHookEvent instance) {
        GenericWebHookEvent genericWebHookEvent = instance = instance != null ? instance : new GenericWebHookEvent();
        if (instance != null) {
            this.withDockerStrategyOptions(instance.getDockerStrategyOptions());
            this.withEnv(instance.getEnv());
            this.withGit(instance.getGit());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DockerStrategyOptions buildDockerStrategyOptions() {
        return this.dockerStrategyOptions != null ? this.dockerStrategyOptions.build() : null;
    }

    public A withDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
        this._visitables.remove((Object)"dockerStrategyOptions");
        if (dockerStrategyOptions != null) {
            this.dockerStrategyOptions = new DockerStrategyOptionsBuilder(dockerStrategyOptions);
            this._visitables.get((Object)"dockerStrategyOptions").add(this.dockerStrategyOptions);
        } else {
            this.dockerStrategyOptions = null;
            this._visitables.get((Object)"dockerStrategyOptions").remove((Object)this.dockerStrategyOptions);
        }
        return (A)((Object)this);
    }

    public boolean hasDockerStrategyOptions() {
        return this.dockerStrategyOptions != null;
    }

    public DockerStrategyOptionsNested<A> withNewDockerStrategyOptions() {
        return new DockerStrategyOptionsNested(null);
    }

    public DockerStrategyOptionsNested<A> withNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return new DockerStrategyOptionsNested(item);
    }

    public DockerStrategyOptionsNested<A> editDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(Optional.ofNullable(this.buildDockerStrategyOptions()).orElse(null));
    }

    public DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptions() {
        return this.withNewDockerStrategyOptionsLike(Optional.ofNullable(this.buildDockerStrategyOptions()).orElse(new DockerStrategyOptionsBuilder().build()));
    }

    public DockerStrategyOptionsNested<A> editOrNewDockerStrategyOptionsLike(DockerStrategyOptions item) {
        return this.withNewDockerStrategyOptionsLike(Optional.ofNullable(this.buildDockerStrategyOptions()).orElse(item));
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove(builder);
            this.env.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? GenericWebHookEventFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public GitInfo buildGit() {
        return this.git != null ? this.git.build() : null;
    }

    public A withGit(GitInfo git) {
        this._visitables.remove((Object)"git");
        if (git != null) {
            this.git = new GitInfoBuilder(git);
            this._visitables.get((Object)"git").add(this.git);
        } else {
            this.git = null;
            this._visitables.get((Object)"git").remove((Object)this.git);
        }
        return (A)((Object)this);
    }

    public boolean hasGit() {
        return this.git != null;
    }

    public GitNested<A> withNewGit() {
        return new GitNested(null);
    }

    public GitNested<A> withNewGitLike(GitInfo item) {
        return new GitNested(item);
    }

    public GitNested<A> editGit() {
        return this.withNewGitLike(Optional.ofNullable(this.buildGit()).orElse(null));
    }

    public GitNested<A> editOrNewGit() {
        return this.withNewGitLike(Optional.ofNullable(this.buildGit()).orElse(new GitInfoBuilder().build()));
    }

    public GitNested<A> editOrNewGitLike(GitInfo item) {
        return this.withNewGitLike(Optional.ofNullable(this.buildGit()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericWebHookEventFluent that = (GenericWebHookEventFluent)((Object)o);
        if (!Objects.equals((Object)this.dockerStrategyOptions, (Object)that.dockerStrategyOptions)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals((Object)this.git, (Object)that.git)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dockerStrategyOptions, this.env, this.git, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dockerStrategyOptions != null) {
            sb.append("dockerStrategyOptions:");
            sb.append(String.valueOf((Object)this.dockerStrategyOptions) + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(String.valueOf(this.env) + ",");
        }
        if (this.git != null) {
            sb.append("git:");
            sb.append(String.valueOf((Object)this.git) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GitNested<N>
    extends GitInfoFluent<GitNested<N>>
    implements Nested<N> {
        GitInfoBuilder builder;

        GitNested(GitInfo item) {
            this.builder = new GitInfoBuilder(this, item);
        }

        public N and() {
            return (N)GenericWebHookEventFluent.this.withGit(this.builder.build());
        }

        public N endGit() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder((EnvVarFluent)this, item);
        }

        public N and() {
            return (N)GenericWebHookEventFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class DockerStrategyOptionsNested<N>
    extends DockerStrategyOptionsFluent<DockerStrategyOptionsNested<N>>
    implements Nested<N> {
        DockerStrategyOptionsBuilder builder;

        DockerStrategyOptionsNested(DockerStrategyOptions item) {
            this.builder = new DockerStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)GenericWebHookEventFluent.this.withDockerStrategyOptions(this.builder.build());
        }

        public N endDockerStrategyOptions() {
            return this.and();
        }
    }
}

