/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.ClusterOperator;
import io.fabric8.openshift.api.model.ClusterOperatorBuilder;
import io.fabric8.openshift.api.model.ClusterOperatorFluentImpl;
import io.fabric8.openshift.api.model.ClusterOperatorList;
import io.fabric8.openshift.api.model.ClusterOperatorListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterOperatorListFluentImpl<A extends ClusterOperatorListFluent<A>>
extends BaseFluent<A>
implements ClusterOperatorListFluent<A> {
    private String apiVersion;
    private List<ClusterOperatorBuilder> items = new ArrayList<ClusterOperatorBuilder>();
    private String kind;
    private ListMeta metadata;

    public ClusterOperatorListFluentImpl() {
    }

    public ClusterOperatorListFluentImpl(ClusterOperatorList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, ClusterOperator item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterOperatorBuilder>();
        }
        ClusterOperatorBuilder builder = new ClusterOperatorBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ClusterOperator item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterOperatorBuilder>();
        }
        ClusterOperatorBuilder builder = new ClusterOperatorBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ClusterOperator ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterOperatorBuilder>();
        }
        for (ClusterOperator item : items) {
            ClusterOperatorBuilder builder = new ClusterOperatorBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ClusterOperator> items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterOperatorBuilder>();
        }
        for (ClusterOperator item : items) {
            ClusterOperatorBuilder builder = new ClusterOperatorBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterOperator ... items) {
        for (ClusterOperator item : items) {
            ClusterOperatorBuilder builder = new ClusterOperatorBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ClusterOperator> items) {
        for (ClusterOperator item : items) {
            ClusterOperatorBuilder builder = new ClusterOperatorBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ClusterOperatorBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ClusterOperatorBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ClusterOperatorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterOperator> getItems() {
        return ClusterOperatorListFluentImpl.build(this.items);
    }

    @Override
    public List<ClusterOperator> buildItems() {
        return ClusterOperatorListFluentImpl.build(this.items);
    }

    @Override
    public ClusterOperator buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ClusterOperator buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ClusterOperator buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ClusterOperator buildMatchingItem(Predicate<ClusterOperatorBuilder> predicate) {
        for (ClusterOperatorBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ClusterOperatorBuilder> predicate) {
        for (ClusterOperatorBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ClusterOperator> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ClusterOperatorBuilder>();
            for (ClusterOperator item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterOperator ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ClusterOperator item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> addNewItemLike(ClusterOperator item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> setNewItemLike(int index, ClusterOperator item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterOperatorListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterOperatorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterOperatorListFluentImpl that = (ClusterOperatorListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ClusterOperatorFluentImpl<ClusterOperatorListFluent.ItemsNested<N>>
    implements ClusterOperatorListFluent.ItemsNested<N>,
    Nested<N> {
        private final ClusterOperatorBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ClusterOperator item) {
            this.index = index;
            this.builder = new ClusterOperatorBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterOperatorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterOperatorListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

