/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RepositoryDigestMirrorsFluent<A extends RepositoryDigestMirrorsFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> mirrors = new ArrayList<String>();
    private String source;

    public RepositoryDigestMirrorsFluent() {
    }

    public RepositoryDigestMirrorsFluent(RepositoryDigestMirrors instance) {
        this.copyInstance(instance);
    }

    public A addAllToMirrors(Collection<String> items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.mirrors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMirrors(String ... items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.mirrors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToMirrors(int index, String item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        this.mirrors.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(RepositoryDigestMirrors instance) {
        RepositoryDigestMirrors repositoryDigestMirrors = instance = instance != null ? instance : new RepositoryDigestMirrors();
        if (instance != null) {
            this.withMirrors(instance.getMirrors());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RepositoryDigestMirrorsFluent that = (RepositoryDigestMirrorsFluent)((Object)o);
        if (!Objects.equals(this.mirrors, that.mirrors)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFirstMirror() {
        return this.mirrors.get(0);
    }

    public String getLastMirror() {
        return this.mirrors.get(this.mirrors.size() - 1);
    }

    public String getMatchingMirror(Predicate<String> predicate) {
        for (String item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getMirror(int index) {
        return this.mirrors.get(index);
    }

    public List<String> getMirrors() {
        return this.mirrors;
    }

    public String getSource() {
        return this.source;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingMirror(Predicate<String> predicate) {
        for (String item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMirrors() {
        return this.mirrors != null && !this.mirrors.isEmpty();
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public int hashCode() {
        return Objects.hash(this.mirrors, this.source, this.additionalProperties);
    }

    public A removeAllFromMirrors(Collection<String> items) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.mirrors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMirrors(String ... items) {
        if (this.mirrors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.mirrors.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToMirrors(int index, String item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<String>();
        }
        this.mirrors.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mirrors != null && !this.mirrors.isEmpty()) {
            sb.append("mirrors:");
            sb.append(this.mirrors);
            sb.append(",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withMirrors(List<String> mirrors) {
        if (mirrors != null) {
            this.mirrors = new ArrayList<String>();
            for (String item : mirrors) {
                this.addToMirrors(item);
            }
        } else {
            this.mirrors = null;
        }
        return (A)((Object)this);
    }

    public A withMirrors(String ... mirrors) {
        if (this.mirrors != null) {
            this.mirrors.clear();
            this._visitables.remove((Object)"mirrors");
        }
        if (mirrors != null) {
            for (String item : mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)((Object)this);
    }

    public A withSource(String source) {
        this.source = source;
        return (A)((Object)this);
    }
}

