/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.NodeStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeStatusFluent<A extends NodeStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private Integer currentDeploymentGeneration;
    private List<String> lastFailedDeploymentErrors = new ArrayList<String>();
    private Integer lastFailedDeploymentGeneration;
    private String nodeName;
    private Integer targetDeploymentGeneration;

    public NodeStatusFluent() {
    }

    public NodeStatusFluent(NodeStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToLastFailedDeploymentErrors(Collection<String> items) {
        if (this.lastFailedDeploymentErrors == null) {
            this.lastFailedDeploymentErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedDeploymentErrors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLastFailedDeploymentErrors(String ... items) {
        if (this.lastFailedDeploymentErrors == null) {
            this.lastFailedDeploymentErrors = new ArrayList<String>();
        }
        for (String item : items) {
            this.lastFailedDeploymentErrors.add(item);
        }
        return (A)((Object)this);
    }

    public A addToLastFailedDeploymentErrors(int index, String item) {
        if (this.lastFailedDeploymentErrors == null) {
            this.lastFailedDeploymentErrors = new ArrayList<String>();
        }
        this.lastFailedDeploymentErrors.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(NodeStatus instance) {
        NodeStatus nodeStatus = instance = instance != null ? instance : new NodeStatus();
        if (instance != null) {
            this.withCurrentDeploymentGeneration(instance.getCurrentDeploymentGeneration());
            this.withLastFailedDeploymentErrors(instance.getLastFailedDeploymentErrors());
            this.withLastFailedDeploymentGeneration(instance.getLastFailedDeploymentGeneration());
            this.withNodeName(instance.getNodeName());
            this.withTargetDeploymentGeneration(instance.getTargetDeploymentGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusFluent that = (NodeStatusFluent)((Object)o);
        if (!Objects.equals(this.currentDeploymentGeneration, that.currentDeploymentGeneration)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedDeploymentErrors, that.lastFailedDeploymentErrors)) {
            return false;
        }
        if (!Objects.equals(this.lastFailedDeploymentGeneration, that.lastFailedDeploymentGeneration)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.targetDeploymentGeneration, that.targetDeploymentGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Integer getCurrentDeploymentGeneration() {
        return this.currentDeploymentGeneration;
    }

    public String getFirstLastFailedDeploymentError() {
        return this.lastFailedDeploymentErrors.get(0);
    }

    public String getLastFailedDeploymentError(int index) {
        return this.lastFailedDeploymentErrors.get(index);
    }

    public List<String> getLastFailedDeploymentErrors() {
        return this.lastFailedDeploymentErrors;
    }

    public Integer getLastFailedDeploymentGeneration() {
        return this.lastFailedDeploymentGeneration;
    }

    public String getLastLastFailedDeploymentError() {
        return this.lastFailedDeploymentErrors.get(this.lastFailedDeploymentErrors.size() - 1);
    }

    public String getMatchingLastFailedDeploymentError(Predicate<String> predicate) {
        for (String item : this.lastFailedDeploymentErrors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Integer getTargetDeploymentGeneration() {
        return this.targetDeploymentGeneration;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasCurrentDeploymentGeneration() {
        return this.currentDeploymentGeneration != null;
    }

    public boolean hasLastFailedDeploymentErrors() {
        return this.lastFailedDeploymentErrors != null && !this.lastFailedDeploymentErrors.isEmpty();
    }

    public boolean hasLastFailedDeploymentGeneration() {
        return this.lastFailedDeploymentGeneration != null;
    }

    public boolean hasMatchingLastFailedDeploymentError(Predicate<String> predicate) {
        for (String item : this.lastFailedDeploymentErrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public boolean hasTargetDeploymentGeneration() {
        return this.targetDeploymentGeneration != null;
    }

    public int hashCode() {
        return Objects.hash(this.currentDeploymentGeneration, this.lastFailedDeploymentErrors, this.lastFailedDeploymentGeneration, this.nodeName, this.targetDeploymentGeneration, this.additionalProperties);
    }

    public A removeAllFromLastFailedDeploymentErrors(Collection<String> items) {
        if (this.lastFailedDeploymentErrors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.lastFailedDeploymentErrors.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromLastFailedDeploymentErrors(String ... items) {
        if (this.lastFailedDeploymentErrors == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.lastFailedDeploymentErrors.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToLastFailedDeploymentErrors(int index, String item) {
        if (this.lastFailedDeploymentErrors == null) {
            this.lastFailedDeploymentErrors = new ArrayList<String>();
        }
        this.lastFailedDeploymentErrors.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentDeploymentGeneration != null) {
            sb.append("currentDeploymentGeneration:");
            sb.append(this.currentDeploymentGeneration);
            sb.append(",");
        }
        if (this.lastFailedDeploymentErrors != null && !this.lastFailedDeploymentErrors.isEmpty()) {
            sb.append("lastFailedDeploymentErrors:");
            sb.append(this.lastFailedDeploymentErrors);
            sb.append(",");
        }
        if (this.lastFailedDeploymentGeneration != null) {
            sb.append("lastFailedDeploymentGeneration:");
            sb.append(this.lastFailedDeploymentGeneration);
            sb.append(",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName);
            sb.append(",");
        }
        if (this.targetDeploymentGeneration != null) {
            sb.append("targetDeploymentGeneration:");
            sb.append(this.targetDeploymentGeneration);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withCurrentDeploymentGeneration(Integer currentDeploymentGeneration) {
        this.currentDeploymentGeneration = currentDeploymentGeneration;
        return (A)((Object)this);
    }

    public A withLastFailedDeploymentErrors(List<String> lastFailedDeploymentErrors) {
        if (lastFailedDeploymentErrors != null) {
            this.lastFailedDeploymentErrors = new ArrayList<String>();
            for (String item : lastFailedDeploymentErrors) {
                this.addToLastFailedDeploymentErrors(item);
            }
        } else {
            this.lastFailedDeploymentErrors = null;
        }
        return (A)((Object)this);
    }

    public A withLastFailedDeploymentErrors(String ... lastFailedDeploymentErrors) {
        if (this.lastFailedDeploymentErrors != null) {
            this.lastFailedDeploymentErrors.clear();
            this._visitables.remove((Object)"lastFailedDeploymentErrors");
        }
        if (lastFailedDeploymentErrors != null) {
            for (String item : lastFailedDeploymentErrors) {
                this.addToLastFailedDeploymentErrors(item);
            }
        }
        return (A)((Object)this);
    }

    public A withLastFailedDeploymentGeneration(Integer lastFailedDeploymentGeneration) {
        this.lastFailedDeploymentGeneration = lastFailedDeploymentGeneration;
        return (A)((Object)this);
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public A withTargetDeploymentGeneration(Integer targetDeploymentGeneration) {
        this.targetDeploymentGeneration = targetDeploymentGeneration;
        return (A)((Object)this);
    }
}

