/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ConfigMapFileReference;
import io.fabric8.openshift.api.model.operator.v1.AddPage;
import io.fabric8.openshift.api.model.operator.v1.AddPageBuilder;
import io.fabric8.openshift.api.model.operator.v1.AddPageFluent;
import io.fabric8.openshift.api.model.operator.v1.Capability;
import io.fabric8.openshift.api.model.operator.v1.CapabilityBuilder;
import io.fabric8.openshift.api.model.operator.v1.CapabilityFluent;
import io.fabric8.openshift.api.model.operator.v1.ConsoleCustomization;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCustomization;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCustomizationBuilder;
import io.fabric8.openshift.api.model.operator.v1.DeveloperConsoleCatalogCustomizationFluent;
import io.fabric8.openshift.api.model.operator.v1.Logo;
import io.fabric8.openshift.api.model.operator.v1.LogoBuilder;
import io.fabric8.openshift.api.model.operator.v1.LogoFluent;
import io.fabric8.openshift.api.model.operator.v1.Perspective;
import io.fabric8.openshift.api.model.operator.v1.PerspectiveBuilder;
import io.fabric8.openshift.api.model.operator.v1.PerspectiveFluent;
import io.fabric8.openshift.api.model.operator.v1.ProjectAccess;
import io.fabric8.openshift.api.model.operator.v1.ProjectAccessBuilder;
import io.fabric8.openshift.api.model.operator.v1.ProjectAccessFluent;
import io.fabric8.openshift.api.model.operator.v1.QuickStarts;
import io.fabric8.openshift.api.model.operator.v1.QuickStartsBuilder;
import io.fabric8.openshift.api.model.operator.v1.QuickStartsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ConsoleCustomizationFluent<A extends ConsoleCustomizationFluent<A>>
extends BaseFluent<A> {
    private AddPageBuilder addPage;
    private Map<String, Object> additionalProperties;
    private String brand;
    private ArrayList<CapabilityBuilder> capabilities = new ArrayList();
    private ConfigMapFileReference customLogoFile;
    private String customProductName;
    private DeveloperConsoleCatalogCustomizationBuilder developerCatalog;
    private String documentationBaseURL;
    private ArrayList<LogoBuilder> logos = new ArrayList();
    private ArrayList<PerspectiveBuilder> perspectives = new ArrayList();
    private ProjectAccessBuilder projectAccess;
    private QuickStartsBuilder quickStarts;

    public ConsoleCustomizationFluent() {
    }

    public ConsoleCustomizationFluent(ConsoleCustomization instance) {
        this.copyInstance(instance);
    }

    public A addAllToCapabilities(Collection<Capability> items) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList();
        }
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.get((Object)"capabilities").add(builder);
            this.capabilities.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLogos(Collection<Logo> items) {
        if (this.logos == null) {
            this.logos = new ArrayList();
        }
        for (Logo item : items) {
            LogoBuilder builder = new LogoBuilder(item);
            this._visitables.get((Object)"logos").add(builder);
            this.logos.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPerspectives(Collection<Perspective> items) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get((Object)"perspectives").add(builder);
            this.perspectives.add(builder);
        }
        return (A)((Object)this);
    }

    public CapabilitiesNested<A> addNewCapability() {
        return new CapabilitiesNested(-1, null);
    }

    public CapabilitiesNested<A> addNewCapabilityLike(Capability item) {
        return new CapabilitiesNested(-1, item);
    }

    public LogosNested<A> addNewLogo() {
        return new LogosNested(-1, null);
    }

    public LogosNested<A> addNewLogoLike(Logo item) {
        return new LogosNested(-1, item);
    }

    public PerspectivesNested<A> addNewPerspective() {
        return new PerspectivesNested(-1, null);
    }

    public PerspectivesNested<A> addNewPerspectiveLike(Perspective item) {
        return new PerspectivesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToCapabilities(Capability ... items) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList();
        }
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.get((Object)"capabilities").add(builder);
            this.capabilities.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToCapabilities(int index, Capability item) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList();
        }
        CapabilityBuilder builder = new CapabilityBuilder(item);
        if (index < 0 || index >= this.capabilities.size()) {
            this._visitables.get((Object)"capabilities").add(builder);
            this.capabilities.add(builder);
        } else {
            this._visitables.get((Object)"capabilities").add(builder);
            this.capabilities.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToLogos(Logo ... items) {
        if (this.logos == null) {
            this.logos = new ArrayList();
        }
        for (Logo item : items) {
            LogoBuilder builder = new LogoBuilder(item);
            this._visitables.get((Object)"logos").add(builder);
            this.logos.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToLogos(int index, Logo item) {
        if (this.logos == null) {
            this.logos = new ArrayList();
        }
        LogoBuilder builder = new LogoBuilder(item);
        if (index < 0 || index >= this.logos.size()) {
            this._visitables.get((Object)"logos").add(builder);
            this.logos.add(builder);
        } else {
            this._visitables.get((Object)"logos").add(builder);
            this.logos.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPerspectives(Perspective ... items) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get((Object)"perspectives").add(builder);
            this.perspectives.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToPerspectives(int index, Perspective item) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        PerspectiveBuilder builder = new PerspectiveBuilder(item);
        if (index < 0 || index >= this.perspectives.size()) {
            this._visitables.get((Object)"perspectives").add(builder);
            this.perspectives.add(builder);
        } else {
            this._visitables.get((Object)"perspectives").add(builder);
            this.perspectives.add(index, builder);
        }
        return (A)((Object)this);
    }

    public AddPage buildAddPage() {
        return this.addPage != null ? this.addPage.build() : null;
    }

    public List<Capability> buildCapabilities() {
        return this.capabilities != null ? ConsoleCustomizationFluent.build(this.capabilities) : null;
    }

    public Capability buildCapability(int index) {
        return this.capabilities.get(index).build();
    }

    public DeveloperConsoleCatalogCustomization buildDeveloperCatalog() {
        return this.developerCatalog != null ? this.developerCatalog.build() : null;
    }

    public Capability buildFirstCapability() {
        return this.capabilities.get(0).build();
    }

    public Logo buildFirstLogo() {
        return this.logos.get(0).build();
    }

    public Perspective buildFirstPerspective() {
        return this.perspectives.get(0).build();
    }

    public Capability buildLastCapability() {
        return this.capabilities.get(this.capabilities.size() - 1).build();
    }

    public Logo buildLastLogo() {
        return this.logos.get(this.logos.size() - 1).build();
    }

    public Perspective buildLastPerspective() {
        return this.perspectives.get(this.perspectives.size() - 1).build();
    }

    public Logo buildLogo(int index) {
        return this.logos.get(index).build();
    }

    public List<Logo> buildLogos() {
        return this.logos != null ? ConsoleCustomizationFluent.build(this.logos) : null;
    }

    public Capability buildMatchingCapability(Predicate<CapabilityBuilder> predicate) {
        for (CapabilityBuilder item : this.capabilities) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Logo buildMatchingLogo(Predicate<LogoBuilder> predicate) {
        for (LogoBuilder item : this.logos) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Perspective buildMatchingPerspective(Predicate<PerspectiveBuilder> predicate) {
        for (PerspectiveBuilder item : this.perspectives) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Perspective buildPerspective(int index) {
        return this.perspectives.get(index).build();
    }

    public List<Perspective> buildPerspectives() {
        return this.perspectives != null ? ConsoleCustomizationFluent.build(this.perspectives) : null;
    }

    public ProjectAccess buildProjectAccess() {
        return this.projectAccess != null ? this.projectAccess.build() : null;
    }

    public QuickStarts buildQuickStarts() {
        return this.quickStarts != null ? this.quickStarts.build() : null;
    }

    protected void copyInstance(ConsoleCustomization instance) {
        ConsoleCustomization consoleCustomization = instance = instance != null ? instance : new ConsoleCustomization();
        if (instance != null) {
            this.withAddPage(instance.getAddPage());
            this.withBrand(instance.getBrand());
            this.withCapabilities(instance.getCapabilities());
            this.withCustomLogoFile(instance.getCustomLogoFile());
            this.withCustomProductName(instance.getCustomProductName());
            this.withDeveloperCatalog(instance.getDeveloperCatalog());
            this.withDocumentationBaseURL(instance.getDocumentationBaseURL());
            this.withLogos(instance.getLogos());
            this.withPerspectives(instance.getPerspectives());
            this.withProjectAccess(instance.getProjectAccess());
            this.withQuickStarts(instance.getQuickStarts());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddPageNested<A> editAddPage() {
        return this.withNewAddPageLike(Optional.ofNullable(this.buildAddPage()).orElse(null));
    }

    public CapabilitiesNested<A> editCapability(int index) {
        if (this.capabilities.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "capabilities"));
        }
        return this.setNewCapabilityLike(index, this.buildCapability(index));
    }

    public DeveloperCatalogNested<A> editDeveloperCatalog() {
        return this.withNewDeveloperCatalogLike(Optional.ofNullable(this.buildDeveloperCatalog()).orElse(null));
    }

    public CapabilitiesNested<A> editFirstCapability() {
        if (this.capabilities.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "capabilities"));
        }
        return this.setNewCapabilityLike(0, this.buildCapability(0));
    }

    public LogosNested<A> editFirstLogo() {
        if (this.logos.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "logos"));
        }
        return this.setNewLogoLike(0, this.buildLogo(0));
    }

    public PerspectivesNested<A> editFirstPerspective() {
        if (this.perspectives.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "perspectives"));
        }
        return this.setNewPerspectiveLike(0, this.buildPerspective(0));
    }

    public CapabilitiesNested<A> editLastCapability() {
        int index = this.capabilities.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "capabilities"));
        }
        return this.setNewCapabilityLike(index, this.buildCapability(index));
    }

    public LogosNested<A> editLastLogo() {
        int index = this.logos.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "logos"));
        }
        return this.setNewLogoLike(index, this.buildLogo(index));
    }

    public PerspectivesNested<A> editLastPerspective() {
        int index = this.perspectives.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "perspectives"));
        }
        return this.setNewPerspectiveLike(index, this.buildPerspective(index));
    }

    public LogosNested<A> editLogo(int index) {
        if (this.logos.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "logos"));
        }
        return this.setNewLogoLike(index, this.buildLogo(index));
    }

    public CapabilitiesNested<A> editMatchingCapability(Predicate<CapabilityBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.capabilities.size(); ++i) {
            if (!predicate.test(this.capabilities.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "capabilities"));
        }
        return this.setNewCapabilityLike(index, this.buildCapability(index));
    }

    public LogosNested<A> editMatchingLogo(Predicate<LogoBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.logos.size(); ++i) {
            if (!predicate.test(this.logos.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "logos"));
        }
        return this.setNewLogoLike(index, this.buildLogo(index));
    }

    public PerspectivesNested<A> editMatchingPerspective(Predicate<PerspectiveBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.perspectives.size(); ++i) {
            if (!predicate.test(this.perspectives.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "perspectives"));
        }
        return this.setNewPerspectiveLike(index, this.buildPerspective(index));
    }

    public AddPageNested<A> editOrNewAddPage() {
        return this.withNewAddPageLike(Optional.ofNullable(this.buildAddPage()).orElse(new AddPageBuilder().build()));
    }

    public AddPageNested<A> editOrNewAddPageLike(AddPage item) {
        return this.withNewAddPageLike(Optional.ofNullable(this.buildAddPage()).orElse(item));
    }

    public DeveloperCatalogNested<A> editOrNewDeveloperCatalog() {
        return this.withNewDeveloperCatalogLike(Optional.ofNullable(this.buildDeveloperCatalog()).orElse(new DeveloperConsoleCatalogCustomizationBuilder().build()));
    }

    public DeveloperCatalogNested<A> editOrNewDeveloperCatalogLike(DeveloperConsoleCatalogCustomization item) {
        return this.withNewDeveloperCatalogLike(Optional.ofNullable(this.buildDeveloperCatalog()).orElse(item));
    }

    public ProjectAccessNested<A> editOrNewProjectAccess() {
        return this.withNewProjectAccessLike(Optional.ofNullable(this.buildProjectAccess()).orElse(new ProjectAccessBuilder().build()));
    }

    public ProjectAccessNested<A> editOrNewProjectAccessLike(ProjectAccess item) {
        return this.withNewProjectAccessLike(Optional.ofNullable(this.buildProjectAccess()).orElse(item));
    }

    public QuickStartsNested<A> editOrNewQuickStarts() {
        return this.withNewQuickStartsLike(Optional.ofNullable(this.buildQuickStarts()).orElse(new QuickStartsBuilder().build()));
    }

    public QuickStartsNested<A> editOrNewQuickStartsLike(QuickStarts item) {
        return this.withNewQuickStartsLike(Optional.ofNullable(this.buildQuickStarts()).orElse(item));
    }

    public PerspectivesNested<A> editPerspective(int index) {
        if (this.perspectives.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "perspectives"));
        }
        return this.setNewPerspectiveLike(index, this.buildPerspective(index));
    }

    public ProjectAccessNested<A> editProjectAccess() {
        return this.withNewProjectAccessLike(Optional.ofNullable(this.buildProjectAccess()).orElse(null));
    }

    public QuickStartsNested<A> editQuickStarts() {
        return this.withNewQuickStartsLike(Optional.ofNullable(this.buildQuickStarts()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleCustomizationFluent that = (ConsoleCustomizationFluent)((Object)o);
        if (!Objects.equals((Object)this.addPage, (Object)that.addPage)) {
            return false;
        }
        if (!Objects.equals(this.brand, that.brand)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.customLogoFile, that.customLogoFile)) {
            return false;
        }
        if (!Objects.equals(this.customProductName, that.customProductName)) {
            return false;
        }
        if (!Objects.equals((Object)this.developerCatalog, (Object)that.developerCatalog)) {
            return false;
        }
        if (!Objects.equals(this.documentationBaseURL, that.documentationBaseURL)) {
            return false;
        }
        if (!Objects.equals(this.logos, that.logos)) {
            return false;
        }
        if (!Objects.equals(this.perspectives, that.perspectives)) {
            return false;
        }
        if (!Objects.equals((Object)this.projectAccess, (Object)that.projectAccess)) {
            return false;
        }
        if (!Objects.equals((Object)this.quickStarts, (Object)that.quickStarts)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getBrand() {
        return this.brand;
    }

    public ConfigMapFileReference getCustomLogoFile() {
        return this.customLogoFile;
    }

    public String getCustomProductName() {
        return this.customProductName;
    }

    public String getDocumentationBaseURL() {
        return this.documentationBaseURL;
    }

    public boolean hasAddPage() {
        return this.addPage != null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasBrand() {
        return this.brand != null;
    }

    public boolean hasCapabilities() {
        return this.capabilities != null && !this.capabilities.isEmpty();
    }

    public boolean hasCustomLogoFile() {
        return this.customLogoFile != null;
    }

    public boolean hasCustomProductName() {
        return this.customProductName != null;
    }

    public boolean hasDeveloperCatalog() {
        return this.developerCatalog != null;
    }

    public boolean hasDocumentationBaseURL() {
        return this.documentationBaseURL != null;
    }

    public boolean hasLogos() {
        return this.logos != null && !this.logos.isEmpty();
    }

    public boolean hasMatchingCapability(Predicate<CapabilityBuilder> predicate) {
        for (CapabilityBuilder item : this.capabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingLogo(Predicate<LogoBuilder> predicate) {
        for (LogoBuilder item : this.logos) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingPerspective(Predicate<PerspectiveBuilder> predicate) {
        for (PerspectiveBuilder item : this.perspectives) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPerspectives() {
        return this.perspectives != null && !this.perspectives.isEmpty();
    }

    public boolean hasProjectAccess() {
        return this.projectAccess != null;
    }

    public boolean hasQuickStarts() {
        return this.quickStarts != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addPage, this.brand, this.capabilities, this.customLogoFile, this.customProductName, this.developerCatalog, this.documentationBaseURL, this.logos, this.perspectives, this.projectAccess, this.quickStarts, this.additionalProperties});
    }

    public A removeAllFromCapabilities(Collection<Capability> items) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.get((Object)"capabilities").remove((Object)builder);
            this.capabilities.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLogos(Collection<Logo> items) {
        if (this.logos == null) {
            return (A)((Object)this);
        }
        for (Logo item : items) {
            LogoBuilder builder = new LogoBuilder(item);
            this._visitables.get((Object)"logos").remove((Object)builder);
            this.logos.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPerspectives(Collection<Perspective> items) {
        if (this.perspectives == null) {
            return (A)((Object)this);
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get((Object)"perspectives").remove((Object)builder);
            this.perspectives.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromCapabilities(Capability ... items) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        for (Capability item : items) {
            CapabilityBuilder builder = new CapabilityBuilder(item);
            this._visitables.get((Object)"capabilities").remove((Object)builder);
            this.capabilities.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromLogos(Logo ... items) {
        if (this.logos == null) {
            return (A)((Object)this);
        }
        for (Logo item : items) {
            LogoBuilder builder = new LogoBuilder(item);
            this._visitables.get((Object)"logos").remove((Object)builder);
            this.logos.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPerspectives(Perspective ... items) {
        if (this.perspectives == null) {
            return (A)((Object)this);
        }
        for (Perspective item : items) {
            PerspectiveBuilder builder = new PerspectiveBuilder(item);
            this._visitables.get((Object)"perspectives").remove((Object)builder);
            this.perspectives.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromCapabilities(Predicate<CapabilityBuilder> predicate) {
        if (this.capabilities == null) {
            return (A)((Object)this);
        }
        Iterator<CapabilityBuilder> each = this.capabilities.iterator();
        List visitables = this._visitables.get((Object)"capabilities");
        while (each.hasNext()) {
            CapabilityBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLogos(Predicate<LogoBuilder> predicate) {
        if (this.logos == null) {
            return (A)((Object)this);
        }
        Iterator<LogoBuilder> each = this.logos.iterator();
        List visitables = this._visitables.get((Object)"logos");
        while (each.hasNext()) {
            LogoBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPerspectives(Predicate<PerspectiveBuilder> predicate) {
        if (this.perspectives == null) {
            return (A)((Object)this);
        }
        Iterator<PerspectiveBuilder> each = this.perspectives.iterator();
        List visitables = this._visitables.get((Object)"perspectives");
        while (each.hasNext()) {
            PerspectiveBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public CapabilitiesNested<A> setNewCapabilityLike(int index, Capability item) {
        return new CapabilitiesNested(index, item);
    }

    public LogosNested<A> setNewLogoLike(int index, Logo item) {
        return new LogosNested(index, item);
    }

    public PerspectivesNested<A> setNewPerspectiveLike(int index, Perspective item) {
        return new PerspectivesNested(index, item);
    }

    public A setToCapabilities(int index, Capability item) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList();
        }
        CapabilityBuilder builder = new CapabilityBuilder(item);
        if (index < 0 || index >= this.capabilities.size()) {
            this._visitables.get((Object)"capabilities").add(builder);
            this.capabilities.add(builder);
        } else {
            this._visitables.get((Object)"capabilities").add(builder);
            this.capabilities.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToLogos(int index, Logo item) {
        if (this.logos == null) {
            this.logos = new ArrayList();
        }
        LogoBuilder builder = new LogoBuilder(item);
        if (index < 0 || index >= this.logos.size()) {
            this._visitables.get((Object)"logos").add(builder);
            this.logos.add(builder);
        } else {
            this._visitables.get((Object)"logos").add(builder);
            this.logos.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPerspectives(int index, Perspective item) {
        if (this.perspectives == null) {
            this.perspectives = new ArrayList();
        }
        PerspectiveBuilder builder = new PerspectiveBuilder(item);
        if (index < 0 || index >= this.perspectives.size()) {
            this._visitables.get((Object)"perspectives").add(builder);
            this.perspectives.add(builder);
        } else {
            this._visitables.get((Object)"perspectives").add(builder);
            this.perspectives.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addPage != null) {
            sb.append("addPage:");
            sb.append((Object)this.addPage);
            sb.append(",");
        }
        if (this.brand != null) {
            sb.append("brand:");
            sb.append(this.brand);
            sb.append(",");
        }
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            sb.append("capabilities:");
            sb.append(this.capabilities);
            sb.append(",");
        }
        if (this.customLogoFile != null) {
            sb.append("customLogoFile:");
            sb.append(this.customLogoFile);
            sb.append(",");
        }
        if (this.customProductName != null) {
            sb.append("customProductName:");
            sb.append(this.customProductName);
            sb.append(",");
        }
        if (this.developerCatalog != null) {
            sb.append("developerCatalog:");
            sb.append((Object)this.developerCatalog);
            sb.append(",");
        }
        if (this.documentationBaseURL != null) {
            sb.append("documentationBaseURL:");
            sb.append(this.documentationBaseURL);
            sb.append(",");
        }
        if (this.logos != null && !this.logos.isEmpty()) {
            sb.append("logos:");
            sb.append(this.logos);
            sb.append(",");
        }
        if (this.perspectives != null && !this.perspectives.isEmpty()) {
            sb.append("perspectives:");
            sb.append(this.perspectives);
            sb.append(",");
        }
        if (this.projectAccess != null) {
            sb.append("projectAccess:");
            sb.append((Object)this.projectAccess);
            sb.append(",");
        }
        if (this.quickStarts != null) {
            sb.append("quickStarts:");
            sb.append((Object)this.quickStarts);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAddPage(AddPage addPage) {
        this._visitables.remove((Object)"addPage");
        if (addPage != null) {
            this.addPage = new AddPageBuilder(addPage);
            this._visitables.get((Object)"addPage").add(this.addPage);
        } else {
            this.addPage = null;
            this._visitables.get((Object)"addPage").remove((Object)this.addPage);
        }
        return (A)((Object)this);
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withBrand(String brand) {
        this.brand = brand;
        return (A)((Object)this);
    }

    public A withCapabilities(List<Capability> capabilities) {
        if (this.capabilities != null) {
            this._visitables.get((Object)"capabilities").clear();
        }
        if (capabilities != null) {
            this.capabilities = new ArrayList();
            for (Capability item : capabilities) {
                this.addToCapabilities(item);
            }
        } else {
            this.capabilities = null;
        }
        return (A)((Object)this);
    }

    public A withCapabilities(Capability ... capabilities) {
        if (this.capabilities != null) {
            this.capabilities.clear();
            this._visitables.remove((Object)"capabilities");
        }
        if (capabilities != null) {
            for (Capability item : capabilities) {
                this.addToCapabilities(item);
            }
        }
        return (A)((Object)this);
    }

    public A withCustomLogoFile(ConfigMapFileReference customLogoFile) {
        this.customLogoFile = customLogoFile;
        return (A)((Object)this);
    }

    public A withCustomProductName(String customProductName) {
        this.customProductName = customProductName;
        return (A)((Object)this);
    }

    public A withDeveloperCatalog(DeveloperConsoleCatalogCustomization developerCatalog) {
        this._visitables.remove((Object)"developerCatalog");
        if (developerCatalog != null) {
            this.developerCatalog = new DeveloperConsoleCatalogCustomizationBuilder(developerCatalog);
            this._visitables.get((Object)"developerCatalog").add(this.developerCatalog);
        } else {
            this.developerCatalog = null;
            this._visitables.get((Object)"developerCatalog").remove((Object)this.developerCatalog);
        }
        return (A)((Object)this);
    }

    public A withDocumentationBaseURL(String documentationBaseURL) {
        this.documentationBaseURL = documentationBaseURL;
        return (A)((Object)this);
    }

    public A withLogos(List<Logo> logos) {
        if (this.logos != null) {
            this._visitables.get((Object)"logos").clear();
        }
        if (logos != null) {
            this.logos = new ArrayList();
            for (Logo item : logos) {
                this.addToLogos(item);
            }
        } else {
            this.logos = null;
        }
        return (A)((Object)this);
    }

    public A withLogos(Logo ... logos) {
        if (this.logos != null) {
            this.logos.clear();
            this._visitables.remove((Object)"logos");
        }
        if (logos != null) {
            for (Logo item : logos) {
                this.addToLogos(item);
            }
        }
        return (A)((Object)this);
    }

    public AddPageNested<A> withNewAddPage() {
        return new AddPageNested(null);
    }

    public AddPageNested<A> withNewAddPageLike(AddPage item) {
        return new AddPageNested(item);
    }

    public A withNewCustomLogoFile(String key, String name) {
        return this.withCustomLogoFile(new ConfigMapFileReference(key, name));
    }

    public DeveloperCatalogNested<A> withNewDeveloperCatalog() {
        return new DeveloperCatalogNested(null);
    }

    public DeveloperCatalogNested<A> withNewDeveloperCatalogLike(DeveloperConsoleCatalogCustomization item) {
        return new DeveloperCatalogNested(item);
    }

    public ProjectAccessNested<A> withNewProjectAccess() {
        return new ProjectAccessNested(null);
    }

    public ProjectAccessNested<A> withNewProjectAccessLike(ProjectAccess item) {
        return new ProjectAccessNested(item);
    }

    public QuickStartsNested<A> withNewQuickStarts() {
        return new QuickStartsNested(null);
    }

    public QuickStartsNested<A> withNewQuickStartsLike(QuickStarts item) {
        return new QuickStartsNested(item);
    }

    public A withPerspectives(List<Perspective> perspectives) {
        if (this.perspectives != null) {
            this._visitables.get((Object)"perspectives").clear();
        }
        if (perspectives != null) {
            this.perspectives = new ArrayList();
            for (Perspective item : perspectives) {
                this.addToPerspectives(item);
            }
        } else {
            this.perspectives = null;
        }
        return (A)((Object)this);
    }

    public A withPerspectives(Perspective ... perspectives) {
        if (this.perspectives != null) {
            this.perspectives.clear();
            this._visitables.remove((Object)"perspectives");
        }
        if (perspectives != null) {
            for (Perspective item : perspectives) {
                this.addToPerspectives(item);
            }
        }
        return (A)((Object)this);
    }

    public A withProjectAccess(ProjectAccess projectAccess) {
        this._visitables.remove((Object)"projectAccess");
        if (projectAccess != null) {
            this.projectAccess = new ProjectAccessBuilder(projectAccess);
            this._visitables.get((Object)"projectAccess").add(this.projectAccess);
        } else {
            this.projectAccess = null;
            this._visitables.get((Object)"projectAccess").remove((Object)this.projectAccess);
        }
        return (A)((Object)this);
    }

    public A withQuickStarts(QuickStarts quickStarts) {
        this._visitables.remove((Object)"quickStarts");
        if (quickStarts != null) {
            this.quickStarts = new QuickStartsBuilder(quickStarts);
            this._visitables.get((Object)"quickStarts").add(this.quickStarts);
        } else {
            this.quickStarts = null;
            this._visitables.get((Object)"quickStarts").remove((Object)this.quickStarts);
        }
        return (A)((Object)this);
    }

    public class QuickStartsNested<N>
    extends QuickStartsFluent<QuickStartsNested<N>>
    implements Nested<N> {
        QuickStartsBuilder builder;

        QuickStartsNested(QuickStarts item) {
            this.builder = new QuickStartsBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.withQuickStarts(this.builder.build());
        }

        public N endQuickStarts() {
            return this.and();
        }
    }

    public class ProjectAccessNested<N>
    extends ProjectAccessFluent<ProjectAccessNested<N>>
    implements Nested<N> {
        ProjectAccessBuilder builder;

        ProjectAccessNested(ProjectAccess item) {
            this.builder = new ProjectAccessBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.withProjectAccess(this.builder.build());
        }

        public N endProjectAccess() {
            return this.and();
        }
    }

    public class PerspectivesNested<N>
    extends PerspectiveFluent<PerspectivesNested<N>>
    implements Nested<N> {
        PerspectiveBuilder builder;
        int index;

        PerspectivesNested(int index, Perspective item) {
            this.index = index;
            this.builder = new PerspectiveBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.setToPerspectives(this.index, this.builder.build());
        }

        public N endPerspective() {
            return this.and();
        }
    }

    public class LogosNested<N>
    extends LogoFluent<LogosNested<N>>
    implements Nested<N> {
        LogoBuilder builder;
        int index;

        LogosNested(int index, Logo item) {
            this.index = index;
            this.builder = new LogoBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.setToLogos(this.index, this.builder.build());
        }

        public N endLogo() {
            return this.and();
        }
    }

    public class DeveloperCatalogNested<N>
    extends DeveloperConsoleCatalogCustomizationFluent<DeveloperCatalogNested<N>>
    implements Nested<N> {
        DeveloperConsoleCatalogCustomizationBuilder builder;

        DeveloperCatalogNested(DeveloperConsoleCatalogCustomization item) {
            this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.withDeveloperCatalog(this.builder.build());
        }

        public N endDeveloperCatalog() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends CapabilityFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        CapabilityBuilder builder;
        int index;

        CapabilitiesNested(int index, Capability item) {
            this.index = index;
            this.builder = new CapabilityBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.setToCapabilities(this.index, this.builder.build());
        }

        public N endCapability() {
            return this.and();
        }
    }

    public class AddPageNested<N>
    extends AddPageFluent<AddPageNested<N>>
    implements Nested<N> {
        AddPageBuilder builder;

        AddPageNested(AddPage item) {
            this.builder = new AddPageBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCustomizationFluent.this.withAddPage(this.builder.build());
        }

        public N endAddPage() {
            return this.and();
        }
    }
}

