/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.ingress.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.ingress.v1.DNSRecordSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSRecordSpecFluent<A extends DNSRecordSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String dnsManagementPolicy;
    private String dnsName;
    private Long recordTTL;
    private String recordType;
    private List<String> targets = new ArrayList<String>();

    public DNSRecordSpecFluent() {
    }

    public DNSRecordSpecFluent(DNSRecordSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToTargets(Collection<String> items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTargets(String ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)((Object)this);
    }

    public A addToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(DNSRecordSpec instance) {
        DNSRecordSpec dNSRecordSpec = instance = instance != null ? instance : new DNSRecordSpec();
        if (instance != null) {
            this.withDnsManagementPolicy(instance.getDnsManagementPolicy());
            this.withDnsName(instance.getDnsName());
            this.withRecordTTL(instance.getRecordTTL());
            this.withRecordType(instance.getRecordType());
            this.withTargets(instance.getTargets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSRecordSpecFluent that = (DNSRecordSpecFluent)((Object)o);
        if (!Objects.equals(this.dnsManagementPolicy, that.dnsManagementPolicy)) {
            return false;
        }
        if (!Objects.equals(this.dnsName, that.dnsName)) {
            return false;
        }
        if (!Objects.equals(this.recordTTL, that.recordTTL)) {
            return false;
        }
        if (!Objects.equals(this.recordType, that.recordType)) {
            return false;
        }
        if (!Objects.equals(this.targets, that.targets)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDnsManagementPolicy() {
        return this.dnsManagementPolicy;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getFirstTarget() {
        return this.targets.get(0);
    }

    public String getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    public String getMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Long getRecordTTL() {
        return this.recordTTL;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public String getTarget(int index) {
        return this.targets.get(index);
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDnsManagementPolicy() {
        return this.dnsManagementPolicy != null;
    }

    public boolean hasDnsName() {
        return this.dnsName != null;
    }

    public boolean hasMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRecordTTL() {
        return this.recordTTL != null;
    }

    public boolean hasRecordType() {
        return this.recordType != null;
    }

    public boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.dnsManagementPolicy, this.dnsName, this.recordTTL, this.recordType, this.targets, this.additionalProperties);
    }

    public A removeAllFromTargets(Collection<String> items) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targets.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromTargets(String ... items) {
        if (this.targets == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.targets.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToTargets(int index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsManagementPolicy != null) {
            sb.append("dnsManagementPolicy:");
            sb.append(this.dnsManagementPolicy);
            sb.append(",");
        }
        if (this.dnsName != null) {
            sb.append("dnsName:");
            sb.append(this.dnsName);
            sb.append(",");
        }
        if (this.recordTTL != null) {
            sb.append("recordTTL:");
            sb.append(this.recordTTL);
            sb.append(",");
        }
        if (this.recordType != null) {
            sb.append("recordType:");
            sb.append(this.recordType);
            sb.append(",");
        }
        if (this.targets != null && !this.targets.isEmpty()) {
            sb.append("targets:");
            sb.append(this.targets);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDnsManagementPolicy(String dnsManagementPolicy) {
        this.dnsManagementPolicy = dnsManagementPolicy;
        return (A)((Object)this);
    }

    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)((Object)this);
    }

    public A withRecordTTL(Long recordTTL) {
        this.recordTTL = recordTTL;
        return (A)((Object)this);
    }

    public A withRecordType(String recordType) {
        this.recordType = recordType;
        return (A)((Object)this);
    }

    public A withTargets(List<String> targets) {
        if (targets != null) {
            this.targets = new ArrayList<String>();
            for (String item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)((Object)this);
    }

    public A withTargets(String ... targets) {
        if (this.targets != null) {
            this.targets.clear();
            this._visitables.remove((Object)"targets");
        }
        if (targets != null) {
            for (String item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)((Object)this);
    }
}

