package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PartialSelectorFluent<A extends PartialSelectorFluent<A>> extends BaseFluent<A>{
  public PartialSelectorFluent() {
  }
  
  public PartialSelectorFluent(PartialSelector instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder machineResourceSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PartialSelector instance) {
    instance = (instance != null ? instance : new PartialSelector());
    if (instance != null) {
          this.withMachineResourceSelector(instance.getMachineResourceSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LabelSelector buildMachineResourceSelector() {
    return this.machineResourceSelector != null ? this.machineResourceSelector.build() : null;
  }
  
  public A withMachineResourceSelector(LabelSelector machineResourceSelector) {
    this._visitables.remove("machineResourceSelector");
    if (machineResourceSelector != null) {
        this.machineResourceSelector = new LabelSelectorBuilder(machineResourceSelector);
        this._visitables.get("machineResourceSelector").add(this.machineResourceSelector);
    } else {
        this.machineResourceSelector = null;
        this._visitables.get("machineResourceSelector").remove(this.machineResourceSelector);
    }
    return (A) this;
  }
  
  public boolean hasMachineResourceSelector() {
    return this.machineResourceSelector != null;
  }
  
  public MachineResourceSelectorNested<A> withNewMachineResourceSelector() {
    return new MachineResourceSelectorNested(null);
  }
  
  public MachineResourceSelectorNested<A> withNewMachineResourceSelectorLike(LabelSelector item) {
    return new MachineResourceSelectorNested(item);
  }
  
  public MachineResourceSelectorNested<A> editMachineResourceSelector() {
    return withNewMachineResourceSelectorLike(java.util.Optional.ofNullable(buildMachineResourceSelector()).orElse(null));
  }
  
  public MachineResourceSelectorNested<A> editOrNewMachineResourceSelector() {
    return withNewMachineResourceSelectorLike(java.util.Optional.ofNullable(buildMachineResourceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public MachineResourceSelectorNested<A> editOrNewMachineResourceSelectorLike(LabelSelector item) {
    return withNewMachineResourceSelectorLike(java.util.Optional.ofNullable(buildMachineResourceSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PartialSelectorFluent that = (PartialSelectorFluent) o;
    if (!java.util.Objects.equals(machineResourceSelector, that.machineResourceSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(machineResourceSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (machineResourceSelector != null) { sb.append("machineResourceSelector:"); sb.append(machineResourceSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MachineResourceSelectorNested<N> extends LabelSelectorFluent<MachineResourceSelectorNested<N>> implements Nested<N>{
    MachineResourceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) PartialSelectorFluent.this.withMachineResourceSelector(builder.build());
    }
    
    public N endMachineResourceSelector() {
      return and();
    }
    
  
  }

}