package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineConfigurationSpecFluent<A extends MachineConfigurationSpecFluent<A>> extends BaseFluent<A>{
  public MachineConfigurationSpecFluent() {
  }
  
  public MachineConfigurationSpecFluent(MachineConfigurationSpec instance) {
    this.copyInstance(instance);
  }
  private Integer failedRevisionLimit;
  private String forceRedeploymentReason;
  private String logLevel;
  private ManagedBootImagesBuilder managedBootImages;
  private String managementState;
  private NodeDisruptionPolicyConfigBuilder nodeDisruptionPolicy;
  private Object observedConfig;
  private String operatorLogLevel;
  private Integer succeededRevisionLimit;
  private Object unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineConfigurationSpec instance) {
    instance = (instance != null ? instance : new MachineConfigurationSpec());
    if (instance != null) {
          this.withFailedRevisionLimit(instance.getFailedRevisionLimit());
          this.withForceRedeploymentReason(instance.getForceRedeploymentReason());
          this.withLogLevel(instance.getLogLevel());
          this.withManagedBootImages(instance.getManagedBootImages());
          this.withManagementState(instance.getManagementState());
          this.withNodeDisruptionPolicy(instance.getNodeDisruptionPolicy());
          this.withObservedConfig(instance.getObservedConfig());
          this.withOperatorLogLevel(instance.getOperatorLogLevel());
          this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
          this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getFailedRevisionLimit() {
    return this.failedRevisionLimit;
  }
  
  public A withFailedRevisionLimit(Integer failedRevisionLimit) {
    this.failedRevisionLimit = failedRevisionLimit;
    return (A) this;
  }
  
  public boolean hasFailedRevisionLimit() {
    return this.failedRevisionLimit != null;
  }
  
  public String getForceRedeploymentReason() {
    return this.forceRedeploymentReason;
  }
  
  public A withForceRedeploymentReason(String forceRedeploymentReason) {
    this.forceRedeploymentReason = forceRedeploymentReason;
    return (A) this;
  }
  
  public boolean hasForceRedeploymentReason() {
    return this.forceRedeploymentReason != null;
  }
  
  public String getLogLevel() {
    return this.logLevel;
  }
  
  public A withLogLevel(String logLevel) {
    this.logLevel = logLevel;
    return (A) this;
  }
  
  public boolean hasLogLevel() {
    return this.logLevel != null;
  }
  
  public ManagedBootImages buildManagedBootImages() {
    return this.managedBootImages != null ? this.managedBootImages.build() : null;
  }
  
  public A withManagedBootImages(ManagedBootImages managedBootImages) {
    this._visitables.remove("managedBootImages");
    if (managedBootImages != null) {
        this.managedBootImages = new ManagedBootImagesBuilder(managedBootImages);
        this._visitables.get("managedBootImages").add(this.managedBootImages);
    } else {
        this.managedBootImages = null;
        this._visitables.get("managedBootImages").remove(this.managedBootImages);
    }
    return (A) this;
  }
  
  public boolean hasManagedBootImages() {
    return this.managedBootImages != null;
  }
  
  public ManagedBootImagesNested<A> withNewManagedBootImages() {
    return new ManagedBootImagesNested(null);
  }
  
  public ManagedBootImagesNested<A> withNewManagedBootImagesLike(ManagedBootImages item) {
    return new ManagedBootImagesNested(item);
  }
  
  public ManagedBootImagesNested<A> editManagedBootImages() {
    return withNewManagedBootImagesLike(java.util.Optional.ofNullable(buildManagedBootImages()).orElse(null));
  }
  
  public ManagedBootImagesNested<A> editOrNewManagedBootImages() {
    return withNewManagedBootImagesLike(java.util.Optional.ofNullable(buildManagedBootImages()).orElse(new ManagedBootImagesBuilder().build()));
  }
  
  public ManagedBootImagesNested<A> editOrNewManagedBootImagesLike(ManagedBootImages item) {
    return withNewManagedBootImagesLike(java.util.Optional.ofNullable(buildManagedBootImages()).orElse(item));
  }
  
  public String getManagementState() {
    return this.managementState;
  }
  
  public A withManagementState(String managementState) {
    this.managementState = managementState;
    return (A) this;
  }
  
  public boolean hasManagementState() {
    return this.managementState != null;
  }
  
  public NodeDisruptionPolicyConfig buildNodeDisruptionPolicy() {
    return this.nodeDisruptionPolicy != null ? this.nodeDisruptionPolicy.build() : null;
  }
  
  public A withNodeDisruptionPolicy(NodeDisruptionPolicyConfig nodeDisruptionPolicy) {
    this._visitables.remove("nodeDisruptionPolicy");
    if (nodeDisruptionPolicy != null) {
        this.nodeDisruptionPolicy = new NodeDisruptionPolicyConfigBuilder(nodeDisruptionPolicy);
        this._visitables.get("nodeDisruptionPolicy").add(this.nodeDisruptionPolicy);
    } else {
        this.nodeDisruptionPolicy = null;
        this._visitables.get("nodeDisruptionPolicy").remove(this.nodeDisruptionPolicy);
    }
    return (A) this;
  }
  
  public boolean hasNodeDisruptionPolicy() {
    return this.nodeDisruptionPolicy != null;
  }
  
  public NodeDisruptionPolicyNested<A> withNewNodeDisruptionPolicy() {
    return new NodeDisruptionPolicyNested(null);
  }
  
  public NodeDisruptionPolicyNested<A> withNewNodeDisruptionPolicyLike(NodeDisruptionPolicyConfig item) {
    return new NodeDisruptionPolicyNested(item);
  }
  
  public NodeDisruptionPolicyNested<A> editNodeDisruptionPolicy() {
    return withNewNodeDisruptionPolicyLike(java.util.Optional.ofNullable(buildNodeDisruptionPolicy()).orElse(null));
  }
  
  public NodeDisruptionPolicyNested<A> editOrNewNodeDisruptionPolicy() {
    return withNewNodeDisruptionPolicyLike(java.util.Optional.ofNullable(buildNodeDisruptionPolicy()).orElse(new NodeDisruptionPolicyConfigBuilder().build()));
  }
  
  public NodeDisruptionPolicyNested<A> editOrNewNodeDisruptionPolicyLike(NodeDisruptionPolicyConfig item) {
    return withNewNodeDisruptionPolicyLike(java.util.Optional.ofNullable(buildNodeDisruptionPolicy()).orElse(item));
  }
  
  public Object getObservedConfig() {
    return this.observedConfig;
  }
  
  public A withObservedConfig(Object observedConfig) {
    this.observedConfig = observedConfig;
    return (A) this;
  }
  
  public boolean hasObservedConfig() {
    return this.observedConfig != null;
  }
  
  public String getOperatorLogLevel() {
    return this.operatorLogLevel;
  }
  
  public A withOperatorLogLevel(String operatorLogLevel) {
    this.operatorLogLevel = operatorLogLevel;
    return (A) this;
  }
  
  public boolean hasOperatorLogLevel() {
    return this.operatorLogLevel != null;
  }
  
  public Integer getSucceededRevisionLimit() {
    return this.succeededRevisionLimit;
  }
  
  public A withSucceededRevisionLimit(Integer succeededRevisionLimit) {
    this.succeededRevisionLimit = succeededRevisionLimit;
    return (A) this;
  }
  
  public boolean hasSucceededRevisionLimit() {
    return this.succeededRevisionLimit != null;
  }
  
  public Object getUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides;
  }
  
  public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
    this.unsupportedConfigOverrides = unsupportedConfigOverrides;
    return (A) this;
  }
  
  public boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineConfigurationSpecFluent that = (MachineConfigurationSpecFluent) o;
    if (!java.util.Objects.equals(failedRevisionLimit, that.failedRevisionLimit)) return false;
    if (!java.util.Objects.equals(forceRedeploymentReason, that.forceRedeploymentReason)) return false;
    if (!java.util.Objects.equals(logLevel, that.logLevel)) return false;
    if (!java.util.Objects.equals(managedBootImages, that.managedBootImages)) return false;
    if (!java.util.Objects.equals(managementState, that.managementState)) return false;
    if (!java.util.Objects.equals(nodeDisruptionPolicy, that.nodeDisruptionPolicy)) return false;
    if (!java.util.Objects.equals(observedConfig, that.observedConfig)) return false;
    if (!java.util.Objects.equals(operatorLogLevel, that.operatorLogLevel)) return false;
    if (!java.util.Objects.equals(succeededRevisionLimit, that.succeededRevisionLimit)) return false;
    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(failedRevisionLimit,  forceRedeploymentReason,  logLevel,  managedBootImages,  managementState,  nodeDisruptionPolicy,  observedConfig,  operatorLogLevel,  succeededRevisionLimit,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (failedRevisionLimit != null) { sb.append("failedRevisionLimit:"); sb.append(failedRevisionLimit + ","); }
    if (forceRedeploymentReason != null) { sb.append("forceRedeploymentReason:"); sb.append(forceRedeploymentReason + ","); }
    if (logLevel != null) { sb.append("logLevel:"); sb.append(logLevel + ","); }
    if (managedBootImages != null) { sb.append("managedBootImages:"); sb.append(managedBootImages + ","); }
    if (managementState != null) { sb.append("managementState:"); sb.append(managementState + ","); }
    if (nodeDisruptionPolicy != null) { sb.append("nodeDisruptionPolicy:"); sb.append(nodeDisruptionPolicy + ","); }
    if (observedConfig != null) { sb.append("observedConfig:"); sb.append(observedConfig + ","); }
    if (operatorLogLevel != null) { sb.append("operatorLogLevel:"); sb.append(operatorLogLevel + ","); }
    if (succeededRevisionLimit != null) { sb.append("succeededRevisionLimit:"); sb.append(succeededRevisionLimit + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ManagedBootImagesNested<N> extends ManagedBootImagesFluent<ManagedBootImagesNested<N>> implements Nested<N>{
    ManagedBootImagesNested(ManagedBootImages item) {
      this.builder = new ManagedBootImagesBuilder(this, item);
    }
    ManagedBootImagesBuilder builder;
    
    public N and() {
      return (N) MachineConfigurationSpecFluent.this.withManagedBootImages(builder.build());
    }
    
    public N endManagedBootImages() {
      return and();
    }
    
  
  }
  public class NodeDisruptionPolicyNested<N> extends NodeDisruptionPolicyConfigFluent<NodeDisruptionPolicyNested<N>> implements Nested<N>{
    NodeDisruptionPolicyNested(NodeDisruptionPolicyConfig item) {
      this.builder = new NodeDisruptionPolicyConfigBuilder(this, item);
    }
    NodeDisruptionPolicyConfigBuilder builder;
    
    public N and() {
      return (N) MachineConfigurationSpecFluent.this.withNodeDisruptionPolicy(builder.build());
    }
    
    public N endNodeDisruptionPolicy() {
      return and();
    }
    
  
  }

}