package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineConfigurationBuilder extends MachineConfigurationFluent<MachineConfigurationBuilder> implements VisitableBuilder<MachineConfiguration,MachineConfigurationBuilder>{
  public MachineConfigurationBuilder() {
    this(new MachineConfiguration());
  }
  
  public MachineConfigurationBuilder(MachineConfigurationFluent<?> fluent) {
    this(fluent, new MachineConfiguration());
  }
  
  public MachineConfigurationBuilder(MachineConfigurationFluent<?> fluent,MachineConfiguration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineConfigurationBuilder(MachineConfiguration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineConfigurationFluent<?> fluent;
  
  public MachineConfiguration build() {
    MachineConfiguration buildable = new MachineConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}