package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LoadBalancerStrategyBuilder extends LoadBalancerStrategyFluent<LoadBalancerStrategyBuilder> implements VisitableBuilder<LoadBalancerStrategy,LoadBalancerStrategyBuilder>{
  public LoadBalancerStrategyBuilder() {
    this(new LoadBalancerStrategy());
  }
  
  public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent) {
    this(fluent, new LoadBalancerStrategy());
  }
  
  public LoadBalancerStrategyBuilder(LoadBalancerStrategyFluent<?> fluent,LoadBalancerStrategy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LoadBalancerStrategyBuilder(LoadBalancerStrategy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LoadBalancerStrategyFluent<?> fluent;
  
  public LoadBalancerStrategy build() {
    LoadBalancerStrategy buildable = new LoadBalancerStrategy(fluent.getAllowedSourceRanges(),fluent.getDnsManagementPolicy(),fluent.buildProviderParameters(),fluent.getScope());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}