package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KubeAPIServerBuilder extends KubeAPIServerFluent<KubeAPIServerBuilder> implements VisitableBuilder<KubeAPIServer,KubeAPIServerBuilder>{
  public KubeAPIServerBuilder() {
    this(new KubeAPIServer());
  }
  
  public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent) {
    this(fluent, new KubeAPIServer());
  }
  
  public KubeAPIServerBuilder(KubeAPIServerFluent<?> fluent,KubeAPIServer instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KubeAPIServerBuilder(KubeAPIServer instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KubeAPIServerFluent<?> fluent;
  
  public KubeAPIServer build() {
    KubeAPIServer buildable = new KubeAPIServer(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}