package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressFluent<A extends IngressFluent<A>> extends BaseFluent<A>{
  public IngressFluent() {
  }
  
  public IngressFluent(Ingress instance) {
    this.copyInstance(instance);
  }
  private String clientDownloadsURL;
  private String consoleURL;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Ingress instance) {
    instance = (instance != null ? instance : new Ingress());
    if (instance != null) {
          this.withClientDownloadsURL(instance.getClientDownloadsURL());
          this.withConsoleURL(instance.getConsoleURL());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getClientDownloadsURL() {
    return this.clientDownloadsURL;
  }
  
  public A withClientDownloadsURL(String clientDownloadsURL) {
    this.clientDownloadsURL = clientDownloadsURL;
    return (A) this;
  }
  
  public boolean hasClientDownloadsURL() {
    return this.clientDownloadsURL != null;
  }
  
  public String getConsoleURL() {
    return this.consoleURL;
  }
  
  public A withConsoleURL(String consoleURL) {
    this.consoleURL = consoleURL;
    return (A) this;
  }
  
  public boolean hasConsoleURL() {
    return this.consoleURL != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressFluent that = (IngressFluent) o;
    if (!java.util.Objects.equals(clientDownloadsURL, that.clientDownloadsURL)) return false;
    if (!java.util.Objects.equals(consoleURL, that.consoleURL)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clientDownloadsURL,  consoleURL,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientDownloadsURL != null) { sb.append("clientDownloadsURL:"); sb.append(clientDownloadsURL + ","); }
    if (consoleURL != null) { sb.append("consoleURL:"); sb.append(consoleURL + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}