package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HybridOverlayConfigBuilder extends HybridOverlayConfigFluent<HybridOverlayConfigBuilder> implements VisitableBuilder<HybridOverlayConfig,HybridOverlayConfigBuilder>{
  public HybridOverlayConfigBuilder() {
    this(new HybridOverlayConfig());
  }
  
  public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent) {
    this(fluent, new HybridOverlayConfig());
  }
  
  public HybridOverlayConfigBuilder(HybridOverlayConfigFluent<?> fluent,HybridOverlayConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HybridOverlayConfigBuilder(HybridOverlayConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HybridOverlayConfigFluent<?> fluent;
  
  public HybridOverlayConfig build() {
    HybridOverlayConfig buildable = new HybridOverlayConfig(fluent.buildHybridClusterNetwork(),fluent.getHybridOverlayVXLANPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}