package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.openshift.api.model.config.v1.SecretNameReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsoleConfigRouteFluent<A extends ConsoleConfigRouteFluent<A>> extends BaseFluent<A>{
  public ConsoleConfigRouteFluent() {
  }
  
  public ConsoleConfigRouteFluent(ConsoleConfigRoute instance) {
    this.copyInstance(instance);
  }
  private String hostname;
  private SecretNameReference secret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsoleConfigRoute instance) {
    instance = (instance != null ? instance : new ConsoleConfigRoute());
    if (instance != null) {
          this.withHostname(instance.getHostname());
          this.withSecret(instance.getSecret());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getHostname() {
    return this.hostname;
  }
  
  public A withHostname(String hostname) {
    this.hostname = hostname;
    return (A) this;
  }
  
  public boolean hasHostname() {
    return this.hostname != null;
  }
  
  public SecretNameReference getSecret() {
    return this.secret;
  }
  
  public A withSecret(SecretNameReference secret) {
    this.secret = secret;
    return (A) this;
  }
  
  public boolean hasSecret() {
    return this.secret != null;
  }
  
  public A withNewSecret(String name) {
    return (A)withSecret(new SecretNameReference(name));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleConfigRouteFluent that = (ConsoleConfigRouteFluent) o;
    if (!java.util.Objects.equals(hostname, that.hostname)) return false;
    if (!java.util.Objects.equals(secret, that.secret)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(hostname,  secret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}