package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CSIDriverConfigSpecBuilder extends CSIDriverConfigSpecFluent<CSIDriverConfigSpecBuilder> implements VisitableBuilder<CSIDriverConfigSpec,CSIDriverConfigSpecBuilder>{
  public CSIDriverConfigSpecBuilder() {
    this(new CSIDriverConfigSpec());
  }
  
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpecFluent<?> fluent) {
    this(fluent, new CSIDriverConfigSpec());
  }
  
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpecFluent<?> fluent,CSIDriverConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CSIDriverConfigSpecBuilder(CSIDriverConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CSIDriverConfigSpecFluent<?> fluent;
  
  public CSIDriverConfigSpec build() {
    CSIDriverConfigSpec buildable = new CSIDriverConfigSpec(fluent.buildAws(),fluent.buildAzure(),fluent.getDriverType(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildVSphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}