package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSEFSVolumeMetricsRecursiveWalkConfigFluent<A extends AWSEFSVolumeMetricsRecursiveWalkConfigFluent<A>> extends BaseFluent<A>{
  public AWSEFSVolumeMetricsRecursiveWalkConfigFluent() {
  }
  
  public AWSEFSVolumeMetricsRecursiveWalkConfigFluent(AWSEFSVolumeMetricsRecursiveWalkConfig instance) {
    this.copyInstance(instance);
  }
  private Integer fsRateLimit;
  private Integer refreshPeriodMinutes;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSEFSVolumeMetricsRecursiveWalkConfig instance) {
    instance = (instance != null ? instance : new AWSEFSVolumeMetricsRecursiveWalkConfig());
    if (instance != null) {
          this.withFsRateLimit(instance.getFsRateLimit());
          this.withRefreshPeriodMinutes(instance.getRefreshPeriodMinutes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getFsRateLimit() {
    return this.fsRateLimit;
  }
  
  public A withFsRateLimit(Integer fsRateLimit) {
    this.fsRateLimit = fsRateLimit;
    return (A) this;
  }
  
  public boolean hasFsRateLimit() {
    return this.fsRateLimit != null;
  }
  
  public Integer getRefreshPeriodMinutes() {
    return this.refreshPeriodMinutes;
  }
  
  public A withRefreshPeriodMinutes(Integer refreshPeriodMinutes) {
    this.refreshPeriodMinutes = refreshPeriodMinutes;
    return (A) this;
  }
  
  public boolean hasRefreshPeriodMinutes() {
    return this.refreshPeriodMinutes != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSEFSVolumeMetricsRecursiveWalkConfigFluent that = (AWSEFSVolumeMetricsRecursiveWalkConfigFluent) o;
    if (!java.util.Objects.equals(fsRateLimit, that.fsRateLimit)) return false;
    if (!java.util.Objects.equals(refreshPeriodMinutes, that.refreshPeriodMinutes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fsRateLimit,  refreshPeriodMinutes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsRateLimit != null) { sb.append("fsRateLimit:"); sb.append(fsRateLimit + ","); }
    if (refreshPeriodMinutes != null) { sb.append("refreshPeriodMinutes:"); sb.append(refreshPeriodMinutes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}