/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AWSCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.AWSEFSVolumeMetrics;
import io.fabric8.openshift.api.model.operator.v1.AWSEFSVolumeMetricsBuilder;
import io.fabric8.openshift.api.model.operator.v1.AWSEFSVolumeMetricsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AWSCSIDriverConfigSpecFluent<A extends AWSCSIDriverConfigSpecFluent<A>>
extends BaseFluent<A> {
    private AWSEFSVolumeMetricsBuilder efsVolumeMetrics;
    private String kmsKeyARN;
    private Map<String, Object> additionalProperties;

    public AWSCSIDriverConfigSpecFluent() {
    }

    public AWSCSIDriverConfigSpecFluent(AWSCSIDriverConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSCSIDriverConfigSpec instance) {
        AWSCSIDriverConfigSpec aWSCSIDriverConfigSpec = instance = instance != null ? instance : new AWSCSIDriverConfigSpec();
        if (instance != null) {
            this.withEfsVolumeMetrics(instance.getEfsVolumeMetrics());
            this.withKmsKeyARN(instance.getKmsKeyARN());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AWSEFSVolumeMetrics buildEfsVolumeMetrics() {
        return this.efsVolumeMetrics != null ? this.efsVolumeMetrics.build() : null;
    }

    public A withEfsVolumeMetrics(AWSEFSVolumeMetrics efsVolumeMetrics) {
        this._visitables.remove((Object)"efsVolumeMetrics");
        if (efsVolumeMetrics != null) {
            this.efsVolumeMetrics = new AWSEFSVolumeMetricsBuilder(efsVolumeMetrics);
            this._visitables.get((Object)"efsVolumeMetrics").add(this.efsVolumeMetrics);
        } else {
            this.efsVolumeMetrics = null;
            this._visitables.get((Object)"efsVolumeMetrics").remove((Object)this.efsVolumeMetrics);
        }
        return (A)((Object)this);
    }

    public boolean hasEfsVolumeMetrics() {
        return this.efsVolumeMetrics != null;
    }

    public EfsVolumeMetricsNested<A> withNewEfsVolumeMetrics() {
        return new EfsVolumeMetricsNested(null);
    }

    public EfsVolumeMetricsNested<A> withNewEfsVolumeMetricsLike(AWSEFSVolumeMetrics item) {
        return new EfsVolumeMetricsNested(item);
    }

    public EfsVolumeMetricsNested<A> editEfsVolumeMetrics() {
        return this.withNewEfsVolumeMetricsLike(Optional.ofNullable(this.buildEfsVolumeMetrics()).orElse(null));
    }

    public EfsVolumeMetricsNested<A> editOrNewEfsVolumeMetrics() {
        return this.withNewEfsVolumeMetricsLike(Optional.ofNullable(this.buildEfsVolumeMetrics()).orElse(new AWSEFSVolumeMetricsBuilder().build()));
    }

    public EfsVolumeMetricsNested<A> editOrNewEfsVolumeMetricsLike(AWSEFSVolumeMetrics item) {
        return this.withNewEfsVolumeMetricsLike(Optional.ofNullable(this.buildEfsVolumeMetrics()).orElse(item));
    }

    public String getKmsKeyARN() {
        return this.kmsKeyARN;
    }

    public A withKmsKeyARN(String kmsKeyARN) {
        this.kmsKeyARN = kmsKeyARN;
        return (A)((Object)this);
    }

    public boolean hasKmsKeyARN() {
        return this.kmsKeyARN != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSCSIDriverConfigSpecFluent that = (AWSCSIDriverConfigSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.efsVolumeMetrics, (Object)that.efsVolumeMetrics)) {
            return false;
        }
        if (!Objects.equals(this.kmsKeyARN, that.kmsKeyARN)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.efsVolumeMetrics, this.kmsKeyARN, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.efsVolumeMetrics != null) {
            sb.append("efsVolumeMetrics:");
            sb.append(String.valueOf((Object)this.efsVolumeMetrics) + ",");
        }
        if (this.kmsKeyARN != null) {
            sb.append("kmsKeyARN:");
            sb.append(this.kmsKeyARN + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EfsVolumeMetricsNested<N>
    extends AWSEFSVolumeMetricsFluent<EfsVolumeMetricsNested<N>>
    implements Nested<N> {
        AWSEFSVolumeMetricsBuilder builder;

        EfsVolumeMetricsNested(AWSEFSVolumeMetrics item) {
            this.builder = new AWSEFSVolumeMetricsBuilder(this, item);
        }

        public N and() {
            return (N)AWSCSIDriverConfigSpecFluent.this.withEfsVolumeMetrics(this.builder.build());
        }

        public N endEfsVolumeMetrics() {
            return this.and();
        }
    }
}

