/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1.AzureCSIDriverConfigSpec;
import io.fabric8.openshift.api.model.operator.v1.AzureDiskEncryptionSet;
import io.fabric8.openshift.api.model.operator.v1.AzureDiskEncryptionSetBuilder;
import io.fabric8.openshift.api.model.operator.v1.AzureDiskEncryptionSetFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AzureCSIDriverConfigSpecFluent<A extends AzureCSIDriverConfigSpecFluent<A>>
extends BaseFluent<A> {
    private AzureDiskEncryptionSetBuilder diskEncryptionSet;
    private Map<String, Object> additionalProperties;

    public AzureCSIDriverConfigSpecFluent() {
    }

    public AzureCSIDriverConfigSpecFluent(AzureCSIDriverConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AzureCSIDriverConfigSpec instance) {
        AzureCSIDriverConfigSpec azureCSIDriverConfigSpec = instance = instance != null ? instance : new AzureCSIDriverConfigSpec();
        if (instance != null) {
            this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
            this.withDiskEncryptionSet(instance.getDiskEncryptionSet());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AzureDiskEncryptionSet buildDiskEncryptionSet() {
        return this.diskEncryptionSet != null ? this.diskEncryptionSet.build() : null;
    }

    public A withDiskEncryptionSet(AzureDiskEncryptionSet diskEncryptionSet) {
        this._visitables.get((Object)"diskEncryptionSet").remove((Object)this.diskEncryptionSet);
        if (diskEncryptionSet != null) {
            this.diskEncryptionSet = new AzureDiskEncryptionSetBuilder(diskEncryptionSet);
            this._visitables.get((Object)"diskEncryptionSet").add(this.diskEncryptionSet);
        } else {
            this.diskEncryptionSet = null;
            this._visitables.get((Object)"diskEncryptionSet").remove((Object)this.diskEncryptionSet);
        }
        return (A)((Object)this);
    }

    public boolean hasDiskEncryptionSet() {
        return this.diskEncryptionSet != null;
    }

    public A withNewDiskEncryptionSet(String name, String resourceGroup, String subscriptionID) {
        return this.withDiskEncryptionSet(new AzureDiskEncryptionSet(name, resourceGroup, subscriptionID));
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSet() {
        return new DiskEncryptionSetNested(null);
    }

    public DiskEncryptionSetNested<A> withNewDiskEncryptionSetLike(AzureDiskEncryptionSet item) {
        return new DiskEncryptionSetNested(item);
    }

    public DiskEncryptionSetNested<A> editDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(null));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSet() {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(new AzureDiskEncryptionSetBuilder().build()));
    }

    public DiskEncryptionSetNested<A> editOrNewDiskEncryptionSetLike(AzureDiskEncryptionSet item) {
        return this.withNewDiskEncryptionSetLike(Optional.ofNullable(this.buildDiskEncryptionSet()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureCSIDriverConfigSpecFluent that = (AzureCSIDriverConfigSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.diskEncryptionSet, (Object)that.diskEncryptionSet)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diskEncryptionSet, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.diskEncryptionSet != null) {
            sb.append("diskEncryptionSet:");
            sb.append((Object)((Object)this.diskEncryptionSet) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DiskEncryptionSetNested<N>
    extends AzureDiskEncryptionSetFluent<DiskEncryptionSetNested<N>>
    implements Nested<N> {
        AzureDiskEncryptionSetBuilder builder;

        DiskEncryptionSetNested(AzureDiskEncryptionSet item) {
            this.builder = new AzureDiskEncryptionSetBuilder(this, item);
        }

        public N and() {
            return (N)AzureCSIDriverConfigSpecFluent.this.withDiskEncryptionSet(this.builder.build());
        }

        public N endDiskEncryptionSet() {
            return this.and();
        }
    }
}

