/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordSpec;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSRecordSpecFluentImpl<A extends DNSRecordSpecFluent<A>>
extends BaseFluent<A>
implements DNSRecordSpecFluent<A> {
    private String dnsName;
    private Long recordTTL;
    private String recordType;
    private List<String> targets = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public DNSRecordSpecFluentImpl() {
    }

    public DNSRecordSpecFluentImpl(DNSRecordSpec instance) {
        this.withDnsName(instance.getDnsName());
        this.withRecordTTL(instance.getRecordTTL());
        this.withRecordType(instance.getRecordType());
        this.withTargets(instance.getTargets());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDnsName() {
        return this.dnsName;
    }

    @Override
    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)this;
    }

    @Override
    public Boolean hasDnsName() {
        return this.dnsName != null;
    }

    @Override
    public Long getRecordTTL() {
        return this.recordTTL;
    }

    @Override
    public A withRecordTTL(Long recordTTL) {
        this.recordTTL = recordTTL;
        return (A)this;
    }

    @Override
    public Boolean hasRecordTTL() {
        return this.recordTTL != null;
    }

    @Override
    public String getRecordType() {
        return this.recordType;
    }

    @Override
    public A withRecordType(String recordType) {
        this.recordType = recordType;
        return (A)this;
    }

    @Override
    public Boolean hasRecordType() {
        return this.recordType != null;
    }

    @Override
    public A addToTargets(Integer index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTargets(Integer index, String item) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        this.targets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTargets(String ... items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargets(Collection<String> items) {
        if (this.targets == null) {
            this.targets = new ArrayList<String>();
        }
        for (String item : items) {
            this.targets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargets(String ... items) {
        for (String item : items) {
            if (this.targets == null) continue;
            this.targets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargets(Collection<String> items) {
        for (String item : items) {
            if (this.targets == null) continue;
            this.targets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public String getTarget(Integer index) {
        return this.targets.get(index);
    }

    @Override
    public String getFirstTarget() {
        return this.targets.get(0);
    }

    @Override
    public String getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    @Override
    public String getMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTarget(Predicate<String> predicate) {
        for (String item : this.targets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTargets(List<String> targets) {
        if (targets != null) {
            this.targets = new ArrayList<String>();
            for (String item : targets) {
                this.addToTargets(item);
            }
        } else {
            this.targets = null;
        }
        return (A)this;
    }

    @Override
    public A withTargets(String ... targets) {
        if (this.targets != null) {
            this.targets.clear();
        }
        if (targets != null) {
            for (String item : targets) {
                this.addToTargets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargets() {
        return this.targets != null && !this.targets.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSRecordSpecFluentImpl that = (DNSRecordSpecFluentImpl)o;
        if (this.dnsName != null ? !this.dnsName.equals(that.dnsName) : that.dnsName != null) {
            return false;
        }
        if (this.recordTTL != null ? !this.recordTTL.equals(that.recordTTL) : that.recordTTL != null) {
            return false;
        }
        if (this.recordType != null ? !this.recordType.equals(that.recordType) : that.recordType != null) {
            return false;
        }
        if (this.targets != null ? !this.targets.equals(that.targets) : that.targets != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.dnsName, this.recordTTL, this.recordType, this.targets, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dnsName != null) {
            sb.append("dnsName:");
            sb.append(this.dnsName + ",");
        }
        if (this.recordTTL != null) {
            sb.append("recordTTL:");
            sb.append(this.recordTTL + ",");
        }
        if (this.recordType != null) {
            sb.append("recordType:");
            sb.append(this.recordType + ",");
        }
        if (this.targets != null && !this.targets.isEmpty()) {
            sb.append("targets:");
            sb.append(this.targets + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

