/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1.MachineOSBuilderReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ObjectReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ObjectReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineOSBuilderReferenceFluent<A extends MachineOSBuilderReferenceFluent<A>>
extends BaseFluent<A> {
    private String imageBuilderType;
    private ObjectReferenceBuilder job;
    private Map<String, Object> additionalProperties;

    public MachineOSBuilderReferenceFluent() {
    }

    public MachineOSBuilderReferenceFluent(MachineOSBuilderReference instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineOSBuilderReference instance) {
        MachineOSBuilderReference machineOSBuilderReference = instance = instance != null ? instance : new MachineOSBuilderReference();
        if (instance != null) {
            this.withImageBuilderType(instance.getImageBuilderType());
            this.withJob(instance.getJob());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getImageBuilderType() {
        return this.imageBuilderType;
    }

    public A withImageBuilderType(String imageBuilderType) {
        this.imageBuilderType = imageBuilderType;
        return (A)((Object)this);
    }

    public boolean hasImageBuilderType() {
        return this.imageBuilderType != null;
    }

    public ObjectReference buildJob() {
        return this.job != null ? this.job.build() : null;
    }

    public A withJob(ObjectReference job) {
        this._visitables.remove((Object)"job");
        if (job != null) {
            this.job = new ObjectReferenceBuilder(job);
            this._visitables.get((Object)"job").add(this.job);
        } else {
            this.job = null;
            this._visitables.get((Object)"job").remove((Object)this.job);
        }
        return (A)((Object)this);
    }

    public boolean hasJob() {
        return this.job != null;
    }

    public A withNewJob(String group, String name, String namespace, String resource) {
        return this.withJob(new ObjectReference(group, name, namespace, resource));
    }

    public JobNested<A> withNewJob() {
        return new JobNested(null);
    }

    public JobNested<A> withNewJobLike(ObjectReference item) {
        return new JobNested(item);
    }

    public JobNested<A> editJob() {
        return this.withNewJobLike(Optional.ofNullable(this.buildJob()).orElse(null));
    }

    public JobNested<A> editOrNewJob() {
        return this.withNewJobLike(Optional.ofNullable(this.buildJob()).orElse(new ObjectReferenceBuilder().build()));
    }

    public JobNested<A> editOrNewJobLike(ObjectReference item) {
        return this.withNewJobLike(Optional.ofNullable(this.buildJob()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineOSBuilderReferenceFluent that = (MachineOSBuilderReferenceFluent)((Object)o);
        if (!Objects.equals(this.imageBuilderType, that.imageBuilderType)) {
            return false;
        }
        if (!Objects.equals((Object)this.job, (Object)that.job)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.imageBuilderType, this.job, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageBuilderType != null) {
            sb.append("imageBuilderType:");
            sb.append(this.imageBuilderType + ",");
        }
        if (this.job != null) {
            sb.append("job:");
            sb.append(String.valueOf((Object)this.job) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class JobNested<N>
    extends ObjectReferenceFluent<JobNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        JobNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSBuilderReferenceFluent.this.withJob(this.builder.build());
        }

        public N endJob() {
            return this.and();
        }
    }
}

