/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSBuildStatus;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSBuilderReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSBuilderReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSBuilderReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineOSBuildStatusFluent<A extends MachineOSBuildStatusFluent<A>>
extends BaseFluent<A> {
    private String buildEnd;
    private String buildStart;
    private MachineOSBuilderReferenceBuilder builderReference;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String finalImagePullspec;
    private ArrayList<ObjectReferenceBuilder> relatedObjects = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MachineOSBuildStatusFluent() {
    }

    public MachineOSBuildStatusFluent(MachineOSBuildStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineOSBuildStatus instance) {
        MachineOSBuildStatus machineOSBuildStatus = instance = instance != null ? instance : new MachineOSBuildStatus();
        if (instance != null) {
            this.withBuildEnd(instance.getBuildEnd());
            this.withBuildStart(instance.getBuildStart());
            this.withBuilderReference(instance.getBuilderReference());
            this.withConditions(instance.getConditions());
            this.withFinalImagePullspec(instance.getFinalImagePullspec());
            this.withRelatedObjects(instance.getRelatedObjects());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBuildEnd() {
        return this.buildEnd;
    }

    public A withBuildEnd(String buildEnd) {
        this.buildEnd = buildEnd;
        return (A)((Object)this);
    }

    public boolean hasBuildEnd() {
        return this.buildEnd != null;
    }

    public String getBuildStart() {
        return this.buildStart;
    }

    public A withBuildStart(String buildStart) {
        this.buildStart = buildStart;
        return (A)((Object)this);
    }

    public boolean hasBuildStart() {
        return this.buildStart != null;
    }

    public MachineOSBuilderReference buildBuilderReference() {
        return this.builderReference != null ? this.builderReference.build() : null;
    }

    public A withBuilderReference(MachineOSBuilderReference builderReference) {
        this._visitables.remove((Object)"builderReference");
        if (builderReference != null) {
            this.builderReference = new MachineOSBuilderReferenceBuilder(builderReference);
            this._visitables.get((Object)"builderReference").add(this.builderReference);
        } else {
            this.builderReference = null;
            this._visitables.get((Object)"builderReference").remove((Object)this.builderReference);
        }
        return (A)((Object)this);
    }

    public boolean hasBuilderReference() {
        return this.builderReference != null;
    }

    public BuilderReferenceNested<A> withNewBuilderReference() {
        return new BuilderReferenceNested(null);
    }

    public BuilderReferenceNested<A> withNewBuilderReferenceLike(MachineOSBuilderReference item) {
        return new BuilderReferenceNested(item);
    }

    public BuilderReferenceNested<A> editBuilderReference() {
        return this.withNewBuilderReferenceLike(Optional.ofNullable(this.buildBuilderReference()).orElse(null));
    }

    public BuilderReferenceNested<A> editOrNewBuilderReference() {
        return this.withNewBuilderReferenceLike(Optional.ofNullable(this.buildBuilderReference()).orElse(new MachineOSBuilderReferenceBuilder().build()));
    }

    public BuilderReferenceNested<A> editOrNewBuilderReferenceLike(MachineOSBuilderReference item) {
        return this.withNewBuilderReferenceLike(Optional.ofNullable(this.buildBuilderReference()).orElse(item));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public String getFinalImagePullspec() {
        return this.finalImagePullspec;
    }

    public A withFinalImagePullspec(String finalImagePullspec) {
        this.finalImagePullspec = finalImagePullspec;
        return (A)((Object)this);
    }

    public boolean hasFinalImagePullspec() {
        return this.finalImagePullspec != null;
    }

    public A addToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get((Object)"relatedObjects").add(index, builder);
            this.relatedObjects.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRelatedObjects(int index, ObjectReference item) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.relatedObjects.size()) {
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        } else {
            this._visitables.get((Object)"relatedObjects").set(index, builder);
            this.relatedObjects.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            this.relatedObjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").add(builder);
            this.relatedObjects.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRelatedObjects(ObjectReference ... items) {
        if (this.relatedObjects == null) {
            return (A)((Object)this);
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").remove(builder);
            this.relatedObjects.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRelatedObjects(Collection<ObjectReference> items) {
        if (this.relatedObjects == null) {
            return (A)((Object)this);
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get((Object)"relatedObjects").remove(builder);
            this.relatedObjects.remove(builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelatedObjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.relatedObjects == null) {
            return (A)((Object)this);
        }
        Iterator<ObjectReferenceBuilder> each = this.relatedObjects.iterator();
        List visitables = this._visitables.get((Object)"relatedObjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ObjectReference> buildRelatedObjects() {
        return this.relatedObjects != null ? MachineOSBuildStatusFluent.build(this.relatedObjects) : null;
    }

    public ObjectReference buildRelatedObject(int index) {
        return this.relatedObjects.get(index).build();
    }

    public ObjectReference buildFirstRelatedObject() {
        return this.relatedObjects.get(0).build();
    }

    public ObjectReference buildLastRelatedObject() {
        return this.relatedObjects.get(this.relatedObjects.size() - 1).build();
    }

    public ObjectReference buildMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.relatedObjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRelatedObjects(List<ObjectReference> relatedObjects) {
        if (this.relatedObjects != null) {
            this._visitables.get((Object)"relatedObjects").clear();
        }
        if (relatedObjects != null) {
            this.relatedObjects = new ArrayList();
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        } else {
            this.relatedObjects = null;
        }
        return (A)((Object)this);
    }

    public A withRelatedObjects(ObjectReference ... relatedObjects) {
        if (this.relatedObjects != null) {
            this.relatedObjects.clear();
            this._visitables.remove((Object)"relatedObjects");
        }
        if (relatedObjects != null) {
            for (ObjectReference item : relatedObjects) {
                this.addToRelatedObjects(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRelatedObjects() {
        return this.relatedObjects != null && !this.relatedObjects.isEmpty();
    }

    public RelatedObjectsNested<A> addNewRelatedObject() {
        return new RelatedObjectsNested(-1, null);
    }

    public RelatedObjectsNested<A> addNewRelatedObjectLike(ObjectReference item) {
        return new RelatedObjectsNested(-1, item);
    }

    public RelatedObjectsNested<A> setNewRelatedObjectLike(int index, ObjectReference item) {
        return new RelatedObjectsNested(index, item);
    }

    public RelatedObjectsNested<A> editRelatedObject(int index) {
        if (this.relatedObjects.size() <= index) {
            throw new RuntimeException("Can't edit relatedObjects. Index exceeds size.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public RelatedObjectsNested<A> editFirstRelatedObject() {
        if (this.relatedObjects.size() == 0) {
            throw new RuntimeException("Can't edit first relatedObjects. The list is empty.");
        }
        return this.setNewRelatedObjectLike(0, this.buildRelatedObject(0));
    }

    public RelatedObjectsNested<A> editLastRelatedObject() {
        int index = this.relatedObjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relatedObjects. The list is empty.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public RelatedObjectsNested<A> editMatchingRelatedObject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relatedObjects.size(); ++i) {
            if (!predicate.test(this.relatedObjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relatedObjects. No match found.");
        }
        return this.setNewRelatedObjectLike(index, this.buildRelatedObject(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineOSBuildStatusFluent that = (MachineOSBuildStatusFluent)((Object)o);
        if (!Objects.equals(this.buildEnd, that.buildEnd)) {
            return false;
        }
        if (!Objects.equals(this.buildStart, that.buildStart)) {
            return false;
        }
        if (!Objects.equals((Object)this.builderReference, (Object)that.builderReference)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.finalImagePullspec, that.finalImagePullspec)) {
            return false;
        }
        if (!Objects.equals(this.relatedObjects, that.relatedObjects)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.buildEnd, this.buildStart, this.builderReference, this.conditions, this.finalImagePullspec, this.relatedObjects, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.buildEnd != null) {
            sb.append("buildEnd:");
            sb.append(this.buildEnd + ",");
        }
        if (this.buildStart != null) {
            sb.append("buildStart:");
            sb.append(this.buildStart + ",");
        }
        if (this.builderReference != null) {
            sb.append("builderReference:");
            sb.append(this.builderReference + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.finalImagePullspec != null) {
            sb.append("finalImagePullspec:");
            sb.append(this.finalImagePullspec + ",");
        }
        if (this.relatedObjects != null && !this.relatedObjects.isEmpty()) {
            sb.append("relatedObjects:");
            sb.append(this.relatedObjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RelatedObjectsNested<N>
    extends ObjectReferenceFluent<RelatedObjectsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        RelatedObjectsNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)MachineOSBuildStatusFluent.this.setToRelatedObjects(this.index, this.builder.build());
        }

        public N endRelatedObject() {
            return this.and();
        }
    }

    public class BuilderReferenceNested<N>
    extends MachineOSBuilderReferenceFluent<BuilderReferenceNested<N>>
    implements Nested<N> {
        MachineOSBuilderReferenceBuilder builder;

        BuilderReferenceNested(MachineOSBuilderReference item) {
            this.builder = new MachineOSBuilderReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineOSBuildStatusFluent.this.withBuilderReference(this.builder.build());
        }

        public N endBuilderReference() {
            return this.and();
        }
    }
}

