/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.machine.v1.LoadBalancerReference;
import io.fabric8.openshift.api.model.machine.v1.LoadBalancerReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1.LoadBalancerReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1.PowerVSMachineProviderConfig;
import io.fabric8.openshift.api.model.machine.v1.PowerVSResource;
import io.fabric8.openshift.api.model.machine.v1.PowerVSResourceBuilder;
import io.fabric8.openshift.api.model.machine.v1.PowerVSResourceFluent;
import io.fabric8.openshift.api.model.machine.v1.PowerVSSecretReference;
import io.fabric8.openshift.api.model.machine.v1.PowerVSSecretReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1.PowerVSSecretReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PowerVSMachineProviderConfigFluent<A extends PowerVSMachineProviderConfigFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private PowerVSSecretReferenceBuilder credentialsSecret;
    private PowerVSResourceBuilder image;
    private String keyPairName;
    private String kind;
    private ArrayList<LoadBalancerReferenceBuilder> loadBalancers = new ArrayList();
    private Integer memoryGiB;
    private ObjectMetaBuilder metadata;
    private PowerVSResourceBuilder network;
    private String processorType;
    private IntOrStringBuilder processors;
    private PowerVSResourceBuilder serviceInstance;
    private String systemType;
    private PowerVSSecretReferenceBuilder userDataSecret;
    private Map<String, Object> additionalProperties;

    public PowerVSMachineProviderConfigFluent() {
    }

    public PowerVSMachineProviderConfigFluent(PowerVSMachineProviderConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PowerVSMachineProviderConfig instance) {
        PowerVSMachineProviderConfig powerVSMachineProviderConfig = instance = instance != null ? instance : new PowerVSMachineProviderConfig();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCredentialsSecret(instance.getCredentialsSecret());
            this.withImage(instance.getImage());
            this.withKeyPairName(instance.getKeyPairName());
            this.withKind(instance.getKind());
            this.withLoadBalancers(instance.getLoadBalancers());
            this.withMemoryGiB(instance.getMemoryGiB());
            this.withMetadata(instance.getMetadata());
            this.withNetwork(instance.getNetwork());
            this.withProcessorType(instance.getProcessorType());
            this.withProcessors(instance.getProcessors());
            this.withServiceInstance(instance.getServiceInstance());
            this.withSystemType(instance.getSystemType());
            this.withUserDataSecret(instance.getUserDataSecret());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public PowerVSSecretReference buildCredentialsSecret() {
        return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
    }

    public A withCredentialsSecret(PowerVSSecretReference credentialsSecret) {
        this._visitables.remove((Object)"credentialsSecret");
        if (credentialsSecret != null) {
            this.credentialsSecret = new PowerVSSecretReferenceBuilder(credentialsSecret);
            this._visitables.get((Object)"credentialsSecret").add(this.credentialsSecret);
        } else {
            this.credentialsSecret = null;
            this._visitables.get((Object)"credentialsSecret").remove((Object)this.credentialsSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsSecret() {
        return this.credentialsSecret != null;
    }

    public A withNewCredentialsSecret(String name) {
        return this.withCredentialsSecret(new PowerVSSecretReference(name));
    }

    public CredentialsSecretNested<A> withNewCredentialsSecret() {
        return new CredentialsSecretNested(null);
    }

    public CredentialsSecretNested<A> withNewCredentialsSecretLike(PowerVSSecretReference item) {
        return new CredentialsSecretNested(item);
    }

    public CredentialsSecretNested<A> editCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(null));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(new PowerVSSecretReferenceBuilder().build()));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(PowerVSSecretReference item) {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(item));
    }

    public PowerVSResource buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public A withImage(PowerVSResource image) {
        this._visitables.remove((Object)"image");
        if (image != null) {
            this.image = new PowerVSResourceBuilder(image);
            this._visitables.get((Object)"image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get((Object)"image").remove((Object)this.image);
        }
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String id, String name, String regex, String type) {
        return this.withImage(new PowerVSResource(id, name, regex, type));
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(PowerVSResource item) {
        return new ImageNested(item);
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new PowerVSResourceBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(PowerVSResource item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public String getKeyPairName() {
        return this.keyPairName;
    }

    public A withKeyPairName(String keyPairName) {
        this.keyPairName = keyPairName;
        return (A)((Object)this);
    }

    public boolean hasKeyPairName() {
        return this.keyPairName != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToLoadBalancers(int index, LoadBalancerReference item) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
        if (index < 0 || index >= this.loadBalancers.size()) {
            this._visitables.get((Object)"loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        } else {
            this._visitables.get((Object)"loadBalancers").add(builder);
            this.loadBalancers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToLoadBalancers(int index, LoadBalancerReference item) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
        if (index < 0 || index >= this.loadBalancers.size()) {
            this._visitables.get((Object)"loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        } else {
            this._visitables.get((Object)"loadBalancers").add(builder);
            this.loadBalancers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToLoadBalancers(LoadBalancerReference ... items) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get((Object)"loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLoadBalancers(Collection<LoadBalancerReference> items) {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList();
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get((Object)"loadBalancers").add(builder);
            this.loadBalancers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromLoadBalancers(LoadBalancerReference ... items) {
        if (this.loadBalancers == null) {
            return (A)((Object)this);
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get((Object)"loadBalancers").remove((Object)builder);
            this.loadBalancers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLoadBalancers(Collection<LoadBalancerReference> items) {
        if (this.loadBalancers == null) {
            return (A)((Object)this);
        }
        for (LoadBalancerReference item : items) {
            LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
            this._visitables.get((Object)"loadBalancers").remove((Object)builder);
            this.loadBalancers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLoadBalancers(Predicate<LoadBalancerReferenceBuilder> predicate) {
        if (this.loadBalancers == null) {
            return (A)((Object)this);
        }
        Iterator<LoadBalancerReferenceBuilder> each = this.loadBalancers.iterator();
        List visitables = this._visitables.get((Object)"loadBalancers");
        while (each.hasNext()) {
            LoadBalancerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<LoadBalancerReference> buildLoadBalancers() {
        return this.loadBalancers != null ? PowerVSMachineProviderConfigFluent.build(this.loadBalancers) : null;
    }

    public LoadBalancerReference buildLoadBalancer(int index) {
        return this.loadBalancers.get(index).build();
    }

    public LoadBalancerReference buildFirstLoadBalancer() {
        return this.loadBalancers.get(0).build();
    }

    public LoadBalancerReference buildLastLoadBalancer() {
        return this.loadBalancers.get(this.loadBalancers.size() - 1).build();
    }

    public LoadBalancerReference buildMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
        for (LoadBalancerReferenceBuilder item : this.loadBalancers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
        for (LoadBalancerReferenceBuilder item : this.loadBalancers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLoadBalancers(List<LoadBalancerReference> loadBalancers) {
        if (this.loadBalancers != null) {
            this._visitables.get((Object)"loadBalancers").clear();
        }
        if (loadBalancers != null) {
            this.loadBalancers = new ArrayList();
            for (LoadBalancerReference item : loadBalancers) {
                this.addToLoadBalancers(item);
            }
        } else {
            this.loadBalancers = null;
        }
        return (A)((Object)this);
    }

    public A withLoadBalancers(LoadBalancerReference ... loadBalancers) {
        if (this.loadBalancers != null) {
            this.loadBalancers.clear();
            this._visitables.remove((Object)"loadBalancers");
        }
        if (loadBalancers != null) {
            for (LoadBalancerReference item : loadBalancers) {
                this.addToLoadBalancers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLoadBalancers() {
        return this.loadBalancers != null && !this.loadBalancers.isEmpty();
    }

    public A addNewLoadBalancer(String name, String type) {
        return this.addToLoadBalancers(new LoadBalancerReference(name, type));
    }

    public LoadBalancersNested<A> addNewLoadBalancer() {
        return new LoadBalancersNested(-1, null);
    }

    public LoadBalancersNested<A> addNewLoadBalancerLike(LoadBalancerReference item) {
        return new LoadBalancersNested(-1, item);
    }

    public LoadBalancersNested<A> setNewLoadBalancerLike(int index, LoadBalancerReference item) {
        return new LoadBalancersNested(index, item);
    }

    public LoadBalancersNested<A> editLoadBalancer(int index) {
        if (this.loadBalancers.size() <= index) {
            throw new RuntimeException("Can't edit loadBalancers. Index exceeds size.");
        }
        return this.setNewLoadBalancerLike(index, this.buildLoadBalancer(index));
    }

    public LoadBalancersNested<A> editFirstLoadBalancer() {
        if (this.loadBalancers.size() == 0) {
            throw new RuntimeException("Can't edit first loadBalancers. The list is empty.");
        }
        return this.setNewLoadBalancerLike(0, this.buildLoadBalancer(0));
    }

    public LoadBalancersNested<A> editLastLoadBalancer() {
        int index = this.loadBalancers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last loadBalancers. The list is empty.");
        }
        return this.setNewLoadBalancerLike(index, this.buildLoadBalancer(index));
    }

    public LoadBalancersNested<A> editMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.loadBalancers.size(); ++i) {
            if (!predicate.test(this.loadBalancers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching loadBalancers. No match found.");
        }
        return this.setNewLoadBalancerLike(index, this.buildLoadBalancer(index));
    }

    public Integer getMemoryGiB() {
        return this.memoryGiB;
    }

    public A withMemoryGiB(Integer memoryGiB) {
        this.memoryGiB = memoryGiB;
        return (A)((Object)this);
    }

    public boolean hasMemoryGiB() {
        return this.memoryGiB != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public PowerVSResource buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    public A withNetwork(PowerVSResource network) {
        this._visitables.remove((Object)"network");
        if (network != null) {
            this.network = new PowerVSResourceBuilder(network);
            this._visitables.get((Object)"network").add(this.network);
        } else {
            this.network = null;
            this._visitables.get((Object)"network").remove((Object)this.network);
        }
        return (A)((Object)this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public A withNewNetwork(String id, String name, String regex, String type) {
        return this.withNetwork(new PowerVSResource(id, name, regex, type));
    }

    public NetworkNested<A> withNewNetwork() {
        return new NetworkNested(null);
    }

    public NetworkNested<A> withNewNetworkLike(PowerVSResource item) {
        return new NetworkNested(item);
    }

    public NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(null));
    }

    public NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(new PowerVSResourceBuilder().build()));
    }

    public NetworkNested<A> editOrNewNetworkLike(PowerVSResource item) {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(item));
    }

    public String getProcessorType() {
        return this.processorType;
    }

    public A withProcessorType(String processorType) {
        this.processorType = processorType;
        return (A)((Object)this);
    }

    public boolean hasProcessorType() {
        return this.processorType != null;
    }

    public IntOrString buildProcessors() {
        return this.processors != null ? this.processors.build() : null;
    }

    public A withProcessors(IntOrString processors) {
        this._visitables.remove((Object)"processors");
        if (processors != null) {
            this.processors = new IntOrStringBuilder(processors);
            this._visitables.get((Object)"processors").add(this.processors);
        } else {
            this.processors = null;
            this._visitables.get((Object)"processors").remove(this.processors);
        }
        return (A)((Object)this);
    }

    public boolean hasProcessors() {
        return this.processors != null;
    }

    public A withNewProcessors(Object value) {
        return this.withProcessors(new IntOrString(value));
    }

    public ProcessorsNested<A> withNewProcessors() {
        return new ProcessorsNested(null);
    }

    public ProcessorsNested<A> withNewProcessorsLike(IntOrString item) {
        return new ProcessorsNested(item);
    }

    public ProcessorsNested<A> editProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(null));
    }

    public ProcessorsNested<A> editOrNewProcessors() {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(new IntOrStringBuilder().build()));
    }

    public ProcessorsNested<A> editOrNewProcessorsLike(IntOrString item) {
        return this.withNewProcessorsLike(Optional.ofNullable(this.buildProcessors()).orElse(item));
    }

    public PowerVSResource buildServiceInstance() {
        return this.serviceInstance != null ? this.serviceInstance.build() : null;
    }

    public A withServiceInstance(PowerVSResource serviceInstance) {
        this._visitables.remove((Object)"serviceInstance");
        if (serviceInstance != null) {
            this.serviceInstance = new PowerVSResourceBuilder(serviceInstance);
            this._visitables.get((Object)"serviceInstance").add(this.serviceInstance);
        } else {
            this.serviceInstance = null;
            this._visitables.get((Object)"serviceInstance").remove((Object)this.serviceInstance);
        }
        return (A)((Object)this);
    }

    public boolean hasServiceInstance() {
        return this.serviceInstance != null;
    }

    public A withNewServiceInstance(String id, String name, String regex, String type) {
        return this.withServiceInstance(new PowerVSResource(id, name, regex, type));
    }

    public ServiceInstanceNested<A> withNewServiceInstance() {
        return new ServiceInstanceNested(null);
    }

    public ServiceInstanceNested<A> withNewServiceInstanceLike(PowerVSResource item) {
        return new ServiceInstanceNested(item);
    }

    public ServiceInstanceNested<A> editServiceInstance() {
        return this.withNewServiceInstanceLike(Optional.ofNullable(this.buildServiceInstance()).orElse(null));
    }

    public ServiceInstanceNested<A> editOrNewServiceInstance() {
        return this.withNewServiceInstanceLike(Optional.ofNullable(this.buildServiceInstance()).orElse(new PowerVSResourceBuilder().build()));
    }

    public ServiceInstanceNested<A> editOrNewServiceInstanceLike(PowerVSResource item) {
        return this.withNewServiceInstanceLike(Optional.ofNullable(this.buildServiceInstance()).orElse(item));
    }

    public String getSystemType() {
        return this.systemType;
    }

    public A withSystemType(String systemType) {
        this.systemType = systemType;
        return (A)((Object)this);
    }

    public boolean hasSystemType() {
        return this.systemType != null;
    }

    public PowerVSSecretReference buildUserDataSecret() {
        return this.userDataSecret != null ? this.userDataSecret.build() : null;
    }

    public A withUserDataSecret(PowerVSSecretReference userDataSecret) {
        this._visitables.remove((Object)"userDataSecret");
        if (userDataSecret != null) {
            this.userDataSecret = new PowerVSSecretReferenceBuilder(userDataSecret);
            this._visitables.get((Object)"userDataSecret").add(this.userDataSecret);
        } else {
            this.userDataSecret = null;
            this._visitables.get((Object)"userDataSecret").remove((Object)this.userDataSecret);
        }
        return (A)((Object)this);
    }

    public boolean hasUserDataSecret() {
        return this.userDataSecret != null;
    }

    public A withNewUserDataSecret(String name) {
        return this.withUserDataSecret(new PowerVSSecretReference(name));
    }

    public UserDataSecretNested<A> withNewUserDataSecret() {
        return new UserDataSecretNested(null);
    }

    public UserDataSecretNested<A> withNewUserDataSecretLike(PowerVSSecretReference item) {
        return new UserDataSecretNested(item);
    }

    public UserDataSecretNested<A> editUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(null));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(new PowerVSSecretReferenceBuilder().build()));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecretLike(PowerVSSecretReference item) {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PowerVSMachineProviderConfigFluent that = (PowerVSMachineProviderConfigFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.credentialsSecret, (Object)that.credentialsSecret)) {
            return false;
        }
        if (!Objects.equals((Object)this.image, (Object)that.image)) {
            return false;
        }
        if (!Objects.equals(this.keyPairName, that.keyPairName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.loadBalancers, that.loadBalancers)) {
            return false;
        }
        if (!Objects.equals(this.memoryGiB, that.memoryGiB)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals((Object)this.network, (Object)that.network)) {
            return false;
        }
        if (!Objects.equals(this.processorType, that.processorType)) {
            return false;
        }
        if (!Objects.equals(this.processors, that.processors)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceInstance, (Object)that.serviceInstance)) {
            return false;
        }
        if (!Objects.equals(this.systemType, that.systemType)) {
            return false;
        }
        if (!Objects.equals((Object)this.userDataSecret, (Object)that.userDataSecret)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.credentialsSecret, this.image, this.keyPairName, this.kind, this.loadBalancers, this.memoryGiB, this.metadata, this.network, this.processorType, this.processors, this.serviceInstance, this.systemType, this.userDataSecret, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.credentialsSecret != null) {
            sb.append("credentialsSecret:");
            sb.append(String.valueOf((Object)this.credentialsSecret) + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(String.valueOf((Object)this.image) + ",");
        }
        if (this.keyPairName != null) {
            sb.append("keyPairName:");
            sb.append(this.keyPairName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.loadBalancers != null && !this.loadBalancers.isEmpty()) {
            sb.append("loadBalancers:");
            sb.append(String.valueOf(this.loadBalancers) + ",");
        }
        if (this.memoryGiB != null) {
            sb.append("memoryGiB:");
            sb.append(this.memoryGiB + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(String.valueOf((Object)this.network) + ",");
        }
        if (this.processorType != null) {
            sb.append("processorType:");
            sb.append(this.processorType + ",");
        }
        if (this.processors != null) {
            sb.append("processors:");
            sb.append(String.valueOf(this.processors) + ",");
        }
        if (this.serviceInstance != null) {
            sb.append("serviceInstance:");
            sb.append(String.valueOf((Object)this.serviceInstance) + ",");
        }
        if (this.systemType != null) {
            sb.append("systemType:");
            sb.append(this.systemType + ",");
        }
        if (this.userDataSecret != null) {
            sb.append("userDataSecret:");
            sb.append(String.valueOf((Object)this.userDataSecret) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserDataSecretNested<N>
    extends PowerVSSecretReferenceFluent<UserDataSecretNested<N>>
    implements Nested<N> {
        PowerVSSecretReferenceBuilder builder;

        UserDataSecretNested(PowerVSSecretReference item) {
            this.builder = new PowerVSSecretReferenceBuilder(this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withUserDataSecret(this.builder.build());
        }

        public N endUserDataSecret() {
            return this.and();
        }
    }

    public class ServiceInstanceNested<N>
    extends PowerVSResourceFluent<ServiceInstanceNested<N>>
    implements Nested<N> {
        PowerVSResourceBuilder builder;

        ServiceInstanceNested(PowerVSResource item) {
            this.builder = new PowerVSResourceBuilder(this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withServiceInstance(this.builder.build());
        }

        public N endServiceInstance() {
            return this.and();
        }
    }

    public class ProcessorsNested<N>
    extends IntOrStringFluent<ProcessorsNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        ProcessorsNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withProcessors(this.builder.build());
        }

        public N endProcessors() {
            return this.and();
        }
    }

    public class NetworkNested<N>
    extends PowerVSResourceFluent<NetworkNested<N>>
    implements Nested<N> {
        PowerVSResourceBuilder builder;

        NetworkNested(PowerVSResource item) {
            this.builder = new PowerVSResourceBuilder(this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withNetwork(this.builder.build());
        }

        public N endNetwork() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class LoadBalancersNested<N>
    extends LoadBalancerReferenceFluent<LoadBalancersNested<N>>
    implements Nested<N> {
        LoadBalancerReferenceBuilder builder;
        int index;

        LoadBalancersNested(int index, LoadBalancerReference item) {
            this.index = index;
            this.builder = new LoadBalancerReferenceBuilder(this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.setToLoadBalancers(this.index, this.builder.build());
        }

        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class ImageNested<N>
    extends PowerVSResourceFluent<ImageNested<N>>
    implements Nested<N> {
        PowerVSResourceBuilder builder;

        ImageNested(PowerVSResource item) {
            this.builder = new PowerVSResourceBuilder(this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }

    public class CredentialsSecretNested<N>
    extends PowerVSSecretReferenceFluent<CredentialsSecretNested<N>>
    implements Nested<N> {
        PowerVSSecretReferenceBuilder builder;

        CredentialsSecretNested(PowerVSSecretReference item) {
            this.builder = new PowerVSSecretReferenceBuilder(this, item);
        }

        public N and() {
            return (N)PowerVSMachineProviderConfigFluent.this.withCredentialsSecret(this.builder.build());
        }

        public N endCredentialsSecret() {
            return this.and();
        }
    }
}

