/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.Triggerable;
import io.fabric8.kubernetes.client.dsl.Typeable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.DoneableBuildConfig;
import io.fabric8.openshift.api.model.WebHookTrigger;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.BuildConfigOperation;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import io.fabric8.openshift.client.dsl.BuildResource;
import io.fabric8.openshift.client.dsl.InputStreamable;
import io.fabric8.openshift.client.dsl.TimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.AsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.AuthorEmailable;
import io.fabric8.openshift.client.dsl.buildconfig.AuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.CommitterAuthorMessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.buildconfig.CommitterEmailable;
import io.fabric8.openshift.client.dsl.buildconfig.MessageAsFileTimeoutInputStreamable;
import io.fabric8.openshift.client.dsl.internal.BuildConfigOperationContext;
import io.fabric8.openshift.client.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class BuildConfigOperationsImpl
extends OpenShiftOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>>
implements BuildConfigOperation {
    public static final String BUILD_CONFIG_LABEL = "openshift.io/build-config.name";
    public static final String BUILD_CONFIG_ANNOTATION = "openshift.io/build-config.name";
    private final String secret;
    private final String triggerType;
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;
    private final String commit;
    private final String message;
    private final String asFile;
    private final long timeout;
    private final TimeUnit timeoutUnit;

    public BuildConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
        this(new BuildConfigOperationContext().withOkhttpClient(client).withConfig(config));
    }

    public BuildConfigOperationsImpl(BuildConfigOperationContext context) {
        super(context.withApiGroupName("build.openshift.io").withPlural("buildconfigs"));
        this.type = BuildConfig.class;
        this.listType = BuildConfigList.class;
        this.doneableType = DoneableBuildConfig.class;
        this.triggerType = context.getTriggerType();
        this.secret = context.getSecret();
        this.authorName = context.getAuthorName();
        this.authorEmail = context.getAuthorEmail();
        this.committerName = context.getCommitterName();
        this.committerEmail = context.getCommitterEmail();
        this.commit = context.getCommit();
        this.message = context.getMessage();
        this.asFile = context.getAsFile();
        this.timeout = context.getTimeout();
        this.timeoutUnit = context.getTimeoutUnit();
        this.reaper = new BuildConfigReaper(this);
    }

    public BuildConfigOperationsImpl newInstance(OperationContext context) {
        return new BuildConfigOperationsImpl((BuildConfigOperationContext)context);
    }

    public BuildConfigOperationContext getContext() {
        return (BuildConfigOperationContext)this.context;
    }

    @Override
    public Build instantiate(BuildRequest request) {
        try {
            this.updateApiVersion((HasMetadata)request);
            URL instantiationUrl = new URL(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiate"}));
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)BaseOperation.JSON_MAPPER.writer().writeValueAsString((Object)request));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(instantiationUrl);
            return (Build)this.handleResponse(requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    @Override
    public CommitterAuthorMessageAsFileTimeoutInputStreamable<Build> instantiateBinary() {
        return new BuildConfigOperationsImpl(this.getContext());
    }

    public Void trigger(WebHookTrigger trigger) {
        try {
            String triggerUrl = URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "webhooks", this.secret, this.triggerType});
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (byte[])BaseOperation.JSON_MAPPER.writer().writeValueAsBytes((Object)trigger));
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(triggerUrl).addHeader("X-Github-Event", "push");
            this.handleResponse(requestBuilder, null);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return null;
    }

    public Triggerable<WebHookTrigger, Void> withType(String triggerType) {
        return new BuildConfigOperationsImpl(this.getContext().withTriggerType(triggerType));
    }

    public Watchable<Watch, Watcher<BuildConfig>> withResourceVersion(String resourceVersion) {
        return new BuildConfigOperationsImpl(this.getContext().withResourceVersion(resourceVersion));
    }

    private void deleteBuilds() {
        if (this.getName() == null) {
            return;
        }
        String buildConfigLabelValue = this.getName().substring(0, Math.min(this.getName().length(), 63));
        BuildList matchingBuilds = (BuildList)((FilterWatchListDeletable)new BuildOperationsImpl(this.client, (OpenShiftConfig)this.config).inNamespace(this.namespace).withLabel("openshift.io/build-config.name", buildConfigLabelValue)).list();
        if (matchingBuilds.getItems() != null) {
            for (Build matchingBuild : matchingBuilds.getItems()) {
                if (matchingBuild.getMetadata() == null || matchingBuild.getMetadata().getAnnotations() == null || !this.getName().equals(matchingBuild.getMetadata().getAnnotations().get("openshift.io/build-config.name"))) continue;
                ((BuildResource)new BuildOperationsImpl(this.client, (OpenShiftConfig)this.config).inNamespace(matchingBuild.getMetadata().getNamespace()).withName(matchingBuild.getMetadata().getName())).delete();
            }
        }
    }

    @Override
    public Build fromInputStream(InputStream inputStream) {
        return this.fromInputStream(inputStream, -1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Build fromFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Can't instantiate binary build from the specified file. The file does not exists");
        }
        try (FileInputStream is = new FileInputStream(file);){
            Build build = this.fromInputStream(is, file.length());
            return build;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable((Throwable)t);
        }
    }

    private Build fromInputStream(final InputStream inputStream, final long contentLength) {
        try {
            RequestBody requestBody = new RequestBody(){

                public MediaType contentType() {
                    return MediaType.parse((String)"application/octet-stream");
                }

                public long contentLength() throws IOException {
                    return contentLength;
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    Source source = null;
                    try {
                        source = Okio.source((InputStream)inputStream);
                        OutputStream os = sink.outputStream();
                        sink.writeAll(source);
                    }
                    catch (IOException e) {
                        throw KubernetesClientException.launderThrowable((String)"Can't instantiate binary build, due to error reading/writing stream. Can be caused if the output stream was closed by the server.", (Throwable)e);
                    }
                }
            };
            OkHttpClient newClient = this.client.newBuilder().readTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).build();
            Request.Builder requestBuilder = new Request.Builder().post(requestBody).header("Expect", "100-continue").url(this.getQueryParameters());
            return (Build)this.handleResponse(newClient, requestBuilder, Build.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private String getQueryParameters() throws MalformedURLException {
        StringBuilder sb = new StringBuilder();
        sb.append(URLUtils.join((String[])new String[]{this.getResourceUrl().toString(), "instantiatebinary"}));
        if (Utils.isNullOrEmpty((String)this.message)) {
            sb.append("?commit=");
        } else {
            sb.append("?commit=").append(this.message);
        }
        if (!Utils.isNullOrEmpty((String)this.authorName)) {
            sb.append("&revision.authorName=").append(this.authorName);
        }
        if (!Utils.isNullOrEmpty((String)this.authorEmail)) {
            sb.append("&revision.authorEmail=").append(this.authorEmail);
        }
        if (!Utils.isNullOrEmpty((String)this.committerName)) {
            sb.append("&revision.committerName=").append(this.committerName);
        }
        if (!Utils.isNullOrEmpty((String)this.committerEmail)) {
            sb.append("&revision.committerEmail=").append(this.committerEmail);
        }
        if (!Utils.isNullOrEmpty((String)this.commit)) {
            sb.append("&revision.commit=").append(this.commit);
        }
        if (!Utils.isNullOrEmpty((String)this.asFile)) {
            sb.append("&asFile=").append(this.asFile);
        }
        return sb.toString();
    }

    @Override
    public TimeoutInputStreamable<Build> asFile(String fileName) {
        return new BuildConfigOperationsImpl(this.getContext().withAsFile(fileName));
    }

    @Override
    public MessageAsFileTimeoutInputStreamable<Build> withAuthorEmail(String email) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorEmail(email));
    }

    @Override
    public AuthorMessageAsFileTimeoutInputStreamable<Build> withCommitterEmail(String committerEmail) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterEmail(committerEmail));
    }

    @Override
    public AsFileTimeoutInputStreamable<Build> withMessage(String message) {
        return new BuildConfigOperationsImpl(this.getContext().withMessage(message));
    }

    @Override
    public AuthorEmailable<MessageAsFileTimeoutInputStreamable<Build>> withAuthorName(String authorName) {
        return new BuildConfigOperationsImpl(this.getContext().withAuthorName(authorName));
    }

    @Override
    public CommitterEmailable<AuthorMessageAsFileTimeoutInputStreamable<Build>> withCommitterName(String committerName) {
        return new BuildConfigOperationsImpl(this.getContext().withCommitterName(committerName));
    }

    public InputStreamable<Build> withTimeout(long timeout, TimeUnit unit) {
        return new BuildConfigOperationsImpl(this.getContext().withTimeout(timeout).withTimeoutUnit(unit));
    }

    public InputStreamable<Build> withTimeoutInMillis(long timeoutInMillis) {
        return this.withTimeout(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public Typeable<Triggerable<WebHookTrigger, Void>> withSecret(String secret) {
        return new BuildConfigOperationsImpl(this.getContext().withSecret(secret));
    }

    private static class BuildConfigReaper
    implements Reaper {
        private BuildConfigOperationsImpl oper;

        public BuildConfigReaper(BuildConfigOperationsImpl oper) {
            this.oper = oper;
        }

        public boolean reap() {
            this.oper.deleteBuilds();
            return false;
        }
    }
}

