/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.NetNamespace;
import io.fabric8.openshift.api.model.NetNamespaceBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.NetNamespaceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NetNamespaceHandler
implements ResourceHandler<NetNamespace, NetNamespaceBuilder> {
    public String getKind() {
        return NetNamespace.class.getSimpleName();
    }

    public String getApiVersion() {
        return "${apiGroup}/${apiVersion}";
    }

    public NetNamespace create(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create((Object[])new NetNamespace[0]);
    }

    public NetNamespace replace(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public NetNamespace reload(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)((Gettable)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public NetNamespaceBuilder edit(NetNamespace item) {
        return new NetNamespaceBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (Boolean)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete((Object[])new NetNamespace[]{item});
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, Watcher<NetNamespace> watcher) {
        return (Watch)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, String resourceVersion, Watcher<NetNamespace> watcher) {
        return (Watch)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public NetNamespace waitUntilReady(OkHttpClient client, Config config, String namespace, NetNamespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public NetNamespace waitUntilCondition(OkHttpClient client, Config config, String namespace, NetNamespace item, Predicate<NetNamespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

