/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator.schema;

import io.fabric8.kubernetes.schema.generator.GeneratorSettings;
import io.fabric8.kubernetes.schema.generator.ImportManager;
import io.fabric8.kubernetes.schema.generator.PropertyOrderComparator;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class SchemaUtils {
    public static final String APPLICATION_JSON = "application/json";
    private static final String OBJECT_PRIMITIVE = "Object";
    private static final String STRING_PRIMITIVE = "String";
    private static final Map<String, String> REF_TO_JAVA_TYPE_MAP = new LinkedHashMap<String, String>();
    private static final Map<String, String> REF_TO_JAVA_PRIMITIVE_MAP;
    private static final Map<String, String> JAVA_CLASS_SERIALIZER_MAP;
    private static final Map<String, String> JAVA_CLASS_DESERIALIZER_MAP;
    private static final Map<String, String> REF_SERIALIZER_MAP;
    private static final Map<String, String> TYPE_DESERIALIZER_MAP;
    private static final Map<String, String> TYPE_MAP;
    private static final Set<String> PROTECTED_WORDS;
    private static final Map<String, String> MAPPED_WORDS;
    private final GeneratorSettings settings;

    public SchemaUtils(GeneratorSettings settings) {
        this.settings = settings;
    }

    public String refToClassName(String ref) {
        String cleanRef = ref.replaceAll("^#/((components/schemas)|(definitions))/", "");
        if (this.settings.getRefToClassNameMappings().containsKey(cleanRef)) {
            return this.settings.getRefToClassNameMappings().getProperty(cleanRef);
        }
        return SchemaUtils.capitalize(ref.substring(ref.lastIndexOf(46) + 1)).replace("_", "");
    }

    public String refToModelPackage(String ref) {
        String packageName = ref.substring(ref.lastIndexOf(47) + 1, ref.lastIndexOf(46));
        return this.toModelPackage(packageName).concat(".").concat(this.refToClassName(ref));
    }

    public String toModelPackage(String packageName) {
        for (String mapping : this.settings.getPackageMappings().keySet()) {
            if (!packageName.startsWith(mapping + ".") && !packageName.equals(mapping)) continue;
            packageName = packageName.replaceAll("^" + mapping, this.settings.getPackageMappings().get(mapping));
            break;
        }
        return SchemaUtils.sanitizePackageName(packageName);
    }

    public String schemaToClassName(ImportManager imports, Schema<?> schema) {
        if (SchemaUtils.isArray(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            imports.addImport("java.util.List");
            return String.format("List<%s>", this.schemaToClassName(imports, arraySchema.getItems()));
        }
        if (SchemaUtils.isMap(schema)) {
            imports.addImport("java.util.Map");
            imports.addImport("java.util.LinkedHashMap");
            String valueType = schema.getAdditionalProperties() instanceof Schema ? this.schemaToClassName(imports, (Schema)schema.getAdditionalProperties()) : OBJECT_PRIMITIVE;
            return String.format("Map<String, %s>", valueType);
        }
        if (this.isDateTime(schema)) {
            return STRING_PRIMITIVE;
        }
        if (this.isString(schema)) {
            return STRING_PRIMITIVE;
        }
        if (SchemaUtils.isRef(schema)) {
            String ref = schema.get$ref();
            Optional<String> javaPrimitive = SchemaUtils.schemaRefToJavaPrimitive(schema);
            if (javaPrimitive.isPresent()) {
                return javaPrimitive.get();
            }
            String javaType = this.schemaRefToJavaType(schema);
            if (javaType != null) {
                imports.addImport(javaType);
                return javaType.substring(javaType.lastIndexOf(46) + 1);
            }
            if (imports.hasSimpleClassName(this.refToModelPackage(ref))) {
                return this.refToModelPackage(ref);
            }
            imports.addImport(this.refToModelPackage(ref));
            return this.refToClassName(ref);
        }
        if (SchemaUtils.isObject(schema)) {
            return OBJECT_PRIMITIVE;
        }
        return SchemaUtils.schemaTypeToJavaPrimitive(schema);
    }

    public static String classType(Schema<?> schema) {
        if (SchemaUtils.hasExtensionStringValue(schema, "x-kubernetes-fabric8-type")) {
            return schema.getExtensions().get("x-kubernetes-fabric8-type").toString();
        }
        return "class";
    }

    public static boolean isEnum(Schema<?> schema) {
        return Objects.equals(SchemaUtils.classType(schema), "enum");
    }

    public static Collection<String> enumValues(Schema<?> schema) {
        if (SchemaUtils.isEnum(schema) && SchemaUtils.hasExtensionStringValue(schema, "x-kubernetes-fabric8-enum-values")) {
            return Stream.of(schema.getExtensions().get("x-kubernetes-fabric8-enum-values").toString().split(",")).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean isInterface(Schema<?> schema) {
        return Objects.equals(SchemaUtils.classType(schema), "interface");
    }

    public static boolean hasInterfaceFields(Schema<?> schema) {
        return SchemaUtils.hasExtensionStringValue(schema, "x-kubernetes-fabric8-interface-fields");
    }

    public static Set<String> interfaceFields(Schema<?> schema) {
        if (SchemaUtils.hasInterfaceFields(schema)) {
            return Set.of(schema.getExtensions().get("x-kubernetes-fabric8-interface-fields").toString().split(","));
        }
        return Collections.emptySet();
    }

    public List<String> interfaceImplementation(Schema<?> schema) {
        if (SchemaUtils.hasExtensionStringValue(schema, "x-kubernetes-fabric8-implementation")) {
            return Stream.of(schema.getExtensions().get("x-kubernetes-fabric8-implementation").toString().split(",")).map(this::refToClassName).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public String interfaceImplemented(Schema<?> schema) {
        if (SchemaUtils.hasExtensionStringValue(schema, "x-kubernetes-fabric8-implements")) {
            return this.refToClassName(schema.getExtensions().get("x-kubernetes-fabric8-implements").toString());
        }
        return null;
    }

    public static boolean isArray(Schema<?> schema) {
        return schema instanceof ArraySchema;
    }

    public boolean isDateTime(Schema<?> schema) {
        if (schema.get$ref() != null && Objects.equals(this.refToClassName(schema.get$ref()), "MicroTime")) {
            return false;
        }
        return schema instanceof DateTimeSchema || this.isRefInstanceOf(schema.get$ref(), DateTimeSchema.class);
    }

    public boolean isHasMetadata(Schema<?> schema) {
        return schema != null && schema.getProperties() != null && schema.getProperties().containsKey("metadata") && Objects.equals(this.settings.getObjectMetaClass(), this.schemaRefToJavaType((Schema)schema.getProperties().get("metadata")));
    }

    public static boolean isMap(Schema<?> schema) {
        if (schema != null && schema.getAdditionalProperties() instanceof Schema) {
            return true;
        }
        if (schema != null && schema.getAdditionalProperties() instanceof Boolean && ((Boolean)schema.getAdditionalProperties()).booleanValue()) {
            return true;
        }
        return schema instanceof MapSchema;
    }

    public static boolean isRef(Schema<?> schema) {
        return schema != null && schema.get$ref() != null && !schema.get$ref().trim().isEmpty();
    }

    public static boolean isObject(Schema<?> schema) {
        return schema != null && Objects.equals("object", schema.getType());
    }

    public boolean isString(Schema<?> schema) {
        String ref = schema.get$ref();
        if (ref != null && (REF_TO_JAVA_PRIMITIVE_MAP.containsKey(ref) || this.schemaRefToJavaType(schema) != null)) {
            return false;
        }
        return schema instanceof StringSchema || this.isRefInstanceOf(ref, StringSchema.class);
    }

    public boolean isRefInstanceOf(String ref, Class<?> clazz) {
        if (ref == null) {
            return false;
        }
        return this.settings.getOpenAPI().getComponents().getSchemas().entrySet().stream().filter(entry -> clazz.isInstance(entry.getValue())).anyMatch(entry -> ref.endsWith((String)entry.getKey()));
    }

    public String kubernetesListType(ImportManager imports, Schema<?> schema) {
        if (!SchemaUtils.isObject(schema)) {
            return null;
        }
        return Optional.ofNullable(schema.getProperties()).map(p -> (Schema)p.get("items")).filter(s -> s instanceof ArraySchema).map(s -> (ArraySchema)s).map(as -> this.schemaToClassName(imports, as.getItems())).orElse(null);
    }

    private static Optional<String> schemaRefToJavaPrimitive(Schema<?> schema) {
        return Optional.ofNullable(REF_TO_JAVA_PRIMITIVE_MAP.get(schema.get$ref()));
    }

    private String schemaRefToJavaType(Schema<?> schema) {
        if (this.settings.getRefToJavaTypeMappings().containsKey(schema.get$ref())) {
            return this.settings.getRefToJavaTypeMappings().getProperty(schema.get$ref());
        }
        return REF_TO_JAVA_TYPE_MAP.get(schema.get$ref());
    }

    private static String schemaTypeToJavaPrimitive(Schema<?> schema) {
        return Optional.ofNullable(schema.getType()).map(type -> type.equals("integer") && schema.getFormat() != null ? schema.getFormat() : type).map(type -> type.equals("number") && schema.getFormat() != null ? schema.getFormat() : type).map(TYPE_MAP::get).orElse(schema.getType());
    }

    public static String sanitizePackageName(String packageName) {
        return packageName.replace("-", "").toLowerCase();
    }

    public static String sanitizeDescription(String description) {
        return Optional.ofNullable(description).orElse("").replace("&", "&amp;").replace("*", "&#42;").replace("<", "&lt;").replace(">", "&gt;").replace('\u201c', '\"').replace('\u201d', '\"').replace("\n", "<br><p> ");
    }

    public static String removeDashes(String variable) {
        return SchemaUtils.removeSeparator("-", variable);
    }

    public static String removeUnderscores(String variable) {
        return SchemaUtils.removeSeparator("_", variable);
    }

    public static String removeSeparator(String separator, String variable) {
        StringBuilder sanitized = new StringBuilder();
        for (String part : variable.split(separator)) {
            if (sanitized.length() == 0) {
                sanitized.append(part);
                continue;
            }
            sanitized.append(SchemaUtils.capitalize(part));
        }
        return sanitized.toString();
    }

    public String sanitizeFieldName(String fieldName) {
        String sanitized = SchemaUtils.uncapitalize(SchemaUtils.removeUnderscores(SchemaUtils.removeDashes(fieldName)));
        String mapped = MAPPED_WORDS.getOrDefault(sanitized, sanitized);
        String userMapped = this.settings.getFieldNameMappings().getOrDefault(mapped, mapped);
        return PROTECTED_WORDS.contains(userMapped) ? "_" + userMapped : userMapped;
    }

    public static String getterName(String variable) {
        String property = SchemaUtils.removeUnderscores(SchemaUtils.removeDashes(variable));
        String mapped = MAPPED_WORDS.getOrDefault(property, property);
        return "get".concat(SchemaUtils.capitalize(mapped));
    }

    public static String setterName(String variable) {
        String property = SchemaUtils.removeUnderscores(SchemaUtils.removeDashes(variable));
        String mapped = MAPPED_WORDS.getOrDefault(property, property);
        return "set".concat(SchemaUtils.capitalize(mapped));
    }

    public Map<String, Schema<?>> extractComponentSchemas() {
        return this.settings.getOpenAPI().getComponents().getSchemas().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> (Schema)v.getValue()));
    }

    public static String serializerForSchema(Schema<?> schema) {
        return Optional.ofNullable(schema).map(Schema::get$ref).map(REF_SERIALIZER_MAP::get).orElse(null);
    }

    public static String deserializerForType(String type) {
        if (TYPE_DESERIALIZER_MAP.containsKey(type)) {
            return TYPE_DESERIALIZER_MAP.get(type);
        }
        return null;
    }

    public static String serializerForJavaClass(String java) {
        return JAVA_CLASS_SERIALIZER_MAP.get(java);
    }

    public static String deserializerForJavaClass(String java) {
        return JAVA_CLASS_DESERIALIZER_MAP.get(java);
    }

    public static Map<String, Object> propertyOrder(Schema<?> schema) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (schema != null && schema.getProperties() != null) {
            ret.put("isEmpty", false);
            ret.put("properties", schema.getProperties().keySet().stream().sorted(new PropertyOrderComparator<String>(Arrays.asList("apiVersion", "kind", "metadata"))).collect(Collectors.toList()));
        } else {
            ret.put("isEmpty", true);
        }
        return ret;
    }

    public static OpenAPI mergeSchemas(Collection<OpenAPI> schemas) {
        OpenAPI openAPI = new OpenAPI(SpecVersion.V31);
        openAPI.setComponents(new Components());
        openAPI.getComponents().setSchemas(new HashMap());
        openAPI.getComponents().setResponses(new HashMap());
        openAPI.getComponents().setParameters(new HashMap());
        openAPI.getComponents().setExamples(new HashMap());
        openAPI.getComponents().setRequestBodies(new HashMap());
        openAPI.getComponents().setHeaders(new HashMap());
        openAPI.getComponents().setSecuritySchemes(new HashMap());
        openAPI.getComponents().setLinks(new HashMap());
        openAPI.getComponents().setCallbacks(new HashMap());
        openAPI.getComponents().setExtensions(new HashMap());
        openAPI.setPaths(new Paths());
        int apiCounter = 0;
        for (OpenAPI currentApi : schemas) {
            ++apiCounter;
            for (Map.Entry paths : currentApi.getPaths().entrySet()) {
                if (openAPI.getPaths().containsKey(paths.getKey())) {
                    openAPI.getPaths().addPathItem((String)paths.getKey() + "/" + apiCounter, (PathItem)paths.getValue());
                    continue;
                }
                openAPI.getPaths().addPathItem((String)paths.getKey(), (PathItem)paths.getValue());
            }
            if (currentApi.getComponents() == null) continue;
            Optional.ofNullable(currentApi.getComponents().getSchemas()).ifPresent(openAPI.getComponents().getSchemas()::putAll);
            Optional.ofNullable(currentApi.getComponents().getResponses()).ifPresent(openAPI.getComponents().getResponses()::putAll);
            Optional.ofNullable(currentApi.getComponents().getParameters()).ifPresent(openAPI.getComponents().getParameters()::putAll);
            Optional.ofNullable(currentApi.getComponents().getExamples()).ifPresent(openAPI.getComponents().getExamples()::putAll);
            Optional.ofNullable(currentApi.getComponents().getRequestBodies()).ifPresent(openAPI.getComponents().getRequestBodies()::putAll);
            Optional.ofNullable(currentApi.getComponents().getHeaders()).ifPresent(openAPI.getComponents().getHeaders()::putAll);
        }
        return openAPI;
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toLowerCase(Locale.ROOT) + string.substring(1);
    }

    private static boolean hasExtensionStringValue(Schema<?> schema, String key) {
        return schema.getExtensions() != null && schema.getExtensions().containsKey(key) && schema.getExtensions().get(key) instanceof String && !schema.getExtensions().get(key).toString().isEmpty();
    }

    @Generated
    public GeneratorSettings getSettings() {
        return this.settings;
    }

    static {
        REF_TO_JAVA_TYPE_MAP.put("#/components/schemas/io.k8s.apimachinery.pkg.util.intstr.IntOrString", "io.fabric8.kubernetes.api.model.IntOrString");
        REF_TO_JAVA_TYPE_MAP.put("#/components/schemas/io.k8s.apimachinery.pkg.api.resource.Quantity", "io.fabric8.kubernetes.api.model.Quantity");
        REF_TO_JAVA_TYPE_MAP.put("#/components/schemas/io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta", "io.fabric8.kubernetes.api.model.ObjectMeta");
        REF_TO_JAVA_TYPE_MAP.put("#/components/schemas/io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta_v2", "io.fabric8.kubernetes.api.model.ObjectMeta");
        REF_TO_JAVA_TYPE_MAP.put("#/components/schemas/io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1beta1.JSON", "com.fasterxml.jackson.databind.JsonNode");
        REF_TO_JAVA_TYPE_MAP.put("#/components/schemas/io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.JSON", "com.fasterxml.jackson.databind.JsonNode");
        REF_TO_JAVA_PRIMITIVE_MAP = new LinkedHashMap<String, String>();
        REF_TO_JAVA_PRIMITIVE_MAP.put("#/components/schemas/io.k8s.apimachinery.pkg.apis.meta.v1.Time", STRING_PRIMITIVE);
        REF_TO_JAVA_PRIMITIVE_MAP.put("#/components/schemas/io.k8s.apimachinery.pkg.runtime.RawExtension", OBJECT_PRIMITIVE);
        REF_TO_JAVA_PRIMITIVE_MAP.put("#/components/schemas/com.github.operator-framework.api.pkg.lib.version.OperatorVersion", STRING_PRIMITIVE);
        REF_TO_JAVA_PRIMITIVE_MAP.put("#/components/schemas/dev.knative.pkg.apis.URL", STRING_PRIMITIVE);
        JAVA_CLASS_SERIALIZER_MAP = new LinkedHashMap<String, String>();
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.MicroTime", "io.fabric8.kubernetes.api.model.MicroTimeSerDes.Serializer.class");
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArray", "io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArraySerDe.Serializer.class");
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArraySerDe.Serializer.class");
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrBool", "io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrBoolSerDe.Serializer.class");
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolSerDe.Serializer.class");
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray", "io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArraySerDe.Serializer.class");
        JAVA_CLASS_SERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArraySerDe.Serializer.class");
        JAVA_CLASS_DESERIALIZER_MAP = new LinkedHashMap<String, String>();
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.MicroTime", "io.fabric8.kubernetes.api.model.MicroTimeSerDes.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArray", "io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArraySerDe.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArray", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrArraySerDe.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrBool", "io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrBoolSerDe.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBool", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrBoolSerDe.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArray", "io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrStringArraySerDe.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArray", "io.fabric8.kubernetes.api.model.apiextensions.v1beta1.JSONSchemaPropsOrStringArraySerDe.Deserializer.class");
        JAVA_CLASS_DESERIALIZER_MAP.put("io.fabric8.openshift.api.model.Template", "io.fabric8.openshift.api.model.TemplateDeserializer.class");
        REF_SERIALIZER_MAP = Collections.emptyMap();
        TYPE_DESERIALIZER_MAP = new LinkedHashMap<String, String>();
        TYPE_DESERIALIZER_MAP.put(OBJECT_PRIMITIVE, "io.fabric8.kubernetes.internal.KubernetesDeserializer.class");
        TYPE_DESERIALIZER_MAP.put("List<Object>", "io.fabric8.kubernetes.internal.KubernetesDeserializerForList.class");
        TYPE_DESERIALIZER_MAP.put("Map<String, Object>", "io.fabric8.kubernetes.internal.KubernetesDeserializerForMap.class");
        TYPE_MAP = new LinkedHashMap<String, String>();
        TYPE_MAP.put("boolean", "Boolean");
        TYPE_MAP.put("byte", "Integer");
        TYPE_MAP.put("int32", "Integer");
        TYPE_MAP.put("integer", "Integer");
        TYPE_MAP.put("int64", "Long");
        TYPE_MAP.put("float", "Float");
        TYPE_MAP.put("double", "Double");
        TYPE_MAP.put("number", "Number");
        TYPE_MAP.put("object", OBJECT_PRIMITIVE);
        TYPE_MAP.put("string", STRING_PRIMITIVE);
        PROTECTED_WORDS = new HashSet<String>(Arrays.asList("abstract", "class", "continue", "default", "enum", "finally", "for", "import", "int", "interface", "package", "private", "public", "return", "short", "static"));
        MAPPED_WORDS = new LinkedHashMap<String, String>();
        MAPPED_WORDS.put("class", "className");
    }
}

