/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator;

import io.fabric8.kubernetes.schema.generator.ApiVersion;
import io.fabric8.kubernetes.schema.generator.GeneratorUtils;
import io.fabric8.kubernetes.schema.generator.schema.SchemaUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;

public class GeneratorSettings {
    private Logger logger;
    private List<File> schemas;
    private List<String> urls;
    private OpenAPI openAPI;
    private Map<String, ApiVersion> apiVersions;
    private File outputDirectory;
    private File generatedSourcesDirectory;
    private File overridesDirectory;
    private String packageName;
    private String builderPackage;
    private boolean addBuildableReferences;
    private Map<String, String> packageMappings;
    private final AtomicBoolean packageMappingsProcessed = new AtomicBoolean(false);
    private Properties refToClassNameMappings;
    private Properties refToJavaTypeMappings;
    private Map<String, String> fieldNameMappings;
    private Set<String> skipGenerationRegexes;
    private Set<String> includeGenerationRegexes;
    private boolean generateJavadoc;
    private final String genericKubernetesResourceClass;
    private final String hasMetadataClass;
    private final String kubernetesResourceClass;
    private final String kubernetesResourceListClass;
    private final String objectMetaClass;
    private final String namespacedClass;
    private final String rawExtensionClass;
    private final List<String> buildableReferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenAPI getOpenAPI() {
        GeneratorSettings generatorSettings = this;
        synchronized (generatorSettings) {
            if (this.openAPI == null) {
                ArrayList<OpenAPI> openApis = new ArrayList<OpenAPI>();
                this.schemas.stream().map(GeneratorUtils::parse).forEach(openApis::add);
                this.urls.stream().map(URI::create).map(GeneratorUtils::parse).forEach(openApis::add);
                this.openAPI = SchemaUtils.mergeSchemas(openApis);
            }
        }
        return this.openAPI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ApiVersion> getApiVersions() {
        GeneratorSettings generatorSettings = this;
        synchronized (generatorSettings) {
            if (this.apiVersions == null) {
                this.apiVersions = GeneratorSettings.computeApiVersions(this.getOpenAPI());
            }
        }
        return this.apiVersions;
    }

    public synchronized File getGeneratedSourcesDirectory() {
        if (this.generatedSourcesDirectory == null) {
            this.generatedSourcesDirectory = this.getOutputDirectory().toPath().resolve("src").resolve("generated").resolve("java").toFile();
        }
        return this.generatedSourcesDirectory;
    }

    public synchronized File getOverridesDirectory() {
        if (this.overridesDirectory == null) {
            this.overridesDirectory = this.getOutputDirectory().toPath().resolve("src").resolve("main").resolve("java").toFile();
        }
        return this.overridesDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPackageMappings() {
        if (this.packageMappings == null) {
            return Collections.emptyMap();
        }
        if (!this.packageMappingsProcessed.getAndSet(true)) {
            GeneratorSettings generatorSettings = this;
            synchronized (generatorSettings) {
                this.packageMappings = Collections.unmodifiableMap(this.packageMappings.keySet().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toMap(k -> k, this.packageMappings::get, (v1, v2) -> v2, LinkedHashMap::new)));
            }
        }
        return this.packageMappings;
    }

    public String getHasMetadataClassSimpleName() {
        return this.hasMetadataClass.substring(this.hasMetadataClass.lastIndexOf(46) + 1);
    }

    public String getKubernetesResourceClassSimpleName() {
        return this.kubernetesResourceClass.substring(this.kubernetesResourceClass.lastIndexOf(46) + 1);
    }

    public String getKubernetesResourceListClassSimpleName() {
        return this.kubernetesResourceListClass.substring(this.kubernetesResourceListClass.lastIndexOf(46) + 1);
    }

    public String getNamespacedClassSimpleName() {
        return this.namespacedClass.substring(this.namespacedClass.lastIndexOf(46) + 1);
    }

    private static Map<String, ApiVersion> computeApiVersions(OpenAPI openAPI) {
        HashMap<String, ApiVersion> apiVersions = new HashMap<String, ApiVersion>();
        List apiPaths = openAPI.getPaths().entrySet().stream().filter(e -> GeneratorSettings.isApplicablePath((PathItem)e.getValue())).collect(Collectors.toList());
        for (Map.Entry apiPath : apiPaths) {
            for (Operation operation : new Operation[]{((PathItem)apiPath.getValue()).getGet(), ((PathItem)apiPath.getValue()).getPost()}) {
                if (operation == null || operation.getResponses().get((Object)"200") == null || ((ApiResponse)operation.getResponses().get((Object)"200")).getContent().get((Object)"application/json") == null || operation.getExtensions() == null || operation.getExtensions().get("x-kubernetes-group-version-kind") == null) continue;
                ApiVersion.ApiVersionBuilder apiVersionBuilder = ApiVersion.builder();
                Map groupVersionKind = (Map)operation.getExtensions().get("x-kubernetes-group-version-kind");
                apiVersionBuilder.group((String)groupVersionKind.get("group"));
                apiVersionBuilder.version((String)groupVersionKind.get("version"));
                apiVersionBuilder.namespaced(GeneratorSettings.isNamespaced(operation));
                String ref = ((MediaType)((ApiResponse)operation.getResponses().get((Object)"200")).getContent().get((Object)"application/json")).getSchema().get$ref();
                if (ref == null || ref.startsWith("#/components/schemas/io.k8s.apimachinery.pkg.apis")) continue;
                apiVersions.put(ref.replaceFirst("#/components/schemas/", ""), apiVersionBuilder.build());
            }
        }
        openAPI.getComponents().getSchemas().entrySet().stream().filter(e -> ((Schema)e.getValue()).getExtensions() != null).filter(e -> ((Schema)e.getValue()).getExtensions().containsKey("x-fabric8-info")).forEach(e -> {
            Map fabric8Info = (Map)((Schema)e.getValue()).getExtensions().get("x-fabric8-info");
            if (!Objects.equals(fabric8Info.get("Type"), "nested")) {
                apiVersions.putIfAbsent((String)e.getKey(), ApiVersion.builder().group(fabric8Info.get("Group").toString()).version(fabric8Info.get("Version").toString()).namespaced(Objects.equals(fabric8Info.get("Scope").toString(), "Namespaced")).build());
            }
        });
        openAPI.getComponents().getSchemas().entrySet().stream().filter(GeneratorSettings::isApplicableApiMachineryOrCoreComponent).forEach(e -> apiVersions.putIfAbsent((String)e.getKey(), ApiVersion.builder().group("").version("v1").build()));
        return apiVersions;
    }

    private static boolean isApplicablePath(PathItem pathItem) {
        Operation get = pathItem.getGet();
        Operation post = pathItem.getPost();
        if (get == null && post == null) {
            return false;
        }
        if (GeneratorSettings.pathParameters(get).isEmpty() || GeneratorSettings.isNamespaced(get) && GeneratorSettings.pathParameters(get).size() == 1) {
            return true;
        }
        return GeneratorSettings.pathParameters(get).stream().map(Parameter::getName).anyMatch("name"::equals) || GeneratorSettings.pathParameters(post).stream().map(Parameter::getName).anyMatch("name"::equals);
    }

    private static boolean isApplicableApiMachineryOrCoreComponent(Map.Entry<String, Schema> componentSchema) {
        if (!componentSchema.getKey().startsWith("io.k8s.apimachinery.pkg.apis") && !componentSchema.getKey().startsWith("io.k8s.api.core.v1.PodExecOptions")) {
            return false;
        }
        if (componentSchema.getValue().getProperties() == null) {
            return false;
        }
        Set fields = componentSchema.getValue().getProperties().keySet();
        return fields.contains("apiVersion") && fields.contains("kind");
    }

    private static boolean isNamespaced(Operation operation) {
        List<Parameter> parameters = GeneratorSettings.pathParameters(operation);
        return parameters.stream().map(Parameter::getName).anyMatch("namespace"::equals);
    }

    private static List<Parameter> pathParameters(Operation operation) {
        if (operation == null || operation.getParameters() == null) {
            return Collections.emptyList();
        }
        return operation.getParameters().stream().filter(p -> p.getIn().equals("path")).collect(Collectors.toList());
    }

    @Generated
    private static Properties $default$refToClassNameMappings() {
        return new Properties();
    }

    @Generated
    private static Properties $default$refToJavaTypeMappings() {
        return new Properties();
    }

    @Generated
    private static String $default$genericKubernetesResourceClass() {
        return "io.fabric8.kubernetes.api.model.GenericKubernetesResource";
    }

    @Generated
    private static String $default$hasMetadataClass() {
        return "io.fabric8.kubernetes.api.model.HasMetadata";
    }

    @Generated
    private static String $default$kubernetesResourceClass() {
        return "io.fabric8.kubernetes.api.model.KubernetesResource";
    }

    @Generated
    private static String $default$kubernetesResourceListClass() {
        return "io.fabric8.kubernetes.api.model.KubernetesResourceList";
    }

    @Generated
    private static String $default$objectMetaClass() {
        return "io.fabric8.kubernetes.api.model.ObjectMeta";
    }

    @Generated
    private static String $default$namespacedClass() {
        return "io.fabric8.kubernetes.api.model.Namespaced";
    }

    @Generated
    private static String $default$rawExtensionClass() {
        return "io.fabric8.kubernetes.api.model.runtime.RawExtension";
    }

    @Generated
    private static List<String> $default$buildableReferences() {
        return Arrays.asList("io.fabric8.kubernetes.api.model.LabelSelector", "io.fabric8.kubernetes.api.model.Container", "io.fabric8.kubernetes.api.model.PodTemplateSpec", "io.fabric8.kubernetes.api.model.ResourceRequirements", "io.fabric8.kubernetes.api.model.IntOrString", "io.fabric8.kubernetes.api.model.ObjectReference", "io.fabric8.kubernetes.api.model.LocalObjectReference", "io.fabric8.kubernetes.api.model.PersistentVolumeClaim", "io.fabric8.kubernetes.api.model.EnvVar", "io.fabric8.kubernetes.api.model.ContainerPort", "io.fabric8.kubernetes.api.model.Volume", "io.fabric8.kubernetes.api.model.VolumeMount");
    }

    @Generated
    public static GeneratorSettingsBuilder builder() {
        return new GeneratorSettingsBuilder();
    }

    @Generated
    public GeneratorSettingsBuilder toBuilder() {
        GeneratorSettingsBuilder builder = new GeneratorSettingsBuilder().logger(this.logger).openAPI(this.openAPI).apiVersions(this.apiVersions).outputDirectory(this.outputDirectory).generatedSourcesDirectory(this.generatedSourcesDirectory).overridesDirectory(this.overridesDirectory).packageName(this.packageName).builderPackage(this.builderPackage).addBuildableReferences(this.addBuildableReferences).refToClassNameMappings(this.refToClassNameMappings).refToJavaTypeMappings(this.refToJavaTypeMappings).generateJavadoc(this.generateJavadoc).genericKubernetesResourceClass(this.genericKubernetesResourceClass).hasMetadataClass(this.hasMetadataClass).kubernetesResourceClass(this.kubernetesResourceClass).kubernetesResourceListClass(this.kubernetesResourceListClass).objectMetaClass(this.objectMetaClass).namespacedClass(this.namespacedClass).rawExtensionClass(this.rawExtensionClass).buildableReferences(this.buildableReferences);
        if (this.schemas != null) {
            builder.schemas(this.schemas);
        }
        if (this.urls != null) {
            builder.urls(this.urls);
        }
        if (this.packageMappings != null) {
            builder.packageMappings(this.packageMappings);
        }
        if (this.fieldNameMappings != null) {
            builder.fieldNameMappings(this.fieldNameMappings);
        }
        if (this.skipGenerationRegexes != null) {
            builder.skipGenerationRegexes(this.skipGenerationRegexes);
        }
        if (this.includeGenerationRegexes != null) {
            builder.includeGenerationRegexes(this.includeGenerationRegexes);
        }
        return builder;
    }

    @Generated
    public GeneratorSettings() {
        this.refToClassNameMappings = GeneratorSettings.$default$refToClassNameMappings();
        this.refToJavaTypeMappings = GeneratorSettings.$default$refToJavaTypeMappings();
        this.genericKubernetesResourceClass = GeneratorSettings.$default$genericKubernetesResourceClass();
        this.hasMetadataClass = GeneratorSettings.$default$hasMetadataClass();
        this.kubernetesResourceClass = GeneratorSettings.$default$kubernetesResourceClass();
        this.kubernetesResourceListClass = GeneratorSettings.$default$kubernetesResourceListClass();
        this.objectMetaClass = GeneratorSettings.$default$objectMetaClass();
        this.namespacedClass = GeneratorSettings.$default$namespacedClass();
        this.rawExtensionClass = GeneratorSettings.$default$rawExtensionClass();
        this.buildableReferences = GeneratorSettings.$default$buildableReferences();
    }

    @Generated
    public GeneratorSettings(Logger logger, List<File> schemas, List<String> urls, OpenAPI openAPI, Map<String, ApiVersion> apiVersions, File outputDirectory, File generatedSourcesDirectory, File overridesDirectory, String packageName, String builderPackage, boolean addBuildableReferences, Map<String, String> packageMappings, Properties refToClassNameMappings, Properties refToJavaTypeMappings, Map<String, String> fieldNameMappings, Set<String> skipGenerationRegexes, Set<String> includeGenerationRegexes, boolean generateJavadoc, String genericKubernetesResourceClass, String hasMetadataClass, String kubernetesResourceClass, String kubernetesResourceListClass, String objectMetaClass, String namespacedClass, String rawExtensionClass, List<String> buildableReferences) {
        this.logger = logger;
        this.schemas = schemas;
        this.urls = urls;
        this.openAPI = openAPI;
        this.apiVersions = apiVersions;
        this.outputDirectory = outputDirectory;
        this.generatedSourcesDirectory = generatedSourcesDirectory;
        this.overridesDirectory = overridesDirectory;
        this.packageName = packageName;
        this.builderPackage = builderPackage;
        this.addBuildableReferences = addBuildableReferences;
        this.packageMappings = packageMappings;
        this.refToClassNameMappings = refToClassNameMappings;
        this.refToJavaTypeMappings = refToJavaTypeMappings;
        this.fieldNameMappings = fieldNameMappings;
        this.skipGenerationRegexes = skipGenerationRegexes;
        this.includeGenerationRegexes = includeGenerationRegexes;
        this.generateJavadoc = generateJavadoc;
        this.genericKubernetesResourceClass = genericKubernetesResourceClass;
        this.hasMetadataClass = hasMetadataClass;
        this.kubernetesResourceClass = kubernetesResourceClass;
        this.kubernetesResourceListClass = kubernetesResourceListClass;
        this.objectMetaClass = objectMetaClass;
        this.namespacedClass = namespacedClass;
        this.rawExtensionClass = rawExtensionClass;
        this.buildableReferences = buildableReferences;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public List<File> getSchemas() {
        return this.schemas;
    }

    @Generated
    public List<String> getUrls() {
        return this.urls;
    }

    @Generated
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getBuilderPackage() {
        return this.builderPackage;
    }

    @Generated
    public boolean isAddBuildableReferences() {
        return this.addBuildableReferences;
    }

    @Generated
    public AtomicBoolean getPackageMappingsProcessed() {
        return this.packageMappingsProcessed;
    }

    @Generated
    public Properties getRefToClassNameMappings() {
        return this.refToClassNameMappings;
    }

    @Generated
    public Properties getRefToJavaTypeMappings() {
        return this.refToJavaTypeMappings;
    }

    @Generated
    public Map<String, String> getFieldNameMappings() {
        return this.fieldNameMappings;
    }

    @Generated
    public Set<String> getSkipGenerationRegexes() {
        return this.skipGenerationRegexes;
    }

    @Generated
    public Set<String> getIncludeGenerationRegexes() {
        return this.includeGenerationRegexes;
    }

    @Generated
    public boolean isGenerateJavadoc() {
        return this.generateJavadoc;
    }

    @Generated
    public String getGenericKubernetesResourceClass() {
        return this.genericKubernetesResourceClass;
    }

    @Generated
    public String getHasMetadataClass() {
        return this.hasMetadataClass;
    }

    @Generated
    public String getKubernetesResourceClass() {
        return this.kubernetesResourceClass;
    }

    @Generated
    public String getKubernetesResourceListClass() {
        return this.kubernetesResourceListClass;
    }

    @Generated
    public String getObjectMetaClass() {
        return this.objectMetaClass;
    }

    @Generated
    public String getNamespacedClass() {
        return this.namespacedClass;
    }

    @Generated
    public String getRawExtensionClass() {
        return this.rawExtensionClass;
    }

    @Generated
    public List<String> getBuildableReferences() {
        return this.buildableReferences;
    }

    @Generated
    public static class GeneratorSettingsBuilder {
        @Generated
        private Logger logger;
        @Generated
        private ArrayList<File> schemas;
        @Generated
        private ArrayList<String> urls;
        @Generated
        private OpenAPI openAPI;
        @Generated
        private Map<String, ApiVersion> apiVersions;
        @Generated
        private File outputDirectory;
        @Generated
        private File generatedSourcesDirectory;
        @Generated
        private File overridesDirectory;
        @Generated
        private String packageName;
        @Generated
        private String builderPackage;
        @Generated
        private boolean addBuildableReferences;
        @Generated
        private ArrayList<String> packageMappings$key;
        @Generated
        private ArrayList<String> packageMappings$value;
        @Generated
        private boolean refToClassNameMappings$set;
        @Generated
        private Properties refToClassNameMappings$value;
        @Generated
        private boolean refToJavaTypeMappings$set;
        @Generated
        private Properties refToJavaTypeMappings$value;
        @Generated
        private ArrayList<String> fieldNameMappings$key;
        @Generated
        private ArrayList<String> fieldNameMappings$value;
        @Generated
        private ArrayList<String> skipGenerationRegexes;
        @Generated
        private ArrayList<String> includeGenerationRegexes;
        @Generated
        private boolean generateJavadoc;
        @Generated
        private boolean genericKubernetesResourceClass$set;
        @Generated
        private String genericKubernetesResourceClass$value;
        @Generated
        private boolean hasMetadataClass$set;
        @Generated
        private String hasMetadataClass$value;
        @Generated
        private boolean kubernetesResourceClass$set;
        @Generated
        private String kubernetesResourceClass$value;
        @Generated
        private boolean kubernetesResourceListClass$set;
        @Generated
        private String kubernetesResourceListClass$value;
        @Generated
        private boolean objectMetaClass$set;
        @Generated
        private String objectMetaClass$value;
        @Generated
        private boolean namespacedClass$set;
        @Generated
        private String namespacedClass$value;
        @Generated
        private boolean rawExtensionClass$set;
        @Generated
        private String rawExtensionClass$value;
        @Generated
        private boolean buildableReferences$set;
        @Generated
        private List<String> buildableReferences$value;

        @Generated
        GeneratorSettingsBuilder() {
        }

        @Generated
        public GeneratorSettingsBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder schema(File schema) {
            if (this.schemas == null) {
                this.schemas = new ArrayList();
            }
            this.schemas.add(schema);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder schemas(Collection<? extends File> schemas) {
            if (schemas == null) {
                throw new NullPointerException("schemas cannot be null");
            }
            if (this.schemas == null) {
                this.schemas = new ArrayList();
            }
            this.schemas.addAll(schemas);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder clearSchemas() {
            if (this.schemas != null) {
                this.schemas.clear();
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder url(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.add(url);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder urls(Collection<? extends String> urls) {
            if (urls == null) {
                throw new NullPointerException("urls cannot be null");
            }
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.addAll(urls);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder clearUrls() {
            if (this.urls != null) {
                this.urls.clear();
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder openAPI(OpenAPI openAPI) {
            this.openAPI = openAPI;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder apiVersions(Map<String, ApiVersion> apiVersions) {
            this.apiVersions = apiVersions;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder outputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder generatedSourcesDirectory(File generatedSourcesDirectory) {
            this.generatedSourcesDirectory = generatedSourcesDirectory;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder overridesDirectory(File overridesDirectory) {
            this.overridesDirectory = overridesDirectory;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder builderPackage(String builderPackage) {
            this.builderPackage = builderPackage;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder addBuildableReferences(boolean addBuildableReferences) {
            this.addBuildableReferences = addBuildableReferences;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder packageMapping(String packageMappingKey, String packageMappingValue) {
            if (this.packageMappings$key == null) {
                this.packageMappings$key = new ArrayList();
                this.packageMappings$value = new ArrayList();
            }
            this.packageMappings$key.add(packageMappingKey);
            this.packageMappings$value.add(packageMappingValue);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder packageMappings(Map<? extends String, ? extends String> packageMappings) {
            if (packageMappings == null) {
                throw new NullPointerException("packageMappings cannot be null");
            }
            if (this.packageMappings$key == null) {
                this.packageMappings$key = new ArrayList();
                this.packageMappings$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : packageMappings.entrySet()) {
                this.packageMappings$key.add($lombokEntry.getKey());
                this.packageMappings$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder clearPackageMappings() {
            if (this.packageMappings$key != null) {
                this.packageMappings$key.clear();
                this.packageMappings$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder refToClassNameMappings(Properties refToClassNameMappings) {
            this.refToClassNameMappings$value = refToClassNameMappings;
            this.refToClassNameMappings$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder refToJavaTypeMappings(Properties refToJavaTypeMappings) {
            this.refToJavaTypeMappings$value = refToJavaTypeMappings;
            this.refToJavaTypeMappings$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder fieldNameMapping(String fieldNameMappingKey, String fieldNameMappingValue) {
            if (this.fieldNameMappings$key == null) {
                this.fieldNameMappings$key = new ArrayList();
                this.fieldNameMappings$value = new ArrayList();
            }
            this.fieldNameMappings$key.add(fieldNameMappingKey);
            this.fieldNameMappings$value.add(fieldNameMappingValue);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder fieldNameMappings(Map<? extends String, ? extends String> fieldNameMappings) {
            if (fieldNameMappings == null) {
                throw new NullPointerException("fieldNameMappings cannot be null");
            }
            if (this.fieldNameMappings$key == null) {
                this.fieldNameMappings$key = new ArrayList();
                this.fieldNameMappings$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : fieldNameMappings.entrySet()) {
                this.fieldNameMappings$key.add($lombokEntry.getKey());
                this.fieldNameMappings$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder clearFieldNameMappings() {
            if (this.fieldNameMappings$key != null) {
                this.fieldNameMappings$key.clear();
                this.fieldNameMappings$value.clear();
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder skipGenerationRegex(String skipGenerationRegex) {
            if (this.skipGenerationRegexes == null) {
                this.skipGenerationRegexes = new ArrayList();
            }
            this.skipGenerationRegexes.add(skipGenerationRegex);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder skipGenerationRegexes(Collection<? extends String> skipGenerationRegexes) {
            if (skipGenerationRegexes == null) {
                throw new NullPointerException("skipGenerationRegexes cannot be null");
            }
            if (this.skipGenerationRegexes == null) {
                this.skipGenerationRegexes = new ArrayList();
            }
            this.skipGenerationRegexes.addAll(skipGenerationRegexes);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder clearSkipGenerationRegexes() {
            if (this.skipGenerationRegexes != null) {
                this.skipGenerationRegexes.clear();
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder includeGenerationRegex(String includeGenerationRegex) {
            if (this.includeGenerationRegexes == null) {
                this.includeGenerationRegexes = new ArrayList();
            }
            this.includeGenerationRegexes.add(includeGenerationRegex);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder includeGenerationRegexes(Collection<? extends String> includeGenerationRegexes) {
            if (includeGenerationRegexes == null) {
                throw new NullPointerException("includeGenerationRegexes cannot be null");
            }
            if (this.includeGenerationRegexes == null) {
                this.includeGenerationRegexes = new ArrayList();
            }
            this.includeGenerationRegexes.addAll(includeGenerationRegexes);
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder clearIncludeGenerationRegexes() {
            if (this.includeGenerationRegexes != null) {
                this.includeGenerationRegexes.clear();
            }
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder generateJavadoc(boolean generateJavadoc) {
            this.generateJavadoc = generateJavadoc;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder genericKubernetesResourceClass(String genericKubernetesResourceClass) {
            this.genericKubernetesResourceClass$value = genericKubernetesResourceClass;
            this.genericKubernetesResourceClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder hasMetadataClass(String hasMetadataClass) {
            this.hasMetadataClass$value = hasMetadataClass;
            this.hasMetadataClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder kubernetesResourceClass(String kubernetesResourceClass) {
            this.kubernetesResourceClass$value = kubernetesResourceClass;
            this.kubernetesResourceClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder kubernetesResourceListClass(String kubernetesResourceListClass) {
            this.kubernetesResourceListClass$value = kubernetesResourceListClass;
            this.kubernetesResourceListClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder objectMetaClass(String objectMetaClass) {
            this.objectMetaClass$value = objectMetaClass;
            this.objectMetaClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder namespacedClass(String namespacedClass) {
            this.namespacedClass$value = namespacedClass;
            this.namespacedClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder rawExtensionClass(String rawExtensionClass) {
            this.rawExtensionClass$value = rawExtensionClass;
            this.rawExtensionClass$set = true;
            return this;
        }

        @Generated
        public GeneratorSettingsBuilder buildableReferences(List<String> buildableReferences) {
            this.buildableReferences$value = buildableReferences;
            this.buildableReferences$set = true;
            return this;
        }

        @Generated
        public GeneratorSettings build() {
            Set<Object> includeGenerationRegexes;
            Set<Object> skipGenerationRegexes;
            Map<Object, Object> fieldNameMappings;
            Map<Object, Object> packageMappings;
            List<String> urls;
            List<File> schemas;
            switch (this.schemas == null ? 0 : this.schemas.size()) {
                case 0: {
                    schemas = Collections.emptyList();
                    break;
                }
                case 1: {
                    schemas = Collections.singletonList(this.schemas.get(0));
                    break;
                }
                default: {
                    schemas = Collections.unmodifiableList(new ArrayList<File>(this.schemas));
                }
            }
            switch (this.urls == null ? 0 : this.urls.size()) {
                case 0: {
                    urls = Collections.emptyList();
                    break;
                }
                case 1: {
                    urls = Collections.singletonList(this.urls.get(0));
                    break;
                }
                default: {
                    urls = Collections.unmodifiableList(new ArrayList<String>(this.urls));
                }
            }
            switch (this.packageMappings$key == null ? 0 : this.packageMappings$key.size()) {
                case 0: {
                    packageMappings = Collections.emptyMap();
                    break;
                }
                case 1: {
                    packageMappings = Collections.singletonMap(this.packageMappings$key.get(0), this.packageMappings$value.get(0));
                    break;
                }
                default: {
                    packageMappings = new LinkedHashMap(this.packageMappings$key.size() < 0x40000000 ? 1 + this.packageMappings$key.size() + (this.packageMappings$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.packageMappings$key.size(); ++$i) {
                        packageMappings.put(this.packageMappings$key.get($i), this.packageMappings$value.get($i));
                    }
                    packageMappings = Collections.unmodifiableMap(packageMappings);
                }
            }
            switch (this.fieldNameMappings$key == null ? 0 : this.fieldNameMappings$key.size()) {
                case 0: {
                    fieldNameMappings = Collections.emptyMap();
                    break;
                }
                case 1: {
                    fieldNameMappings = Collections.singletonMap(this.fieldNameMappings$key.get(0), this.fieldNameMappings$value.get(0));
                    break;
                }
                default: {
                    fieldNameMappings = new LinkedHashMap(this.fieldNameMappings$key.size() < 0x40000000 ? 1 + this.fieldNameMappings$key.size() + (this.fieldNameMappings$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.fieldNameMappings$key.size(); ++$i) {
                        fieldNameMappings.put(this.fieldNameMappings$key.get($i), this.fieldNameMappings$value.get($i));
                    }
                    fieldNameMappings = Collections.unmodifiableMap(fieldNameMappings);
                }
            }
            switch (this.skipGenerationRegexes == null ? 0 : this.skipGenerationRegexes.size()) {
                case 0: {
                    skipGenerationRegexes = Collections.emptySet();
                    break;
                }
                case 1: {
                    skipGenerationRegexes = Collections.singleton(this.skipGenerationRegexes.get(0));
                    break;
                }
                default: {
                    skipGenerationRegexes = new LinkedHashSet(this.skipGenerationRegexes.size() < 0x40000000 ? 1 + this.skipGenerationRegexes.size() + (this.skipGenerationRegexes.size() - 3) / 3 : Integer.MAX_VALUE);
                    skipGenerationRegexes.addAll(this.skipGenerationRegexes);
                    skipGenerationRegexes = Collections.unmodifiableSet(skipGenerationRegexes);
                }
            }
            switch (this.includeGenerationRegexes == null ? 0 : this.includeGenerationRegexes.size()) {
                case 0: {
                    includeGenerationRegexes = Collections.emptySet();
                    break;
                }
                case 1: {
                    includeGenerationRegexes = Collections.singleton(this.includeGenerationRegexes.get(0));
                    break;
                }
                default: {
                    includeGenerationRegexes = new LinkedHashSet(this.includeGenerationRegexes.size() < 0x40000000 ? 1 + this.includeGenerationRegexes.size() + (this.includeGenerationRegexes.size() - 3) / 3 : Integer.MAX_VALUE);
                    includeGenerationRegexes.addAll(this.includeGenerationRegexes);
                    includeGenerationRegexes = Collections.unmodifiableSet(includeGenerationRegexes);
                }
            }
            Properties refToClassNameMappings$value = this.refToClassNameMappings$value;
            if (!this.refToClassNameMappings$set) {
                refToClassNameMappings$value = GeneratorSettings.$default$refToClassNameMappings();
            }
            Properties refToJavaTypeMappings$value = this.refToJavaTypeMappings$value;
            if (!this.refToJavaTypeMappings$set) {
                refToJavaTypeMappings$value = GeneratorSettings.$default$refToJavaTypeMappings();
            }
            String genericKubernetesResourceClass$value = this.genericKubernetesResourceClass$value;
            if (!this.genericKubernetesResourceClass$set) {
                genericKubernetesResourceClass$value = GeneratorSettings.$default$genericKubernetesResourceClass();
            }
            String hasMetadataClass$value = this.hasMetadataClass$value;
            if (!this.hasMetadataClass$set) {
                hasMetadataClass$value = GeneratorSettings.$default$hasMetadataClass();
            }
            String kubernetesResourceClass$value = this.kubernetesResourceClass$value;
            if (!this.kubernetesResourceClass$set) {
                kubernetesResourceClass$value = GeneratorSettings.$default$kubernetesResourceClass();
            }
            String kubernetesResourceListClass$value = this.kubernetesResourceListClass$value;
            if (!this.kubernetesResourceListClass$set) {
                kubernetesResourceListClass$value = GeneratorSettings.$default$kubernetesResourceListClass();
            }
            String objectMetaClass$value = this.objectMetaClass$value;
            if (!this.objectMetaClass$set) {
                objectMetaClass$value = GeneratorSettings.$default$objectMetaClass();
            }
            String namespacedClass$value = this.namespacedClass$value;
            if (!this.namespacedClass$set) {
                namespacedClass$value = GeneratorSettings.$default$namespacedClass();
            }
            String rawExtensionClass$value = this.rawExtensionClass$value;
            if (!this.rawExtensionClass$set) {
                rawExtensionClass$value = GeneratorSettings.$default$rawExtensionClass();
            }
            List<String> buildableReferences$value = this.buildableReferences$value;
            if (!this.buildableReferences$set) {
                buildableReferences$value = GeneratorSettings.$default$buildableReferences();
            }
            return new GeneratorSettings(this.logger, schemas, urls, this.openAPI, this.apiVersions, this.outputDirectory, this.generatedSourcesDirectory, this.overridesDirectory, this.packageName, this.builderPackage, this.addBuildableReferences, packageMappings, refToClassNameMappings$value, refToJavaTypeMappings$value, fieldNameMappings, skipGenerationRegexes, includeGenerationRegexes, this.generateJavadoc, genericKubernetesResourceClass$value, hasMetadataClass$value, kubernetesResourceClass$value, kubernetesResourceListClass$value, objectMetaClass$value, namespacedClass$value, rawExtensionClass$value, buildableReferences$value);
        }

        @Generated
        public String toString() {
            return "GeneratorSettings.GeneratorSettingsBuilder(logger=" + String.valueOf(this.logger) + ", schemas=" + String.valueOf(this.schemas) + ", urls=" + String.valueOf(this.urls) + ", openAPI=" + String.valueOf(this.openAPI) + ", apiVersions=" + String.valueOf(this.apiVersions) + ", outputDirectory=" + String.valueOf(this.outputDirectory) + ", generatedSourcesDirectory=" + String.valueOf(this.generatedSourcesDirectory) + ", overridesDirectory=" + String.valueOf(this.overridesDirectory) + ", packageName=" + this.packageName + ", builderPackage=" + this.builderPackage + ", addBuildableReferences=" + this.addBuildableReferences + ", packageMappings$key=" + String.valueOf(this.packageMappings$key) + ", packageMappings$value=" + String.valueOf(this.packageMappings$value) + ", refToClassNameMappings$value=" + String.valueOf(this.refToClassNameMappings$value) + ", refToJavaTypeMappings$value=" + String.valueOf(this.refToJavaTypeMappings$value) + ", fieldNameMappings$key=" + String.valueOf(this.fieldNameMappings$key) + ", fieldNameMappings$value=" + String.valueOf(this.fieldNameMappings$value) + ", skipGenerationRegexes=" + String.valueOf(this.skipGenerationRegexes) + ", includeGenerationRegexes=" + String.valueOf(this.includeGenerationRegexes) + ", generateJavadoc=" + this.generateJavadoc + ", genericKubernetesResourceClass$value=" + this.genericKubernetesResourceClass$value + ", hasMetadataClass$value=" + this.hasMetadataClass$value + ", kubernetesResourceClass$value=" + this.kubernetesResourceClass$value + ", kubernetesResourceListClass$value=" + this.kubernetesResourceListClass$value + ", objectMetaClass$value=" + this.objectMetaClass$value + ", namespacedClass$value=" + this.namespacedClass$value + ", rawExtensionClass$value=" + this.rawExtensionClass$value + ", buildableReferences$value=" + String.valueOf(this.buildableReferences$value) + ")";
        }
    }
}

