/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.schema.generator.model;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.fabric8.kubernetes.schema.generator.GeneratorException;
import io.fabric8.kubernetes.schema.generator.GeneratorSettings;
import io.fabric8.kubernetes.schema.generator.GeneratorUtils;
import io.fabric8.kubernetes.schema.generator.model.TemplateContext;
import io.fabric8.kubernetes.schema.generator.schema.SchemaUtils;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

class ModelGenerator {
    private final GeneratorSettings settings;
    private final SchemaUtils utils;
    private final GeneratorUtils generatorUtils;
    private final Template modelTemplate;

    ModelGenerator(GeneratorSettings settings) {
        this.settings = settings;
        this.utils = new SchemaUtils(settings);
        this.generatorUtils = new GeneratorUtils(settings);
        this.modelTemplate = Mustache.compiler().withLoader(name -> new StringReader(this.generatorUtils.readTemplate(name))).defaultValue("").withEscaper(Escapers.NONE).compile(this.generatorUtils.readTemplate("model"));
    }

    void generate() {
        GeneratorUtils.cleanSourceDirectory(this.settings.getGeneratedSourcesDirectory());
        Map<String, Schema<?>> schemas = this.utils.extractComponentSchemas();
        this.settings.getLogger().info(String.format("Found %s schemas", schemas.size()));
        AtomicInteger generatedClasses = new AtomicInteger();
        schemas.entrySet().stream().filter(GeneratorUtils.filter(this.settings)).filter(entry -> entry.getValue() instanceof ObjectSchema).forEach(classEntry -> {
            TemplateContext templateContext = new TemplateContext(this.settings, (Map.Entry<String, Schema<?>>)classEntry);
            if (this.hasOverride(templateContext)) {
                this.settings.getLogger().fine(String.format("Skipping %s since it has an override", templateContext.getClassInformation().getClassName()));
                return;
            }
            this.settings.getLogger().fine(String.format("Generating %ss", templateContext.getClassInformation().getClassName()));
            this.mkPackageDirectories(templateContext);
            this.processTemplate(templateContext);
            String fileContents = this.modelTemplate.execute(templateContext.getContext());
            this.writeFile(templateContext, fileContents);
            generatedClasses.incrementAndGet();
        });
        this.settings.getLogger().info(String.format("Generated %s model entries", generatedClasses.get()));
    }

    private void processTemplate(TemplateContext ret) {
        String deserializer;
        String serializer;
        ret.addAllImports(ModelGenerator.initDefaultImports());
        if (ret.getApiVersion() != null) {
            ret.addImport("io.fabric8.kubernetes.model.annotation.Version");
            ret.put("version", ret.getApiVersion().getVersion());
            if (Objects.equals("Group", ret.getClassInformation().getClassSimpleName())) {
                ret.put("group", "@io.fabric8.kubernetes.model.annotation.Group(\"" + ret.getApiVersion().getGroup() + "\")");
            } else {
                ret.addImport("io.fabric8.kubernetes.model.annotation.Group");
                ret.put("group", "@Group(\"" + ret.getApiVersion().getGroup() + "\")");
            }
            ret.addImport("io.sundr.transform.annotations.TemplateTransformation");
            ret.addImport("io.sundr.transform.annotations.TemplateTransformations");
            ret.put("kubernetesResourceClass", this.settings.getKubernetesResourceClass());
        }
        if ((serializer = SchemaUtils.serializerForJavaClass(ret.getClassInformation().getClassName())) != null) {
            ret.addImport("com.fasterxml.jackson.databind.annotation.JsonSerialize");
            ret.put("classJsonSerializeUsing", serializer);
        }
        if ((deserializer = SchemaUtils.hasInterfaceFields(ret.getClassSchema()) ? "io.fabric8.kubernetes.model.jackson.JsonUnwrappedDeserializer.class" : (SchemaUtils.deserializerForJavaClass(ret.getClassInformation().getClassName()) != null ? SchemaUtils.deserializerForJavaClass(ret.getClassInformation().getClassName()) : (!ret.getClassInformation().isEnum() ? "com.fasterxml.jackson.databind.JsonDeserializer.None.class" : null))) != null) {
            ret.addImport("com.fasterxml.jackson.databind.annotation.JsonDeserialize");
            ret.put("classJsonDeserializeUsing", deserializer);
        }
        if (!ret.getClassInformation().isEnum()) {
            ret.addImport("com.fasterxml.jackson.annotation.JsonInclude");
            ret.put("classJsonInclude", "NON_NULL");
        }
        if (!ret.getClassInformation().isInterface() && !ret.getClassInformation().isEnum()) {
            ret.addImport("com.fasterxml.jackson.annotation.JsonPropertyOrder");
            ret.put("propertyOrder", SchemaUtils.propertyOrder(ret.getClassSchema()));
            ret.addImport("lombok.ToString");
            ret.put("lombokToString", true);
            ret.addImport("lombok.EqualsAndHashCode");
            ret.put("lombokEqualsAndHashCode", true);
            ret.addImport("lombok.experimental.Accessors");
            ret.put("lombokAccessors", true);
        }
        ret.put("package", ret.getPackageName());
        if (this.settings.isGenerateJavadoc() && !SchemaUtils.sanitizeDescription(ret.getClassSchema().getDescription()).trim().isEmpty()) {
            ret.put("description", SchemaUtils.sanitizeDescription(ret.getClassSchema().getDescription()));
        }
        List<Map<String, Object>> templateFields = this.templateFields(ret);
        ret.put("fields", templateFields);
        if (!templateFields.isEmpty()) {
            ret.put("hasFields", true);
            ret.addImport("com.fasterxml.jackson.annotation.JsonProperty");
        }
        ret.put("builderPackage", this.settings.getBuilderPackage());
        if (!ret.getClassInformation().isInterface() && !ret.getClassInformation().isEnum() && this.settings.isAddBuildableReferences()) {
            ret.put("buildable", false);
            ret.addImport("io.sundr.builder.annotations.Buildable");
            ret.addImport("io.sundr.builder.annotations.BuildableReference");
            ret.put("buildableReferences", this.buildableReferences(ret, templateFields));
        } else if (!ret.getClassInformation().isInterface() && !ret.getClassInformation().isEnum()) {
            ret.addImport("io.sundr.builder.annotations.Buildable");
            ret.put("buildable", true);
        }
        if (!(ret.getSchemaProperties().containsKey("additionalProperties") || ret.getClassInformation().isInterface() || ret.getClassInformation().isEnum())) {
            ret.put("additionalProperties", true);
            ret.addImport("java.util.LinkedHashMap");
            ret.addImport("java.util.Map");
            ret.addImport("com.fasterxml.jackson.annotation.JsonIgnore");
            ret.addImport("com.fasterxml.jackson.annotation.JsonAnyGetter");
            ret.addImport("com.fasterxml.jackson.annotation.JsonAnySetter");
        }
    }

    private List<Map<String, Object>> templateFields(TemplateContext templateContext) {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>();
        Set<String> interfaceFields = SchemaUtils.interfaceFields(templateContext.getClassSchema());
        for (Map.Entry<String, Schema> property : templateContext.getSchemaProperties().entrySet()) {
            String deserializeUsing;
            String serializeUsing;
            HashMap<String, Object> templateProp = new HashMap<String, Object>();
            Schema propertySchema = property.getValue();
            properties.add(templateProp);
            String type = this.utils.schemaToClassName(templateContext, propertySchema);
            templateProp.put("propertyName", property.getKey());
            templateProp.put("type", type);
            templateProp.put("name", this.utils.sanitizeFieldName(property.getKey()));
            templateProp.put("getterName", SchemaUtils.getterName(property.getKey()));
            templateProp.put("setterName", SchemaUtils.setterName(property.getKey()));
            if (Optional.ofNullable(templateContext.getClassSchema().getRequired()).orElse(Collections.emptyList()).contains(property.getKey())) {
                // empty if block
            }
            if (this.settings.isGenerateJavadoc() && !SchemaUtils.sanitizeDescription(propertySchema.getDescription()).trim().isEmpty()) {
                templateProp.put("description", SchemaUtils.sanitizeDescription(propertySchema.getDescription()));
            }
            if ((serializeUsing = SchemaUtils.serializerForSchema(propertySchema)) != null) {
                templateContext.addImport("com.fasterxml.jackson.databind.annotation.JsonSerialize");
                templateProp.put("serializeUsing", serializeUsing);
            }
            if ((deserializeUsing = SchemaUtils.deserializerForType(type)) != null) {
                templateContext.addImport("com.fasterxml.jackson.databind.annotation.JsonDeserialize");
                templateProp.put("deserializeUsing", deserializeUsing);
            }
            if (interfaceFields.contains(property.getKey())) {
                templateContext.addImport("com.fasterxml.jackson.annotation.JsonUnwrapped");
                templateProp.put("jsonUnwrapped", true);
            }
            if (SchemaUtils.isArray(propertySchema)) {
                templateContext.addImport("com.fasterxml.jackson.annotation.JsonInclude");
                templateProp.put("jsonInclude", "NON_EMPTY");
                templateContext.addImport("java.util.ArrayList");
                templateProp.put("defaultValue", "new ArrayList<>()");
            } else if (SchemaUtils.isMap(propertySchema)) {
                templateContext.addImport("com.fasterxml.jackson.annotation.JsonInclude");
                templateProp.put("jsonInclude", "NON_EMPTY");
                templateProp.put("defaultValue", "new LinkedHashMap<>()");
            } else if (Objects.equals(property.getKey(), "kind") && Objects.equals(type, "String") && templateContext.getApiVersion() != null) {
                templateProp.put("defaultValue", String.format("\"%s\"", templateContext.getClassInformation().getClassSimpleName()));
            } else if (Objects.equals(property.getKey(), "apiVersion") && Objects.equals(type, "String") && templateContext.getApiVersion() != null) {
                templateProp.put("defaultValue", String.format("\"%s\"", templateContext.getApiVersion()));
            }
            if (templateContext.getClassInformation().getKubernetesListType() == null || !Objects.equals(property.getKey(), "items")) continue;
            templateProp.put("type", "List<" + templateContext.getPackageName() + "." + templateContext.getClassInformation().getKubernetesListType() + ">");
        }
        return properties;
    }

    private void mkPackageDirectories(TemplateContext templateContext) {
        try {
            FileUtils.forceMkdir((File)this.resolvePackageDirectory(templateContext).toFile());
        }
        catch (IOException e) {
            throw new GeneratorException("Can't generate package directory for " + templateContext.getClassKey());
        }
    }

    private boolean hasOverride(TemplateContext templateContext) {
        return this.settings.getOverridesDirectory().toPath().resolve(templateContext.getPackageName().replace('.', File.separatorChar)).resolve(templateContext.getClassInformation().getClassSimpleName().concat(".java")).toFile().exists();
    }

    private Path resolvePackageDirectory(TemplateContext templateContext) {
        return this.settings.getGeneratedSourcesDirectory().toPath().resolve(templateContext.getPackageName().replace('.', File.separatorChar));
    }

    private Map<String, List<String>> buildableReferences(TemplateContext templateContext, List<Map<String, Object>> fields) {
        ArrayList<String> references = new ArrayList<String>(this.settings.getBuildableReferences());
        references.add(0, this.settings.getObjectMetaClass());
        if (fields.stream().map(f -> f.get("type")).filter(Objects::nonNull).map(Object::toString).anyMatch(r -> r.contains("KubernetesResource") || r.contains("HasMetadata") || r.contains("RawExtension"))) {
            references.add(this.settings.getGenericKubernetesResourceClass());
            references.add(this.settings.getRawExtensionClass());
        }
        return Collections.singletonMap("refs", references.stream().map(r -> {
            String referenceSimpleClass = r.substring(r.lastIndexOf(46) + 1);
            if (templateContext.getClassInformation().getClassSimpleName().equals(referenceSimpleClass)) {
                return r;
            }
            if (!templateContext.getImports().contains(r) && templateContext.hasSimpleClassName(referenceSimpleClass)) {
                return r;
            }
            templateContext.addImport((String)r);
            return referenceSimpleClass;
        }).map(ref -> ref.concat(".class")).collect(Collectors.toList()));
    }

    private void writeFile(TemplateContext context, String fileContents) {
        Path file = this.resolvePackageDirectory(context).resolve(context.getClassInformation().getClassSimpleName().concat(".java"));
        this.generatorUtils.writeFile(file, fileContents);
    }

    private static Set<String> initDefaultImports() {
        return new HashSet<String>(Collections.singletonList("javax.annotation.processing.Generated"));
    }
}

