/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.node.v1.Scheduling;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SchedulingFluent<A extends SchedulingFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> nodeSelector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public SchedulingFluent() {
    }

    public SchedulingFluent(Scheduling instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Scheduling instance) {
        Scheduling scheduling = instance = instance != null ? instance : new Scheduling();
        if (instance != null) {
            this.withNodeSelector(instance.getNodeSelector());
            this.withTolerations(instance.getTolerations());
            this.withNodeSelector(instance.getNodeSelector());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)((Object)this);
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)((Object)this);
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchedulingFluent that = (SchedulingFluent)((Object)o);
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector, this.tolerations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

