/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.examples;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.util.List;

public class ListImageStreams {
    public static void main(String[] args) {
        try {
            DefaultOpenShiftClient client = new DefaultOpenShiftClient();
            if (!client.supportsOpenShiftAPIGroup("image.openshift.io")) {
                System.out.println("WARNING this cluster does not support the API Group image.openshift.io");
                return;
            }
            ImageStreamList list = (ImageStreamList)client.imageStreams().list();
            if (list == null) {
                System.out.println("ERROR no list returned!");
                return;
            }
            List items = list.getItems();
            for (ImageStream item : items) {
                System.out.println("ImageStream " + item.getMetadata().getName() + " has version: " + item.getApiVersion());
            }
            System.out.println("Found " + items.size() + " ImageStream(s)");
        }
        catch (KubernetesClientException e) {
            System.out.println("Failed: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }
}

