/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.examples;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudget;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetBuilder;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetFluent;
import io.fabric8.kubernetes.api.model.policy.PodDisruptionBudgetSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodDisruptionBudgetExample {
    private static final Logger logger = LoggerFactory.getLogger(PodDisruptionBudgetExample.class);

    public static void main(String[] args) throws InterruptedException {
        String master = "https://192.168.99.100:8443/";
        if (args.length == 1) {
            master = args[0];
        }
        PodDisruptionBudgetExample.log("Using master with url ", master);
        Config config = ((ConfigBuilder)new ConfigBuilder().withMasterUrl(master)).build();
        try (DefaultKubernetesClient client = new DefaultKubernetesClient(config);){
            String namespace = "default";
            PodDisruptionBudget podDisruptionBudget = ((PodDisruptionBudgetBuilder)((PodDisruptionBudgetFluent.SpecNested)((PodDisruptionBudgetSpecFluent.SelectorNested)((PodDisruptionBudgetFluent.SpecNested)((PodDisruptionBudgetBuilder)((PodDisruptionBudgetFluent.MetadataNested)new PodDisruptionBudgetBuilder().withNewMetadata().withName("zk-pkb")).endMetadata()).withNewSpec().withMaxUnavailable(new IntOrString("1%"))).withNewSelector().withMatchLabels(Collections.singletonMap("app", "zookeeper"))).endSelector()).endSpec()).build();
            PodDisruptionBudgetExample.log("Current namespace is", "default");
            ((NonNamespaceOperation)client.policy().podDisruptionBudget().inNamespace("default")).create((Object[])new PodDisruptionBudget[]{podDisruptionBudget});
        }
        catch (KubernetesClientException e) {
            PodDisruptionBudgetExample.log("Could not create resource", e.getMessage());
        }
    }

    private static void log(String action, Object obj) {
        logger.info("{}: {}", (Object)action, obj);
    }

    private static void log(String action) {
        logger.info(action);
    }
}

