/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.Serialization;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.snakeyaml.engine.v2.exceptions.ConstructorException;

class SerializationYamlTest {
    SerializationYamlTest() {
    }

    @Test
    @DisplayName(value="unmarshal, evaluates non standard Java classes (needs fix)")
    @Disabled(value="This test should only pass in case SnakeYAML is set to evaluate non standard Java classes (which implies a security threat)")
    void unmarshalEvaluatesNonStandardClasses() {
        String genericResourceYaml = "kind: MyCustomResource\napiVersion: my.custom.resource.example.com/v1\nspec:\n  complex: !!io.fabric8.kubernetes.client.utils.SerializationYamlTest$NonStandardJavaClass [ evil ]";
        HasMetadata resource = (HasMetadata)Serialization.unmarshal((String)"kind: MyCustomResource\napiVersion: my.custom.resource.example.com/v1\nspec:\n  complex: !!io.fabric8.kubernetes.client.utils.SerializationYamlTest$NonStandardJavaClass [ evil ]");
        Assertions.assertThat((Object)resource).hasFieldOrPropertyWithValue("additionalProperties.spec.complex.field", (Object)"evil");
    }

    @Test
    @DisplayName(value="unmarshal, SHOULD NOT evaluate non standard Java classes")
    void unmarshalShouldNotEvaluateNonStandardClasses() {
        String genericResourceYaml = "kind: MyCustomResource\napiVersion: my.custom.resource.example.com/v1\nspec:\n  complex: !!io.fabric8.kubernetes.client.utils.SerializationYamlTest$NonStandardJavaClass [ evil ]";
        Exception result = (Exception)org.junit.jupiter.api.Assertions.assertThrows(ConstructorException.class, () -> Serialization.unmarshal((String)"kind: MyCustomResource\napiVersion: my.custom.resource.example.com/v1\nspec:\n  complex: !!io.fabric8.kubernetes.client.utils.SerializationYamlTest$NonStandardJavaClass [ evil ]"));
        Assertions.assertThat((Throwable)result).hasMessageStartingWith("could not determine a constructor for the tag tag:yaml.org,2002:io.fabric8.kubernetes.client.utils.SerializationYamlTest$NonStandardJavaClass");
    }

    static final class NonStandardJavaClass {
        public String field;

        NonStandardJavaClass() {
        }

        NonStandardJavaClass(String field) {
            this.field = field;
        }
    }
}

