/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class SerializationAdditionalPropertiesTest {
    SerializationAdditionalPropertiesTest() {
    }

    @AfterEach
    void tearDown() {
        Serialization.UNMATCHED_FIELD_TYPE_MODULE.setRestrictToTemplates(true);
    }

    @Test
    @DisplayName(value="unmarshal, with unknown fields, values are set in additionalProperties map")
    void unmarshalWithUnknownFields() {
        String marshalled = "{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\"}";
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)"{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\"}");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(ConfigMap.class)).hasFieldOrPropertyWithValue("metadata.name", (Object)"the-name")).hasFieldOrPropertyWithValue("data.key", (Object)"value")).hasFieldOrPropertyWithValue("additionalProperties.unknownField", (Object)"unknownValue");
    }

    @Test
    @DisplayName(value="unmarshal, with unmatched type fields, should throw Exception")
    void unmarshalWithUnmatchedTypeFieldsAndDefaults() {
        String marshalled = "{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"immutable\":\"${immutable}\"}";
        KubernetesClientException result = (KubernetesClientException)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, () -> Serialization.unmarshal((String)"{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"immutable\":\"${immutable}\"}"));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)result).cause().isInstanceOf(InvalidFormatException.class)).hasMessageStartingWith("Cannot deserialize value of type `java.lang.Boolean` from String \"${immutable}\"");
    }

    @Test
    @DisplayName(value="unmarshal, with unmatched type fields and unrestricted, values are set in additionalProperties map")
    void unmarshalWithUnmatchedTypeFields() {
        Serialization.UNMATCHED_FIELD_TYPE_MODULE.setRestrictToTemplates(false);
        String marshalled = "{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\",\"immutable\":\"${immutable}\"}";
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)"{\"kind\": \"ConfigMap\",\"apiVersion\": \"v1\",\"metadata\":{\"name\":\"the-name\"},\"data\":{\"key\":\"value\"},\"unknownField\":\"unknownValue\",\"immutable\":\"${immutable}\"}");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(ConfigMap.class)).hasFieldOrPropertyWithValue("metadata.name", (Object)"the-name")).hasFieldOrPropertyWithValue("immutable", null)).hasFieldOrPropertyWithValue("additionalProperties.unknownField", (Object)"unknownValue")).hasFieldOrPropertyWithValue("additionalProperties.immutable", (Object)"${immutable}");
    }

    @Test
    @DisplayName(value="unmarshal, with unmatched type nested fields and unrestricted, values are set in additionalProperties map")
    void unmarshalWithUnmatchedTypeNestedFields() {
        Serialization.UNMATCHED_FIELD_TYPE_MODULE.setRestrictToTemplates(false);
        String marshalled = "{\"kind\": \"Deployment\",\"apiVersion\": \"apps/v1\",\"metadata\":{\"name\":\"deployment\", \"annotations\": \"${annotations}\"},\"spec\":{\"replicas\":\"${replicas}\",\"paused\":true},\"unknownField\":\"unknownValue\"}";
        KubernetesResource result = (KubernetesResource)Serialization.unmarshal((String)"{\"kind\": \"Deployment\",\"apiVersion\": \"apps/v1\",\"metadata\":{\"name\":\"deployment\", \"annotations\": \"${annotations}\"},\"spec\":{\"replicas\":\"${replicas}\",\"paused\":true},\"unknownField\":\"unknownValue\"}");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)result).isInstanceOf(Deployment.class)).hasFieldOrPropertyWithValue("metadata.name", (Object)"deployment")).hasFieldOrPropertyWithValue("metadata.annotations", Collections.emptyMap())).hasFieldOrPropertyWithValue("metadata.additionalProperties.annotations", (Object)"${annotations}")).hasFieldOrPropertyWithValue("spec.paused", (Object)true)).hasFieldOrPropertyWithValue("spec.replicas", null)).hasFieldOrPropertyWithValue("spec.additionalProperties.replicas", (Object)"${replicas}")).hasFieldOrPropertyWithValue("additionalProperties.unknownField", (Object)"unknownValue");
    }

    @Test
    @DisplayName(value="marshal, with unmatched type fields, values are set in additionalProperties map")
    void marshalWithAdditionalPropertiesOverridingFields() {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("name")).addToAnnotations("key", "value")).endMetadata()).withImmutable(Boolean.valueOf(true))).build();
        configMap.getAdditionalProperties().put("immutable", "${immutable}");
        configMap.getAdditionalProperties().put("unknownField", "unknownValue");
        configMap.getMetadata().getAdditionalProperties().put("annotations", "${annotations}");
        String result = Serialization.asJson((Object)configMap);
        Assertions.assertThat((String)result).isEqualTo("{\"apiVersion\":\"v1\",\"kind\":\"ConfigMap\",\"metadata\":{\"name\":\"name\",\"annotations\":\"${annotations}\"},\"immutable\":\"${immutable}\",\"unknownField\":\"unknownValue\"}");
    }

    @Test
    @DisplayName(value="clone, with unmatched type fields and unrestricted, values are in additionalProperties map are cloned")
    void cloneShouldPreserveAdditionalProperties() {
        Serialization.UNMATCHED_FIELD_TYPE_MODULE.setRestrictToTemplates(false);
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("name")).addToAnnotations("key", "value")).endMetadata()).build();
        configMap.getMetadata().getAdditionalProperties().put("annotations", "${annotations}");
        configMap.getAdditionalProperties().put("immutable", "${immutable}");
        configMap.getAdditionalProperties().put("unknownField", "unknownValue");
        ConfigMap result = (ConfigMap)Serialization.clone((Object)configMap);
        ((MapAssert)((ObjectAssert)Assertions.assertThat((Object)result).satisfies(new ThrowingConsumer[]{cm -> ((MapAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)cm.getMetadata()).returns(Collections.emptyMap(), ObjectMeta::getAnnotations)).hasFieldOrPropertyWithValue("name", (Object)"name")).extracting(ObjectMeta::getAdditionalProperties).asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).containsExactly(new Map.Entry[]{Assertions.entry((Object)"annotations", (Object)"${annotations}")})})).extracting(ConfigMap::getAdditionalProperties).asInstanceOf(InstanceOfAssertFactories.map(String.class, Object.class))).containsExactly(new Map.Entry[]{Assertions.entry((Object)"immutable", (Object)"${immutable}"), Assertions.entry((Object)"unknownField", (Object)"unknownValue")});
    }

    @Test
    @DisplayName(value="clone, with unmatched type fields, should throw Exception")
    void cloneShouldThrowException() {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName("name")).endMetadata()).build();
        configMap.getAdditionalProperties().put("immutable", "${immutable}");
        configMap.getAdditionalProperties().put("unknownField", "unknownValue");
        IllegalStateException result = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> Serialization.clone((Object)configMap));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)result).cause().isInstanceOf(InvalidFormatException.class)).hasMessageStartingWith("Cannot deserialize value of type `java.lang.Boolean` from String \"${immutable}\"");
    }
}

