/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;

public class TestStandardHttpClientFactory
implements HttpClient.Factory {
    private final Mode mode;
    private final ConcurrentLinkedQueue<TestStandardHttpClient> instances;

    public TestStandardHttpClientFactory() {
        this(Mode.MULTIPLE);
    }

    public TestStandardHttpClientFactory(Mode mode) {
        this.mode = mode == null ? Mode.MULTIPLE : mode;
        this.instances = new ConcurrentLinkedQueue();
        if (mode == Mode.SINGLETON) {
            this.newBuilder().build();
        }
    }

    public TestStandardHttpClientBuilder newBuilder() {
        return new TestStandardHttpClientBuilder(this, this.instances);
    }

    public final TestStandardHttpClient getInstance(int index) {
        return this.instances.toArray(new TestStandardHttpClient[0])[index];
    }

    public final Stream<TestStandardHttpClientFactory> times(int iterations) {
        return IntStream.range(0, iterations).mapToObj(i -> this);
    }

    public final void expect(String pathRegex, int statusCode) {
        this.instances.forEach(c -> c.expect(pathRegex, statusCode));
    }

    public final void expect(String pathRegex, int statusCode, String body) {
        this.instances.forEach(c -> c.expect(pathRegex, statusCode, body));
    }

    public final void expect(String pathRegex, int statusCode, byte[] body) {
        this.instances.forEach(c -> c.expect(pathRegex, statusCode, body));
    }

    public final void expect(String pathRegex, CompletableFuture<HttpResponse<AsyncBody>> future) {
        this.instances.forEach(c -> c.expect(pathRegex, future));
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public ConcurrentLinkedQueue<TestStandardHttpClient> getInstances() {
        return this.instances;
    }

    public static enum Mode {
        MULTIPLE,
        SINGLETON;

    }
}

