/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpHeaders;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TestHttpResponse<T>
extends StandardHttpHeaders
implements HttpResponse<T> {
    private final Map<String, List<String>> headers;
    private int code;
    private T body;
    private HttpRequest request;
    private HttpResponse<T> previousResponse;

    public TestHttpResponse() {
        this(new LinkedHashMap<String, List<String>>());
    }

    public TestHttpResponse(Map<String, List<String>> headers) {
        super(headers);
        this.headers = headers;
    }

    public int code() {
        return this.code;
    }

    public T body() {
        return this.body;
    }

    public HttpRequest request() {
        return this.request;
    }

    public Optional<HttpResponse<?>> previousResponse() {
        return Optional.ofNullable(this.previousResponse);
    }

    public int getCode() {
        return this.code;
    }

    public TestHttpResponse<T> withCode(int code) {
        this.code = code;
        return this;
    }

    public T getBody() {
        return this.body;
    }

    public TestHttpResponse<T> withBody(T body) {
        this.body = body;
        return this;
    }

    public TestHttpResponse<T> withRequest(HttpRequest request) {
        this.request = request;
        return this;
    }

    public HttpResponse<T> getPreviousResponse() {
        return this.previousResponse;
    }

    public TestHttpResponse<T> withPreviousResponse(HttpResponse<T> previousResponse) {
        this.previousResponse = previousResponse;
        return this;
    }

    public TestHttpResponse<T> withHeader(String name, String value) {
        this.headers.compute(name, (k, v) -> {
            if (v == null) {
                v = new ArrayList<String>();
            }
            v.add(value);
            return v;
        });
        return this;
    }

    public static TestHttpResponse<byte[]> from(int code, String body) {
        return new TestHttpResponse().withCode(code).withBody(body.getBytes(StandardCharsets.UTF_8));
    }
}

