/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.mockwebserver.DefaultMockServer;
import io.fabric8.mockwebserver.dsl.EventDoneable;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.mockwebserver.dsl.TimesOrOnceable;
import io.fabric8.mockwebserver.dsl.WebSocketSessionBuilder;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractHttpClientNewWebSocketBuilderTest {
    private static DefaultMockServer server;
    private HttpClient httpClient;

    @BeforeAll
    static void beforeAll() {
        server = new DefaultMockServer(false);
        server.start();
    }

    @AfterAll
    static void afterAll() {
        server.shutdown();
    }

    @BeforeEach
    void setUp() {
        this.httpClient = this.getHttpClientFactory().newBuilder().build();
    }

    @AfterEach
    void tearDown() {
        this.httpClient.close();
    }

    protected abstract HttpClient.Factory getHttpClientFactory();

    @Test
    void buildAsyncConnectsAndUpgrades() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-test")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        final AtomicBoolean open = new AtomicBoolean(false);
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/websocket-test"))).buildAsync(new WebSocket.Listener(){

            public void onOpen(WebSocket webSocket) {
                open.set(true);
            }
        }).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((AtomicBoolean)open).isTrue();
    }

    @Test
    void buildAsyncReceivesMultipleMessages() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-multiple-message")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(10L).andEmit((Object)"First")).waitFor(10L).andEmit((Object)"Second")).done()).always();
        final CountDownLatch latch = new CountDownLatch(2);
        final ConcurrentHashMap.KeySetView messages = ConcurrentHashMap.newKeySet();
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/websocket-multiple-message"))).buildAsync(new WebSocket.Listener(){

            public void onMessage(WebSocket webSocket, String text) {
                messages.add(text);
                webSocket.request();
                latch.countDown();
            }
        }).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)latch.await(60L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat(messages).containsExactlyInAnyOrder((Object[])new String[]{"First", "Second"});
    }

    @Test
    void buildAsyncConnectsAndCloses() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((TimesOrOnceable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-on-close")).andUpgradeToWebSocket()).open(new Object[0])).expectSentWebSocketMessage((Object)"NEVER RECEIVED; JUST TO KEEP THE CONNECTION OPEN").andEmit((Object)"OK")).once()).done()).always();
        final CompletableFuture closeMessage = new CompletableFuture();
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/websocket-on-close"))).buildAsync(new WebSocket.Listener(){

            public void onOpen(WebSocket webSocket) {
                webSocket.sendClose(1000, "Closing from client");
            }

            public void onClose(WebSocket webSocket, int code, String reason) {
                closeMessage.complete(reason);
            }
        }).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat(closeMessage).succeedsWithin(10L, TimeUnit.SECONDS).asString().isEqualTo("Closing from client");
    }

    @Test
    void buildAsyncCantUpgradeThrowsWebSocketHandshakeException() {
        CompletableFuture future = this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/not-found"))).buildAsync(new WebSocket.Listener(){});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> future.get(10L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).hasCauseInstanceOf(WebSocketHandshakeException.class);
    }

    @Test
    void buildAsyncIncludesRequiredHeaders() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-headers-test")).andUpgradeToWebSocket()).open(new Object[0])).waitFor(50L).andEmit((Object)"OK")).done()).always();
        this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/websocket-headers-test"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"upgrade", Collections.singletonList("websocket"))).containsEntry((Object)"sec-websocket-version", Collections.singletonList("13"))).containsKey((Object)"sec-websocket-key")).containsAnyOf(new Map.Entry[]{Assertions.entry((Object)"connection", Collections.singletonList("Upgrade")), Assertions.entry((Object)"connection", Collections.singletonList("upgrade"))});
    }

    @Test
    void buildAsyncPropagatesConfiguredHeaders() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-headers-test")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        this.httpClient.newWebSocketBuilder().header("A-Random-Header", "A-Random-Value").uri(URI.create(server.url("/websocket-headers-test"))).buildAsync(new WebSocket.Listener(){}).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"a-random-header", Collections.singletonList("A-Random-Value"));
    }

    @Test
    void buildAsyncIncludesSubprotocolHeader() throws Exception {
        ((TimesOnceableOrHttpHeaderable)((EventDoneable)((WebSocketSessionBuilder)((ReturnOrWebsocketable)server.expect().withPath("/websocket-headers-test")).andUpgradeToWebSocket()).open(new Object[0])).done()).always();
        ((CompletableFuture)this.httpClient.newWebSocketBuilder().subprotocol("amqp").uri(URI.create(server.url("/websocket-headers-test"))).buildAsync(new WebSocket.Listener(){}).handle((w, t) -> null)).get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((Map)server.getLastRequest().getHeaders().toMultimap()).containsEntry((Object)"sec-websocket-protocol", Collections.singletonList("amqp"));
    }

    @Test
    void buildAsyncPreservesHandshakeExceptionWhenUpgradeFails() {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)server.expect().withPath("/not-a-websocket")).andReturn(200, (Object)"not a websocket")).always();
        CompletableFuture ws = this.httpClient.newWebSocketBuilder().uri(URI.create(server.url("/not-a-websocket"))).buildAsync(new WebSocket.Listener(){});
        ((ObjectAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ws.get(10L, TimeUnit.SECONDS)).isInstanceOf(ExecutionException.class)).cause().asInstanceOf(InstanceOfAssertFactories.type(WebSocketHandshakeException.class))).extracting(WebSocketHandshakeException::getResponse).extracting(HttpResponse::code).isEqualTo((Object)200);
    }
}

