/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import io.fabric8.kubernetes.api.model.APIResource;
import io.fabric8.kubernetes.api.model.APIResourceBuilder;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceDefinitionContextTest {
    ResourceDefinitionContextTest() {
    }

    @Test
    void missingRequiredKindShouldFail() {
        ResourceDefinitionContext.Builder builder = new ResourceDefinitionContext.Builder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> builder.build());
        builder.withKind("Kind");
        ResourceDefinitionContext context = builder.build();
        Assertions.assertEquals((Object)"kinds", (Object)context.getPlural());
    }

    @Test
    void fromCoreApiResource() {
        ResourceDefinitionContext context = ResourceDefinitionContext.fromApiResource((String)"v1", (APIResource)((APIResourceBuilder)((APIResourceBuilder)((APIResourceBuilder)new APIResourceBuilder().withKind("builtin")).withName("builtins")).withNamespaced(Boolean.valueOf(true))).build());
        Assertions.assertEquals((Object)"builtins", (Object)context.getPlural());
        Assertions.assertEquals((Object)"builtin", (Object)context.getKind());
        Assertions.assertTrue((boolean)context.isNamespaceScoped());
        Assertions.assertEquals((Object)"", (Object)context.getGroup());
        Assertions.assertEquals((Object)"v1", (Object)context.getVersion());
    }
}

