/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClient;
import io.fabric8.kubernetes.client.http.TestStandardHttpClientFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class KubernetesClientBuilderTest {
    KubernetesClientBuilderTest() {
    }

    @Test
    void httpClientConfiguration() {
        KubernetesClientBuilder builder = new KubernetesClientBuilder(null);
        builder.withConfig(Config.empty());
        builder.withHttpClientFactory((HttpClient.Factory)new TestStandardHttpClientFactory());
        builder.withHttpClientBuilderConsumer(b -> b.tag((Object)"string-tag-value"));
        ((ObjectAssert)Assertions.assertThat((Object)builder.getHttpClient()).asInstanceOf(InstanceOfAssertFactories.type(TestStandardHttpClient.class))).returns((Object)"string-tag-value", c -> (String)c.getTag(String.class));
    }

    @Test
    void nestedConfigPreservesOriginalValues() {
        KubernetesClientBuilder builder = new KubernetesClientBuilder(null);
        builder.withConfig(((ConfigBuilder)new ConfigBuilder().withWatchReconnectLimit(600)).build());
        ((KubernetesClientBuilder.ConfigNested)builder.editOrNewConfig().withApiVersion("x.y")).endConfig();
        KubernetesClientBuilder.ConfigNested configNested = builder.editOrNewConfig();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"x.y", (Object)configNested.getApiVersion());
        org.junit.jupiter.api.Assertions.assertEquals((int)600, (Integer)configNested.getWatchReconnectLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testNullContextClassLoader() {
        ClassLoader currContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(null);
            Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(KubernetesClientException.class, KubernetesClientBuilder::new);
            Throwable t = e.getCause();
            org.junit.jupiter.api.Assertions.assertEquals(ClassNotFoundException.class, t.getClass());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"io.fabric8.kubernetes.client.impl.KubernetesClientImpl", (Object)t.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(currContextClassLoader);
        }
    }
}

