/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.client.Config;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

class ConfigFromKubeconfigTest {
    ConfigFromKubeconfigTest() {
    }

    @Nested
    class SingleContextConfig {
        private Config config;

        SingleContextConfig() {
        }

        @BeforeEach
        void setUp() {
            this.config = Config.fromKubeconfig((File)new File(Objects.requireNonNull(ConfigFromKubeconfigTest.class.getResource("/config-from-kubeconfig/single-context-config.yaml")).getFile()));
        }

        @Test
        void setsFile() {
            Assertions.assertThat((File)this.config.getFile()).isEqualTo((Object)new File(Objects.requireNonNull(ConfigFromKubeconfigTest.class.getResource("/config-from-kubeconfig/single-context-config.yaml")).getFile()));
        }

        @Test
        void loadsContexts() {
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat((List)this.config.getContexts()).singleElement()).hasFieldOrPropertyWithValue("name", (Object)"the-context")).extracting(NamedContext::getContext).hasFieldOrPropertyWithValue("cluster", (Object)"the-cluster").hasFieldOrPropertyWithValue("namespace", (Object)"the-context-default-namespace");
        }

        @Test
        void setsNamespace() {
            Assertions.assertThat((String)this.config.getNamespace()).isEqualTo("the-context-default-namespace");
        }

        @Test
        void setsCurrentContext() {
            ((ObjectAssert)Assertions.assertThat((Object)this.config.getCurrentContext()).hasFieldOrPropertyWithValue("name", (Object)"the-context")).extracting(NamedContext::getContext).hasFieldOrPropertyWithValue("cluster", (Object)"the-cluster").hasFieldOrPropertyWithValue("user", (Object)"the-user").hasFieldOrPropertyWithValue("namespace", (Object)"the-context-default-namespace");
        }

        @Test
        void setsClusterInformation() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.config).hasFieldOrPropertyWithValue("masterUrl", (Object)"https://cluster.example.com/")).hasFieldOrPropertyWithValue("trustCerts", (Object)false)).hasFieldOrPropertyWithValue("disableHostnameVerification", (Object)false)).hasFieldOrPropertyWithValue("caCertFile", (Object)new File(this.config.getFile().getParent(), "ca.crt").getAbsolutePath())).hasFieldOrPropertyWithValue("caCertData", (Object)"SOME_BASE64_ENCODED_CERT_DATA_FOR_CA_CERT")).hasFieldOrPropertyWithValue("httpsProxy", (Object)"socks5://proxy.example.com");
        }

        @Test
        void setsAuthInformation() {
            ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)this.config).hasFieldOrPropertyWithValue("clientCertFile", (Object)new File(this.config.getFile().getParent(), "client.crt").getAbsolutePath())).hasFieldOrPropertyWithValue("clientCertData", (Object)"SOME_BASE64_ENCODED_CERT_DATA_FOR_CLIENT_CERT")).hasFieldOrPropertyWithValue("clientKeyData", (Object)"QkVHSU4gUlNBIFBSSVZBVEUgS0VZCg==")).hasFieldOrPropertyWithValue("clientKeyAlgo", (Object)"RSA")).hasFieldOrPropertyWithValue("autoOAuthToken", (Object)"the-user-token")).hasFieldOrPropertyWithValue("username", (Object)"the-username")).hasFieldOrPropertyWithValue("password", (Object)"the-pa33word");
        }

        @Test
        @DisabledOnOs(value={OS.WINDOWS})
        void setsAuthInformationClientKeyFileAbsolute() {
            Assertions.assertThat((Object)this.config).hasFieldOrPropertyWithValue("clientKeyFile", (Object)"/absolute/path/client.key");
        }
    }
}

